/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportOptimizer
implements ImportOptimizer {
    public final boolean supports(PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        JSFile jsFile = (JSFile)file;
        return this.checkDialect(DialectDetector.dialectOfFile((PsiFile)jsFile));
    }

    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        if (!file.isValid() || DumbService.getInstance((Project)file.getProject()).isDumb()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
            }
            return runnable;
        }
        PsiElement[] declarations = JSResolveUtil.getStubbedChildren((PsiElement)file, TypeScriptAutoImportUtil.ES6_IMPORT_DECLARATION);
        if (declarations.length == 0) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
            }
            return runnable;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        for (PsiElement declaration : declarations) {
            if (!(declaration instanceof ES6ImportDeclaration)) continue;
            infos.add(ES6UnusedImportsHelper.getInfo((ES6ImportDeclaration)declaration));
        }
        List<String> importTexts = this.buildNewImportsText(file, infos);
        Project project = file.getProject();
        Runnable runnable = () -> {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
                return;
            }
            if (!importTexts.isEmpty()) {
                PsiFile newFile = JSChangeUtil.createJSFileFromText(project, StringUtil.join((Collection)importTexts, (String)"\n"), DialectDetector.getLanguageDialect((PsiElement)file));
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat((PsiElement)newFile);
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                assert (item != null);
                ES6ImportDeclaration anchor = item.getDeclaration();
                anchor.getParent().addRangeBefore(newFile.getFirstChild(), newFile.getLastChild(), (PsiElement)anchor);
            }
            for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
                ES6ImportDeclaration declaration = info.getDeclaration();
                ES6ImportOptimizer.deleteSiblingWhitespaceBetweenImports((PsiElement)declaration, true, true);
                declaration.delete();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processFile"));
        }
        return runnable;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSApplicationSettings.getInstance().isMergeImports();
        ArrayList importsResult = ContainerUtil.newArrayList();
        HashSet visitedImports = ContainerUtil.newHashSet();
        HashSet visitedSideEffectImports = ContainerUtil.newHashSet();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            Collection mergedImports;
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(info.getDeclaration().getImportModuleText())) continue;
                ES6ImportOptimizer.addSideEffectImport(file, importsResult, info);
                continue;
            }
            String fromText = ES6ImportOptimizer.getUnquotedFromClauseText(info.getDeclaration());
            if (fromText == null || !visitedImports.add(fromText) || (mergedImports = result.get((Object)fromText)).isEmpty()) continue;
            if (merge) {
                this.processMergedImports(file, importsResult, fromText, mergedImports);
                continue;
            }
            for (ES6UnusedImportsHelper.UnusedInfo mergedInfo : mergedImports) {
                importsResult.addAll(this.getImportBodyText(file, ContainerUtil.createMaybeSingletonList((Object)mergedInfo), fromText));
            }
        }
        ArrayList arrayList = importsResult;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        return arrayList;
    }

    protected void processMergedImports(@NotNull PsiFile file, List<String> importsResult, String fromText, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "processMergedImports"));
        }
        importsResult.addAll(this.getImportBodyText(file, mergedImports, fromText));
    }

    private static void addSideEffectImport(@NotNull PsiFile file, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (importsResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResult", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        String name = declaration.getImportModuleText();
        if (!StringUtil.isEmpty((String)name)) {
            StringBuilder builder = new StringBuilder();
            builder.append("import ");
            ES6ImportOptimizer.addFromPartWithoutKeyword(file, StringUtil.unquoteString((String)name), builder);
            importsResult.add(builder.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        LinkedMultiMap results = new LinkedMultiMap();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportOptimizer.getUnquotedFromClauseText(declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        LinkedMultiMap linkedMultiMap = results;
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        return linkedMultiMap;
    }

    @Nullable
    private static String getUnquotedFromClauseText(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getUnquotedFromClauseText"));
        }
        ES6FromClause fromClause = declaration.getFromClause();
        if (fromClause == null) {
            return null;
        }
        String text = fromClause.getReferenceText();
        if (text != null) {
            return StringUtil.unquoteString((String)text);
        }
        return null;
    }

    @NotNull
    protected List<String> getImportBodyText(PsiFile file, Collection<ES6UnusedImportsHelper.UnusedInfo> imports, String fromPart) {
        ArrayList listOfImports = ContainerUtil.newArrayList();
        StringBuilder importBody = new StringBuilder();
        boolean needCommaBeforeBinding = false;
        boolean lastIsAll = false;
        HashSet names = ContainerUtil.newHashSet();
        for (ES6UnusedImportsHelper.UnusedInfo importDeclaration : imports) {
            ES6ImportDeclaration declaration = importDeclaration.getDeclaration();
            Collection<ES6ImportedBinding> unusedBindings = importDeclaration.getUnusedBindings();
            for (ES6ImportedBinding binding : declaration.getImportedBindings()) {
                if (unusedBindings.contains(binding) || !names.add(binding.getName())) continue;
                if (needCommaBeforeBinding) {
                    ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
                    listOfImports.add(this.getImportPrefix(imports) + importBody.toString());
                    importBody.setLength(0);
                } else {
                    needCommaBeforeBinding = true;
                }
                importBody.append(binding.getText());
                lastIsAll = binding.isNamespaceImport();
            }
        }
        if (lastIsAll) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            listOfImports.add(this.getImportPrefix(imports) + importBody.toString());
            needCommaBeforeBinding = false;
            importBody.setLength(0);
        }
        names.clear();
        boolean needOpenSpecifierList = true;
        boolean needCommaBeforeSpecifier = false;
        for (ES6UnusedImportsHelper.UnusedInfo importDeclaration : imports) {
            ES6ImportDeclaration declaration = importDeclaration.getDeclaration();
            Collection<ES6ImportSpecifier> unusedSpecifiers = importDeclaration.getUnusedSpecifiers();
            for (ES6ImportSpecifier specifier : declaration.getImportSpecifiers()) {
                String name;
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                String string = name = alias == null ? specifier.getReferenceName() : alias.getName();
                if (unusedSpecifiers.contains(specifier) || !names.add(name)) continue;
                if (needOpenSpecifierList) {
                    needOpenSpecifierList = false;
                    if (needCommaBeforeBinding) {
                        importBody.append(", ");
                    }
                    importBody.append('{');
                }
                if (needCommaBeforeSpecifier) {
                    importBody.append(", ");
                } else {
                    needCommaBeforeSpecifier = true;
                }
                importBody.append(specifier.getText());
            }
        }
        if (!needOpenSpecifierList) {
            importBody.append('}');
        }
        if (!StringUtil.isEmpty((CharSequence)importBody)) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            listOfImports.add(this.getImportPrefix(imports) + importBody.toString());
        }
        ArrayList arrayList = listOfImports;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        return arrayList;
    }

    @NotNull
    protected String getImportPrefix(Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if ("import " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        return "import ";
    }

    private static void addFromPart(PsiFile file, String fromPart, StringBuilder importBody) {
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(file, fromPart, importBody);
    }

    private static void addFromPartWithoutKeyword(PsiFile file, String fromPart, StringBuilder importBody) {
        String quote = JSCodeStyleSettings.getQuote((PsiElement)file);
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
        importBody.append(JSCodeStyleSettings.getSemicolon(file));
    }

    public static void deleteSiblingWhitespaceBetweenImports(PsiElement element, boolean deleteBefore, boolean deleteAfter) {
        PsiElement sibling = element;
        if (deleteBefore) {
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                PsiElement prev = sibling.getPrevSibling();
                if (!ES6ImportOptimizer.isImportOrWhiteSpace(prev)) continue;
                sibling.delete();
            }
        }
        if (deleteAfter) {
            sibling = element;
            while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
                PsiElement nextSibling = sibling.getNextSibling();
                if (!ES6ImportOptimizer.isImportOrWhiteSpace(nextSibling)) continue;
                sibling.delete();
            }
        }
    }

    public static boolean isImportOrWhiteSpace(PsiElement prev) {
        return prev == null || prev instanceof ES6ImportDeclaration || prev instanceof PsiWhiteSpace;
    }
}

