/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6UnusedImportsHelper {
    private static ParameterizedCachedValueProvider<Collection<String>, JSElement> PROVIDER_JSX_TAGS = new ParameterizedCachedValueProvider<Collection<String>, JSElement>(){

        @Nullable
        public CachedValueProvider.Result<Collection<String>> compute(JSElement param) {
            return CachedValueProvider.Result.create((Object)ES6UnusedImportsHelper.calcUsedJSXTags(param), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    public static final Key<ParameterizedCachedValue<Collection<String>, JSElement>> TAGS_JSX_KEY = Key.create((String)"typescript.possible.tags");

    @NotNull
    public static UnusedInfo getInfo(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "getInfo"));
        }
        UnusedInfo info = new UnusedInfo(declaration);
        info.fillUsages();
        UnusedInfo unusedInfo = info;
        if (unusedInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "getInfo"));
        }
        return unusedInfo;
    }

    private static boolean isUnusedAlias(@NotNull ES6ImportSpecifierAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "isUnusedAlias"));
        }
        return ES6UnusedImportsHelper.isUnusedInContainerImpl(alias.getName(), (PsiElement)alias);
    }

    private static boolean isUnusedSpecifier(@NotNull ES6ImportSpecifier specifier) {
        Collection<String> tags;
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "isUnusedSpecifier"));
        }
        ResolveResult[] results = specifier.multiResolve(false);
        if (results.length == 0) {
            return false;
        }
        PsiElement container = TypeScriptPsiUtil.getTopLevelContainer((PsiElement)specifier);
        if (container == null) {
            return false;
        }
        if (container instanceof JSElement && (tags = ES6UnusedImportsHelper.getUsedJSXTags((JSElement)container)).contains(specifier.getReferenceName())) {
            return false;
        }
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!ES6UnusedImportsHelper.isValid(result, element)) continue;
            Collection<PsiReference> references = ES6UnusedImportsHelper.getLocalReferences(element, container);
            for (PsiReference reference : references) {
                PsiElement containerForReference;
                PsiElement referenceElement = reference.getElement();
                if (referenceElement instanceof ES6ImportSpecifier && container == (containerForReference = TypeScriptPsiUtil.getTopLevelContainer(referenceElement)) || referenceElement == null || !ES6UnusedImportsHelper.isReferenceCanBeResolvedToSpecifier(referenceElement, (PsiElement)specifier, reference.getCanonicalText())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isValid(ResolveResult result, PsiElement element) {
        JSResolveResult jsResolveResult;
        String key;
        if (element == null) {
            return false;
        }
        if (result.isValidResult()) {
            return true;
        }
        return result instanceof JSResolveResult && (key = (jsResolveResult = (JSResolveResult)result).getResolveProblemKey()) == "javascript.element.need.to.be.included.to.config";
    }

    private static boolean isUnusedImportedBinding(@NotNull ES6ImportedBinding binding) {
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "isUnusedImportedBinding"));
        }
        String name = binding.getName();
        if ("React".equals(name)) {
            return false;
        }
        return ES6UnusedImportsHelper.isUnusedInContainerImpl(name, (PsiElement)binding);
    }

    private static boolean isReferenceCanBeResolvedToSpecifier(@NotNull PsiElement refElement, @NotNull PsiElement importSpecifier, @NotNull String name) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "isReferenceCanBeResolvedToSpecifier"));
        }
        if (importSpecifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importSpecifier", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "isReferenceCanBeResolvedToSpecifier"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "isReferenceCanBeResolvedToSpecifier"));
        }
        ResolveResultSink sink = new ResolveResultSink(refElement, name);
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(sink);
        processor.setTypeContext(true);
        processor.setLocalResolve(true);
        return !processor.execute(importSpecifier, ResolveState.initial());
    }

    private static boolean isUnusedInContainerImpl(String name, @NotNull PsiElement refElement) {
        Collection<String> tags;
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "isUnusedInContainerImpl"));
        }
        PsiElement container = TypeScriptPsiUtil.getTopLevelContainer(refElement);
        if (container == null) {
            return false;
        }
        if (!StringUtil.isEmpty((String)name) && container instanceof JSElement && (tags = ES6UnusedImportsHelper.getUsedJSXTags((JSElement)container)).contains(name)) {
            return false;
        }
        return ES6UnusedImportsHelper.getLocalReferences(refElement, container).isEmpty();
    }

    private static Collection<PsiReference> getLocalReferences(@NotNull PsiElement refElement, @NotNull PsiElement container) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "getLocalReferences"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper", "getLocalReferences"));
        }
        LocalSearchScope scope = new LocalSearchScope(container);
        return ReferencesSearch.search((PsiElement)refElement, (SearchScope)scope, (boolean)true).findAll();
    }

    public static Collection<String> getUsedJSXTags(JSElement element) {
        return (Collection)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)element, TAGS_JSX_KEY, PROVIDER_JSX_TAGS, false, (Object)element);
    }

    private static Collection<String> calcUsedJSXTags(JSElement container) {
        final HashSet results = ContainerUtil.newHashSet();
        container.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                List strings;
                String name;
                if (node instanceof XmlTag && !StringUtil.isEmpty((String)(name = node.getName())) && (strings = StringUtil.split((String)name, (String)".")).size() > 0) {
                    results.add(ContainerUtil.getFirstItem((List)strings));
                }
                super.visitJSLiteralExpression(node);
            }

            public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
            }
        });
        return results;
    }

    public static class UnusedInfo {
        @NotNull
        private final ES6ImportDeclaration myDeclaration;
        private final Collection<ES6ImportedBinding> myUnusedBindings;
        private final Collection<ES6ImportSpecifier> myUnusedSpecifiers;
        private boolean myIsUnused;
        private boolean mySideEffectImport;

        @NotNull
        public ES6ImportDeclaration getDeclaration() {
            ES6ImportDeclaration eS6ImportDeclaration = this.myDeclaration;
            if (eS6ImportDeclaration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo", "getDeclaration"));
            }
            return eS6ImportDeclaration;
        }

        public Collection<ES6ImportedBinding> getUnusedBindings() {
            return this.myUnusedBindings;
        }

        public Collection<ES6ImportSpecifier> getUnusedSpecifiers() {
            return this.myUnusedSpecifiers;
        }

        public boolean isAllUnused() {
            return this.myIsUnused;
        }

        public UnusedInfo(@NotNull ES6ImportDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo", "<init>"));
            }
            this.myUnusedBindings = ContainerUtil.newHashSet();
            this.myUnusedSpecifiers = ContainerUtil.newHashSet();
            this.myDeclaration = declaration;
        }

        public boolean isSideEffectImport() {
            return this.mySideEffectImport;
        }

        private void fillUsages() {
            ES6ImportedBinding[] bindings;
            ES6ImportSpecifier[] specifiers;
            boolean hasUsages = false;
            for (ES6ImportSpecifier specifier : specifiers = this.myDeclaration.getImportSpecifiers()) {
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                if (alias != null && ES6UnusedImportsHelper.isUnusedAlias(alias) || alias == null && ES6UnusedImportsHelper.isUnusedSpecifier(specifier)) {
                    this.myUnusedSpecifiers.add(specifier);
                    continue;
                }
                hasUsages = true;
            }
            for (ES6ImportedBinding binding : bindings = this.myDeclaration.getImportedBindings()) {
                if (ES6UnusedImportsHelper.isUnusedImportedBinding(binding)) {
                    this.myUnusedBindings.add(binding);
                    continue;
                }
                hasUsages = true;
            }
            if (bindings.length > 0 || specifiers.length > 0) {
                this.myIsUnused = !hasUsages;
            } else {
                this.mySideEffectImport = true;
            }
        }
    }
}

