/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.types.ES6ImportDeclarationElementType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAutoImportUtil {
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptElementTypes.EXPORT_ASSIGNMENT});
    public static final TokenSet ES6_IMPORT_DECLARATION = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION});
    private static final String INDEX_FILE_D_TS = "index.d.ts";
    public static final String[] NODE_MODULES = new String[]{"node_modules"};

    public static boolean isAvailableForImport(@NotNull JSElement elementToImport, JSReferencePlaceInfo placeInfo, @NotNull Project project) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        assert (DialectDetector.isTypeScript((PsiElement)elementToImport));
        PsiElement placeElement = placeInfo.place;
        if (placeElement instanceof JSReferenceExpression && ((JSReferenceExpression)placeElement).getQualifier() != null) {
            return false;
        }
        if (TypeScriptModuleAccessibilityChecker.checkElementCanBeExported((PsiElement)elementToImport)) {
            boolean isClassType = elementToImport instanceof JSClass;
            if (!TypeScriptAutoImportUtil.isContextAcceptable(elementToImport, placeInfo, isClassType)) {
                return false;
            }
            if (TypeScriptAutoImportUtil.isExportedElement(project, (PsiElement)elementToImport, isClassType, placeInfo)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExportedElement(Project project, PsiElement elementToImport, boolean isClassType, JSReferencePlaceInfo placeInfo) {
        String refName;
        PsiElement parent = elementToImport.getParent();
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.container)) {
            return false;
        }
        if (parent instanceof TypeScriptModule && TypeScriptAugmentationUtil.isExternalModuleAugmentation((TypeScriptModule)parent)) {
            return false;
        }
        TypeScriptModuleAccessibilityChecker checker = TypeScriptModuleAccessibilityChecker.INSTANCE;
        if (checker.check(placeInfo.place, elementToImport) != null) {
            return false;
        }
        PsiFile file = elementToImport.getContainingFile();
        VirtualFile elementVirtualFile = file.getVirtualFile();
        if (!(file instanceof JSFile)) {
            return false;
        }
        if (!((JSFile)file).isCommonJSModule() && !TypeScriptConfigService.Provider.isAccessible(project, placeInfo.file, elementVirtualFile)) {
            return false;
        }
        if (ES6ImportHandler.isExported(elementToImport)) {
            return true;
        }
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent, elementToImport);
        if (assignment != null && elementToImport instanceof JSElement && (refName = assignment.getInitializerReference()) != null) {
            return refName.equals(((JSElement)elementToImport).getName());
        }
        return false;
    }

    public static boolean isContextAcceptable(@NotNull JSElement elementToImport, JSReferencePlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isContextAcceptable"));
        }
        if (elementToImport instanceof TypeScriptModule) {
            return false;
        }
        if (placeInfo.isStrictTypeContext && !isClassType) {
            return false;
        }
        return TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType);
    }

    private static boolean isElementCanBeUsedInContext(@NotNull JSElement elementToImport, @NotNull JSReferencePlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        if (placeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        PsiElement parentContext = placeInfo.parent;
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        if (isClassType && isCallContext && !isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptInterface) || !isCallContext;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(@NotNull PsiElement element, final Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(element)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$1", "contains"));
                }
                return super.contains(file) && TypeScriptAutoImportUtil.checkDefinitionForNodeModules(file, project);
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        return delegatingGlobalSearchScope;
    }

    public static boolean checkDefinitionForNodeModules(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (TypeScriptUtil.isUnderNodeModules(file, project)) {
            return TypeScriptUtil.isDefinitionFile(file);
        }
        return true;
    }

    public static void addImportStatement(String name, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        ES6ImportDeclaration possibleImport;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = place.getProject();
        JSQualifiedName qualifier = null;
        JSQualifiedName namespace = elementToImport.getNamespace();
        String externalModuleName = null;
        PsiFile externalModule = null;
        PsiElement elementContainer = TypeScriptPsiUtil.getTopLevelContainer((PsiElement)elementToImport);
        PsiElement placeContainer = TypeScriptPsiUtil.getTopLevelContainer(place);
        if (elementContainer == null || elementContainer.isEquivalentTo(placeContainer)) {
            return;
        }
        ImportType importType = TypeScriptAutoImportUtil.getImportType(elementToImport, elementContainer);
        if (importType == ImportType.IMPORT_BINDING_ALL) {
            String elementName = elementToImport.getName();
            assert (elementName != null);
            externalModuleName = TypeScriptAutoImportUtil.wrapWithQuotesFromSettings(StringUtil.unquoteString((String)elementName), (PsiElement)elementToImport);
        } else if (namespace == null) {
            ModuleInfo moduleNameWithResolve = TypeScriptAutoImportUtil.getExternalFileModuleName(project, elementToImport, place);
            if (moduleNameWithResolve != null) {
                externalModuleName = moduleNameWithResolve.getPath();
                externalModule = PsiManager.getInstance((Project)project).findFile(moduleNameWithResolve.getModule());
            }
        } else {
            String topmostParent = JSQualifiedNameImpl.getTopmostParent(namespace);
            if (StringUtil.isQuotedString((String)topmostParent)) {
                externalModuleName = TypeScriptAutoImportUtil.wrapWithQuotesFromSettings(StringUtil.unquoteString((String)topmostParent), (PsiElement)elementToImport);
                qualifier = ((JSQualifiedNameImpl)namespace).withoutInnermostComponent(null);
            } else {
                qualifier = namespace;
            }
        }
        final PsiNamedElement scope = TypeScriptAutoImportUtil.getScopeToAddImport(place, externalModuleName);
        if (externalModule != null && (possibleImport = TypeScriptAutoImportUtil.findExistingImport(elementToImport, (PsiElement)scope, (PsiElement)externalModule, externalModuleName)) != null && JSApplicationSettings.getInstance().isMergeImports() && TypeScriptAutoImportUtil.tryToAddImportToExistingDeclaration(project, possibleImport, name, importType)) {
            return;
        }
        ASTNode importNode = TypeScriptAutoImportUtil.createImportNode(place, name, externalModuleName, importType, qualifier);
        if (importNode == null) {
            return;
        }
        final JSSourceElement importPsi = (JSSourceElement)importNode.getPsi();
        if (scope == null) {
            return;
        }
        final Pair<Boolean, PsiElement> placeForImport = TypeScriptAutoImportUtil.findPlaceForImport((PsiElement)scope);
        new WriteCommandAction.Simple<Void>(project, TypeScriptAutoImportUtil.getActionName(), new PsiFile[]{place.getContainingFile()}){

            protected void run() throws Throwable {
                if (((Boolean)placeForImport.first).booleanValue()) {
                    scope.addAfter((PsiElement)importPsi, (PsiElement)placeForImport.second);
                } else {
                    scope.addBefore((PsiElement)importPsi, (PsiElement)placeForImport.second);
                }
            }
        }.execute();
        DaemonCodeAnalyzer.getInstance((Project)project).restart(place.getContainingFile());
    }

    public static boolean hasExportAssignment(@NotNull JSQualifiedNamedElement elementToImport, PsiElement elementContainer) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "hasExportAssignment"));
        }
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment(elementContainer, (PsiElement)elementToImport);
        return exportAssignment instanceof TypeScriptExportAssignment;
    }

    public static ImportType getImportType(@NotNull JSQualifiedNamedElement elementToImport, PsiElement elementContainer) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getImportType"));
        }
        if (elementToImport instanceof TypeScriptModule && !((TypeScriptModule)elementToImport).isInternal()) {
            return ImportType.IMPORT_BINDING_ALL;
        }
        if (TypeScriptAutoImportUtil.hasExportAssignment(elementToImport, elementContainer)) {
            return ImportType.TS_REQUIRE_IMPORT;
        }
        ImportType isExportDefault = ImportType.DEFAULT;
        if (elementToImport instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)elementToImport).getAttributeList();
            if (!(elementToImport.getParent() instanceof JSExportAssignment) && attributeList != null && ES6ImportHandler.isExported((PsiElement)elementToImport)) {
                isExportDefault = ImportType.SPECIFIER;
            }
        }
        return isExportDefault;
    }

    public static PsiNamedElement getScopeToAddImport(@NotNull PsiElement place, String externalModuleName) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getScopeToAddImport"));
        }
        return externalModuleName == null ? (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{JSFile.class, TypeScriptModule.class}) : (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)place, JSFile.class);
    }

    @Nullable
    public static ASTNode createImportNode(PsiElement place, String name, String externalModuleName, ImportType importType, JSQualifiedName qualifier) {
        ES6ImportDeclarationElementType expectedType;
        StringBuilder builder = new StringBuilder("import ");
        Project project = place.getProject();
        if (externalModuleName != null) {
            if (importType == ImportType.TS_REQUIRE_IMPORT) {
                builder.append(name).append(" = require(").append(externalModuleName).append(')');
                expectedType = TypeScriptElementTypes.IMPORT_STATEMENT;
            } else {
                JSCodeStyleSettings settings = TypeScriptCodeStyleSettings.getTypeScriptSettings(project);
                boolean needSpace = settings.SPACES_WITHIN_IMPORTS;
                TypeScriptAutoImportUtil.getNameAccordingToImportStyle(name, importType, builder, needSpace);
                builder.append(" from ").append(externalModuleName);
                expectedType = ES6ElementTypes.IMPORT_DECLARATION;
            }
        } else {
            builder.append(name).append(" = ");
            if (qualifier != null) {
                builder.append(qualifier);
            }
            if (qualifier != null) {
                builder.append('.');
            }
            if (ImportType.DEFAULT != importType) {
                builder.append(name);
            }
            expectedType = TypeScriptElementTypes.IMPORT_STATEMENT;
        }
        builder.append(JSCodeStyleSettings.getSemicolon(place.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromText(project, builder.toString(), JavaScriptSupportLoader.TYPESCRIPT);
        if (importNode == null || importNode.getElementType() != expectedType) {
            return null;
        }
        return importNode;
    }

    public static void getNameAccordingToImportStyle(String name, ImportType importType, StringBuilder builder, boolean needSpace) {
        if (importType == ImportType.IMPORT_BINDING_ALL) {
            builder.append("* as ").append(name);
        } else {
            if (importType == ImportType.SPECIFIER) {
                builder.append('{');
                if (needSpace) {
                    builder.append(' ');
                }
            }
            builder.append(name);
            if (importType == ImportType.SPECIFIER) {
                if (needSpace) {
                    builder.append(' ');
                }
                builder.append('}');
            }
        }
    }

    @Nullable
    public static ModuleInfo getExternalFileModuleName(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        VirtualFile file;
        VirtualFile moduleDirectory;
        ModuleInfo modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        PsiFile placePsiFile = place.getContainingFile();
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        PsiFile dstPsiFile = elementToImport.getContainingFile();
        VirtualFile dstFile = dstPsiFile.getVirtualFile();
        Pair<VirtualFile, VirtualFile> libraryDirectory = TypeScriptAutoImportUtil.findParentLibraryDirectory(project, dstFile, NODE_MODULES);
        ModuleInfo info = null;
        if (libraryDirectory != null && (modules = TypeScriptAutoImportUtil.getModuleNameUsingNodeModules(project, moduleDirectory = (VirtualFile)libraryDirectory.first, dstFile, placePsiFile, elementToImport)) != null && (file = modules.getModule()) != null && !StringUtil.isEmpty((String)modules.getPath())) {
            info = modules;
        }
        if (info == null) {
            ModuleInfo mappings;
            TypeScriptConfig configFile = TypeScriptConfigUtil.getConfigForPsiFile(placePsiFile);
            if (configFile != null && (mappings = TypeScriptAutoImportUtil.getModuleNameUsingPathMappings(project, configFile, placePsiFile, dstFile, elementToImport)) != null && !StringUtil.isEmpty((String)mappings.getPath()) && (file = mappings.getModule()) != null) {
                info = mappings;
            }
            if (info == null) {
                ModuleInfo moduleInfo = TypeScriptAutoImportUtil.getExternalModuleNameForFile(project, configFile, placeFile, placePsiFile, dstFile, elementToImport);
                if (moduleInfo == null) {
                    return null;
                }
                info = moduleInfo;
            }
        }
        return info;
    }

    @NotNull
    private static String wrapWithQuotesFromSettings(String externalModuleName, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "wrapWithQuotesFromSettings"));
        }
        String quote = JSCodeStyleSettings.getQuote(context);
        String string = externalModuleName = quote + externalModuleName + quote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "wrapWithQuotesFromSettings"));
        }
        return string;
    }

    @Nullable
    private static ModuleInfo getExternalModuleNameForFile(@NotNull Project project, @Nullable TypeScriptConfig configFile, @NotNull VirtualFile placeFile, @NotNull PsiFile placePsiFile, @NotNull VirtualFile dstFile, @NotNull JSQualifiedNamedElement elementToImport) {
        String externalModuleName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        VirtualFile pathFile = dstFile.getParent();
        VirtualFile resultDest = null;
        if (TypeScriptAutoImportUtil.useNodeResolution(project, configFile)) {
            resultDest = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, placePsiFile, elementToImport, false);
        }
        if (resultDest == null) {
            pathFile = dstFile;
            resultDest = dstFile;
        }
        if (JSApplicationSettings.getInstance().isUseAbsoluteConfigPath()) {
            VirtualFile rootFile = null;
            if (configFile != null && TypeScriptConfigService.Provider.isConfigInclude(project, pathFile, configFile)) {
                rootFile = configFile.getBaseUrl() != null ? configFile.getBaseUrl() : configFile.getConfigFile().getParent();
            }
            if (rootFile == null) {
                rootFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(placeFile, true);
            }
            if (rootFile != null) {
                String path = VfsUtil.getPath(rootFile, (VirtualFile)pathFile, (char)'/');
                if (path == null) {
                    return new ModuleInfo(VfsUtil.getPath((VirtualFile)rootFile, (VirtualFile)dstFile, (char)'/'), dstFile, dstFile, (PsiElement)elementToImport);
                }
                return new ModuleInfo(path, resultDest, pathFile, (PsiElement)elementToImport);
            }
        }
        if ((externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)pathFile, (char)'/')) == null) {
            externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)dstFile, (char)'/');
            if (externalModuleName == null) {
                return null;
            }
            pathFile = dstFile;
            resultDest = dstFile;
        }
        if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(File.separator)) {
            externalModuleName = "./" + externalModuleName;
        }
        return new ModuleInfo(externalModuleName, resultDest, pathFile, (PsiElement)elementToImport);
    }

    private static boolean useNodeResolution(@NotNull Project project, @Nullable TypeScriptConfig config) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "useNodeResolution"));
        }
        if (!JSApplicationSettings.getInstance().isUseNodeModulesResolutionImports()) {
            return false;
        }
        if (config == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = config.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == config.getModule();
    }

    public static ModuleInfo getModuleNameUsingPathMappings(@NotNull Project project, @NotNull TypeScriptConfig file, @NotNull PsiFile placePsiFile, @NotNull VirtualFile dstFile, @NotNull JSQualifiedNamedElement elementToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        VirtualFile baseUrl = file.getBaseUrl();
        if (baseUrl == null) {
            return null;
        }
        ModuleInfo currentMapping = null;
        for (JSModulePathSubstitution substitution : file.getPaths()) {
            String pattern = substitution.getPattern();
            if (StringUtil.isEmpty((String)pattern)) continue;
            for (String mapping : substitution.getMappings()) {
                ModuleInfo possibleMapping;
                if (StringUtil.isEmpty((String)mapping) || (possibleMapping = TypeScriptAutoImportUtil.getModuleNameForMapping(project, baseUrl, dstFile, pattern, mapping, placePsiFile, elementToImport)) == null || !TypeScriptAutoImportUtil.shouldUseNewMapping(currentMapping, possibleMapping)) continue;
                currentMapping = possibleMapping;
            }
        }
        return currentMapping;
    }

    private static boolean shouldUseNewMapping(@Nullable ModuleInfo oldMapping, @NotNull ModuleInfo newMapping) {
        if (newMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "shouldUseNewMapping"));
        }
        if (oldMapping == null) {
            return true;
        }
        return newMapping.getPath().length() > oldMapping.getPath().length();
    }

    @Nullable
    private static ModuleInfo getModuleNameForMapping(@NotNull Project project, @NotNull VirtualFile baseUrl, @NotNull VirtualFile dstFile, @NotNull String pattern, @NotNull String mapping, @NotNull PsiFile placePsiFile, @NotNull JSQualifiedNamedElement elementToImport) {
        boolean hasSeparatorInFirstPart;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        mapping = FileUtil.toSystemIndependentName((String)mapping);
        int starIndex = mapping.indexOf("*");
        if (pattern.length() < 2) {
            return null;
        }
        if (starIndex < 0) {
            VirtualFile pathFile = TypeScriptAutoImportUtil.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile == null) {
                return null;
            }
            VirtualFile file = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, placePsiFile, elementToImport, true);
            return file == null ? null : new ModuleInfo(pattern, file, pathFile, (PsiElement)elementToImport);
        }
        String firstPart = mapping.substring(0, starIndex);
        int separatorIndex = firstPart.lastIndexOf(47);
        VirtualFile startDirectory = baseUrl;
        boolean bl = hasSeparatorInFirstPart = separatorIndex >= 0;
        if (hasSeparatorInFirstPart) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, firstPart.substring(0, separatorIndex));
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = TypeScriptAutoImportUtil.collectParents(dstFile, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        String partOfString = mapping.substring(hasSeparatorInFirstPart ? separatorIndex : 0);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            VirtualFile file;
            String stringToCheckPattern = VfsUtil.getPath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/');
            if (StringUtil.isEmpty((String)stringToCheckPattern)) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString);
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((hasSeparatorInFirstPart ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (file = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, placePsiFile, elementToImport, false)) == null) continue;
            return new ModuleInfo(pattern.replace("*", (CharSequence)matchedStar.second), file, pathFile, (PsiElement)elementToImport);
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, VirtualFile startDirectory) {
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            if (startDirectory.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
            }
            return list;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
        }
        return arrayList;
    }

    private static VirtualFile checkSymbolAndGetFile(Project project, @NotNull VirtualFile dstFile, @NotNull VirtualFile pathFile, @NotNull PsiFile placePsiFile, @NotNull JSQualifiedNamedElement elementToImport, boolean checkNested) {
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (pathFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (pathFile.isDirectory()) {
            VirtualFile possibleFile = TypeScriptAutoImportUtil.resolveAsNpmPackage(project, pathFile);
            if (possibleFile == null) {
                return null;
            }
            pathFile = possibleFile;
        }
        if ((!checkNested || TypeScriptAutoImportUtil.isFromNestedDirectory(pathFile, dstFile)) && TypeScriptAutoImportUtil.checkSymbolInFile(project, pathFile, elementToImport, placePsiFile)) {
            return pathFile;
        }
        return null;
    }

    private static VirtualFile resolveAsNpmPackage(@NotNull Project project, @NotNull VirtualFile pathFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "resolveAsNpmPackage"));
        }
        if (pathFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "resolveAsNpmPackage"));
        }
        return JSExactFileReference.resolveForNpmPackages(pathFile, new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project), false);
    }

    private static boolean isFromNestedDirectory(VirtualFile pathFile, VirtualFile dstFile) {
        if (pathFile.equals(dstFile)) {
            return true;
        }
        if (!pathFile.isDirectory()) {
            pathFile = pathFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)pathFile, (VirtualFile)dstFile, (boolean)false);
    }

    private static VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getPossibleFileWithExtension"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getPossibleFileWithExtension"));
        }
        if (JSFileReference.findExtension(mapping, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
        }
        for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
    }

    @Nullable
    public static ModuleInfo getModuleNameUsingNodeModules(@NotNull Project project, @NotNull VirtualFile moduleDirectory, @NotNull VirtualFile dstFile, @NotNull PsiFile placePsiFile, @NotNull JSQualifiedNamedElement elementToImport) {
        VirtualFile parentOfNodeModules;
        VirtualFile directoryToCalcModuleName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingNodeModules"));
        }
        if (moduleDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDirectory", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingNodeModules"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingNodeModules"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingNodeModules"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingNodeModules"));
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile current = moduleDirectory;
        VirtualFile nodeModulesDirectory = null;
        Object object = directoryToCalcModuleName = "@types".equals(current.getName()) ? current : null;
        while (current != null) {
            String name = (current = current.getParent()).getName();
            if ("@types".equals(name)) {
                directoryToCalcModuleName = current;
                continue;
            }
            if (!"node_modules".equals(current.getName())) continue;
            nodeModulesDirectory = current;
            break;
        }
        if (nodeModulesDirectory == null) {
            return null;
        }
        if (directoryToCalcModuleName == null) {
            directoryToCalcModuleName = nodeModulesDirectory;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)(parentOfNodeModules = nodeModulesDirectory.getParent()), (VirtualFile)placeFile, (boolean)true)) {
            return null;
        }
        ArrayList elements = ContainerUtil.newArrayList(TypeScriptAutoImportUtil.collectParents(dstFile, moduleDirectory));
        elements.add(moduleDirectory);
        for (VirtualFile file : ContainerUtil.reverse((List)elements)) {
            VirtualFile candidate = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, file, placePsiFile, elementToImport, false);
            if (candidate == null || !TypeScriptUtil.isDefinitionFile(candidate)) continue;
            return new ModuleInfo(VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)file, (char)'/'), candidate, file, (PsiElement)elementToImport);
        }
        return new ModuleInfo(VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)dstFile, (char)'/'), dstFile, dstFile, (PsiElement)elementToImport);
    }

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile placePsiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        PsiFile possiblePsiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(possiblePsiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)possiblePsiFile;
        return TypeScriptAutoImportUtil.checkSymbolInModule(elementToImport, placePsiFile, (JSElement)file);
    }

    public static boolean checkSymbolInModule(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile placePsiFile, @NotNull JSElement module) {
        ResolveResult[] results;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        String name = elementToImport.getQualifiedName();
        if (name == null) {
            return false;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)placePsiFile, name, true);
        TypeScriptQualifiedItemProcessor<ResolveResultSink> processor = new TypeScriptQualifiedItemProcessor<ResolveResultSink>(sink, placePsiFile);
        ES6PsiUtil.processExportDeclarationInScope(module, processor, ResolveState.initial(), null, (PsiElement)placePsiFile);
        for (ResolveResult result : results = sink.getResultsAsResolveResults()) {
            PsiElement element = result.getElement();
            if (element == null || !element.isEquivalentTo((PsiElement)elementToImport)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Pair<VirtualFile, VirtualFile> findParentLibraryDirectory(@NotNull Project project, @NotNull VirtualFile dstFile, String[] directories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findParentLibraryDirectory"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findParentLibraryDirectory"));
        }
        VirtualFile prevDirectory = null;
        VirtualFile prevDirectoryWithPackageJson = null;
        Object[] stopDirs = ProjectRootManager.getInstance((Project)project).getContentRoots();
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null && !ArrayUtil.contains((Object)currentDirectory, (Object[])stopDirs); currentDirectory = currentDirectory.getParent()) {
            if (ArrayUtil.contains((String)currentDirectory.getName(), (String[])directories)) {
                VirtualFile module = prevDirectoryWithPackageJson == null ? prevDirectory : prevDirectoryWithPackageJson;
                return Pair.create(module, (Object)currentDirectory);
            }
            if (null != currentDirectory.findChild("package.json")) {
                prevDirectoryWithPackageJson = currentDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    @Nullable
    private static JSExportAssignment getExportAssignment(@Nullable PsiElement module, @NotNull PsiElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExportAssignment"));
        }
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren(module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    @NotNull
    private static Pair<Boolean, PsiElement> findPlaceForImport(@NotNull PsiElement scope) {
        ASTNode lBrace;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        PsiElement currentChild = scope.getFirstChild();
        if (scope instanceof TypeScriptModule && (lBrace = scope.getNode().findChildByType(JSTokenTypes.LBRACE)) != null) {
            currentChild = lBrace.getPsi().getNextSibling();
        }
        PsiElement lastImport = null;
        while (currentChild != null) {
            if (currentChild instanceof TypeScriptImportStatement || currentChild instanceof ES6ImportDeclaration || JSPsiImplUtils.isUseStrictStatement(currentChild)) {
                lastImport = currentChild;
            } else if (lastImport == null && !(currentChild instanceof PsiWhiteSpace) && !(currentChild instanceof PsiComment)) break;
            currentChild = currentChild.getNextSibling();
        }
        Pair pair = Pair.create((Object)(lastImport != null ? 1 : 0), (Object)(lastImport != null ? lastImport : currentChild));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        return pair;
    }

    private static ES6ImportDeclaration findExistingImport(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement placeModule, @NotNull PsiElement module, @NotNull String moduleName) {
        PsiElement[] declarations;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingImport"));
        }
        if (placeModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeModule", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingImport"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingImport"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingImport"));
        }
        for (PsiElement declaration : declarations = JSResolveUtil.getStubbedChildren(placeModule, ES6_IMPORT_DECLARATION)) {
            Collection resolvedElements;
            ES6ImportDeclaration es6Import;
            ES6FromClause clause;
            if (!(declaration instanceof ES6ImportDeclaration) || (clause = (es6Import = (ES6ImportDeclaration)declaration).getFromClause()) == null || !(resolvedElements = clause.resolveReferencedElements()).contains(module)) continue;
            return es6Import;
        }
        return null;
    }

    private static boolean tryToAddImportToExistingDeclaration(final Project project, final @NotNull ES6ImportDeclaration declaration, String name, ImportType type) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "tryToAddImportToExistingDeclaration"));
        }
        Object[] specifiers = declaration.getImportSpecifiers();
        if (specifiers.length == 0) {
            return false;
        }
        final ES6ImportSpecifier lastSpecifier = (ES6ImportSpecifier)ArrayUtil.getLastElement((Object[])specifiers);
        assert (lastSpecifier != null);
        ASTNode toInsertBeforeNode = lastSpecifier.getNode();
        if (toInsertBeforeNode == null) {
            return false;
        }
        StringBuilder builder = new StringBuilder("import {");
        if (type == ImportType.DEFAULT) {
            builder.append("default as ");
        }
        builder.append(name);
        builder.append(",}");
        ASTNode importNode = JSChangeUtil.createStatementFromText(project, builder.toString(), JavaScriptSupportLoader.TYPESCRIPT);
        if (importNode == null) {
            return false;
        }
        final ASTNode specifierToInsertNode = importNode.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER);
        if (specifierToInsertNode == null) {
            return false;
        }
        final ASTNode commaNode = importNode.findChildByType(JSTokenTypes.COMMA);
        assert (commaNode != null);
        new WriteCommandAction.Simple<Void>(project, TypeScriptAutoImportUtil.getActionName(), new PsiFile[]{declaration.getContainingFile()}){

            protected void run() throws Throwable {
                PsiElement anchor = declaration.addAfter(commaNode.getPsi(), (PsiElement)lastSpecifier);
                declaration.addAfter(specifierToInsertNode.getPsi(), anchor);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat((PsiElement)declaration);
            }
        }.execute();
        return true;
    }

    public static String getActionName() {
        return JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]);
    }

    public static class JSReferencePlaceInfo {
        @NotNull
        private final PsiElement place;
        @NotNull
        private final PsiElement parent;
        @NotNull
        private final VirtualFile file;
        @Nullable
        private final PsiElement container;
        private final boolean isStrictTypeContext;

        public JSReferencePlaceInfo(@NotNull PsiElement place) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$JSReferencePlaceInfo", "<init>"));
            }
            this.place = place;
            this.parent = place.getParent();
            this.file = place.getContainingFile().getOriginalFile().getVirtualFile();
            this.container = TypeScriptPsiUtil.getTopLevelContainer(place);
            this.isStrictTypeContext = place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place);
        }
    }

    public static class ModuleInfo {
        @NotNull
        private final String myPath;
        @Nullable
        private final VirtualFile myModule;
        @NotNull
        private final VirtualFile myResolveFile;

        public ModuleInfo(@Nullable String path, @Nullable VirtualFile module, @NotNull VirtualFile pathFile, @NotNull PsiElement context) {
            if (pathFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "<init>"));
            }
            String externalModuleName = StringUtil.trimEnd((String)StringUtil.notNullize((String)path), (String)".d.ts");
            externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".ts");
            externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".tsx");
            this.myPath = externalModuleName = TypeScriptAutoImportUtil.wrapWithQuotesFromSettings(externalModuleName, context);
            this.myModule = module;
            this.myResolveFile = pathFile;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "getPath"));
            }
            return string;
        }

        @Nullable
        public VirtualFile getModule() {
            return this.myModule;
        }

        @NotNull
        public VirtualFile getPathFile() {
            VirtualFile virtualFile = this.myResolveFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "getPathFile"));
            }
            return virtualFile;
        }
    }

    static enum ImportType {
        SPECIFIER,
        DEFAULT,
        IMPORT_BINDING_ALL,
        TS_REQUIRE_IMPORT,
        TS_NAMESPACE;

    }
}

