/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import org.jetbrains.annotations.NotNull;

public class TypeScriptMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        boolean isTypeScriptContext;
        if (!(file instanceof JSFile) || element == null || !DialectDetector.isTypeScript(element)) {
            return false;
        }
        PsiElement context = file.findElementAt(editor.getCaretModel().getOffset());
        if (context == null && editor.getCaretModel().getOffset() > 0) {
            context = file.findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        boolean bl = isTypeScriptContext = context != null && DialectDetector.isTypeScript(context);
        if (!isTypeScriptContext) {
            return false;
        }
        if (TypeScriptMemberInplaceRenameHandler.isClassOrInterfaceWithName(element) || element instanceof TypeScriptVariable && !(element.getUseScope() instanceof LocalSearchScope) || element instanceof TypeScriptFunction && !(element.getUseScope() instanceof LocalSearchScope) || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedBinding || element instanceof JSField || element instanceof TypeScriptImportStatement || element instanceof TypeScriptModule) {
            return editor.getSettings().isVariableInplaceRenameEnabled();
        }
        return false;
    }

    private static boolean isClassOrInterfaceWithName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler", "isClassOrInterfaceWithName"));
        }
        return element instanceof JSClass && ((JSClass)element).getName() != null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(final @NotNull PsiElement element, PsiNameIdentifierOwner elementToRename, Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler", "createMemberRenamer"));
        }
        if (element instanceof PsiNameIdentifierOwner) {
            elementToRename = (PsiNameIdentifierOwner)element;
        }
        MemberInplaceRenamer memberInplaceRenamer = new MemberInplaceRenamer((PsiNamedElement)elementToRename, (PsiElement)elementToRename, editor){

            protected boolean acceptReference(PsiReference reference) {
                return JSDefaultRenameProcessor.acceptReference(reference, false, true, element);
            }

            public boolean performInplaceRename() {
                return this.checkNeedInplace() && super.performInplaceRename();
            }

            private boolean checkNeedInplace() {
                if (!JSDefaultRenameProcessor.getSearchJavaScriptReferences(element)) {
                    return true;
                }
                return JSDefaultRenameProcessor.getReferences(element, false, JSDefaultRenameProcessor.ReferencesType.JS).isEmpty();
            }
        };
        if (memberInplaceRenamer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler", "createMemberRenamer"));
        }
        return memberInplaceRenamer;
    }
}

