/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TypeScriptGeneratedFilesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TypeScriptGeneratedFilesManager
implements PersistentStateComponent<State> {
    private final Project myProject;
    private volatile State myState = new State();

    public TypeScriptGeneratedFilesManager(Project project, @Nullable TypeScriptConfigService service) {
        this.myProject = project;
        if (service != null) {
            // empty if block
        }
    }

    @NotNull
    protected TypeScriptConfigsChangedListener createListener(final @NotNull TypeScriptConfigService service) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "createListener"));
        }
        TypeScriptConfigsChangedListener typeScriptConfigsChangedListener = new TypeScriptConfigsChangedListener(){

            @Override
            public void afterUpdate(@NotNull Collection<TypeScriptConfig> configs) {
                if (configs == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager$1", "afterUpdate"));
                }
                ModificationTracker tracker = service.getTracker();
                long before = tracker.getModificationCount();
                Runnable runnable = () -> {
                    void configs;
                    if (configs == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager$1", "lambda$afterUpdate$1"));
                    }
                    ReadAction.run(() -> this.lambda$null$0(tracker, before, (Collection)configs));
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(runnable);
                }
            }

            /*
             * WARNING - void declaration
             */
            private /* synthetic */ void lambda$null$0(ModificationTracker tracker, long before, @NotNull Collection collection) throws RuntimeException {
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager$1", "lambda$null$0"));
                }
                if (tracker.getModificationCount() == before) {
                    void configs;
                    TypeScriptGeneratedFilesManager.this.updateConfigExcludes((Collection<TypeScriptConfig>)configs);
                }
            }
        };
        if (typeScriptConfigsChangedListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "createListener"));
        }
        return typeScriptConfigsChangedListener;
    }

    @Nullable
    public static TypeScriptGeneratedFilesManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "getInstance"));
        }
        return (TypeScriptGeneratedFilesManager)ServiceManager.getService((Project)project, TypeScriptGeneratedFilesManager.class);
    }

    public Collection<VirtualFile> getExcludedPlainJSFiles() {
        Collection<String> files = this.myState.exactExcludedFiles;
        if (files.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        LinkedHashSet filteredFiles = ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.mapNotNull(files, el -> localFileSystem.findFileByPath(el)));
        if (filteredFiles.size() != files.size()) {
            this.updateList(filteredFiles);
        }
        return filteredFiles;
    }

    public Collection<VirtualFile> getExcludedConfigFiles() {
        Collection<String> configsExcludedFiles = this.myState.configsExcludedFiles;
        if (configsExcludedFiles.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        List result = ContainerUtil.newSmartList();
        for (String file : configsExcludedFiles) {
            VirtualFile resultFile = LocalFileSystem.getInstance().findFileByPath(file);
            if (resultFile == null) continue;
            result.add(resultFile);
        }
        return result;
    }

    private synchronized void updateList(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptGeneratedFilesManager.mapToStrings(files);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public boolean isProjectProcessed() {
        return this.myState.processed;
    }

    public void setProjectProcessed(boolean result) {
        this.myState.processed = result;
    }

    public void updateConfigExcludes(Collection<TypeScriptConfig> configs) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<String> oldValues = this.myState.configsExcludedFiles;
        HashSet newValues = ContainerUtil.newHashSet();
        boolean hasAllNew = true;
        for (TypeScriptConfig config : configs) {
            String directory = config.getOutDirectory();
            if (StringUtil.isEmpty((String)directory)) continue;
            newValues.add(directory);
            hasAllNew &= oldValues.contains(directory);
        }
        if (hasAllNew && oldValues.size() == newValues.size()) {
            return;
        }
        this.myState.configsExcludedFiles = newValues;
        TransactionGuard.submitTransaction((Disposable)this.myProject, this::updateProject);
    }

    public void addFiles(Collection<VirtualFile> files) {
        ArrayList result = ContainerUtil.newArrayList(this.myState.exactExcludedFiles);
        result.addAll(TypeScriptGeneratedFilesManager.mapToStrings(files));
        this.myState.exactExcludedFiles = result;
    }

    @NotNull
    private static List<String> mapToStrings(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "mapToStrings"));
        }
        List list = ContainerUtil.mapNotNull(files, el -> el.getCanonicalPath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "mapToStrings"));
        }
        return list;
    }

    public void setFiles(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptGeneratedFilesManager.mapToStrings(files);
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public void updateProject() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true));
    }

    public static class State {
        public boolean processed = false;
        @NotNull
        public Collection<String> exactExcludedFiles = ContainerUtil.newArrayList();
        @NotNull
        public Collection<String> configsExcludedFiles = ContainerUtil.newHashSet();
    }
}

