/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.connection.DefaultBuildIdentifier;
import org.gradle.tooling.internal.connection.ToolingClientCompositeUtil;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;

public class ToolingClientCompositeBuildLauncher {
    private final ConsumerOperationParameters operationParameters;
    private final ToolingClientCompositeUtil util;

    ToolingClientCompositeBuildLauncher(ConsumerOperationParameters operationParameters) {
        this.operationParameters = operationParameters;
        this.util = new ToolingClientCompositeUtil(operationParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean built = false;
        for (GradleParticipantBuild gradleBuildInternal : this.operationParameters.getBuilds()) {
            DefaultBuildIdentifier participantIdentifier = new DefaultBuildIdentifier(gradleBuildInternal.getProjectDir());
            if (this.operationParameters.getBuildIdentifier() != null && !this.operationParameters.getBuildIdentifier().equals(participantIdentifier)) continue;
            ProjectConnection connection = null;
            try {
                connection = this.util.createParticipantConnector(gradleBuildInternal).connect();
                BuildLauncher buildLauncher = connection.newBuild();
                this.util.configureRequest(buildLauncher);
                buildLauncher.run();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
            built = true;
        }
        if (!built) {
            throw new GradleConnectionException("Not a valid build: " + this.operationParameters.getBuildIdentifier(), new IllegalStateException("Build not part of composite"));
        }
    }
}

