/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references.paths;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.thymeleaf.references.paths.ThymeleafViewResolverHelper;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafPathPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "getReferencesByElement"));
        }
        com.intellij.util.containers.hash.HashSet references = new com.intellij.util.containers.hash.HashSet();
        Collections.addAll(references, PathReferenceManager.getInstance().createReferences(element, true, false, true, new PathReferenceProvider[0]));
        FileReferenceSet set = new FileReferenceSet(element.getText(), element, 0, null, true);
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "lambda$getReferencesByElement$0"));
            }
            HashSet set1 = new HashSet();
            set1.add(file.getContainingDirectory());
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module != null) {
                set1.addAll(ThymeleafPathPsiReferenceProvider.getPrefixedContextPaths(module));
            }
            return set1;
        });
        Collections.addAll(references, set.getAllReferences());
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static Collection<PsiFileSystemItem> getPrefixedContextPaths(@NotNull Module module) {
        Set<String> prefixes;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "getPrefixedContextPaths"));
        }
        HashSet items = new HashSet();
        Collection facets = WebFacet.getInstances((Module)module);
        if (facets.size() > 0 && (prefixes = ThymeleafPathPsiReferenceProvider.getTemplateResolverPrefixes(module)).size() > 0) {
            WebDirectoryUtil directoryUtil = WebDirectoryUtil.getWebDirectoryUtil((Project)module.getProject());
            for (WebFacet webFacet : facets) {
                for (String prefix : prefixes) {
                    WebDirectoryElement webRootBase = directoryUtil.findWebDirectoryElementByPath(prefix, webFacet);
                    ContainerUtil.addIfNotNull((Collection)items, (Object)webRootBase);
                }
            }
        }
        HashSet hashSet = items;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "getPrefixedContextPaths"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<String> getTemplateResolverPrefixes(@Nullable Module module) {
        if (module == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "getTemplateResolverPrefixes"));
            }
            return set;
        }
        com.intellij.util.containers.hash.HashSet strings = new com.intellij.util.containers.hash.HashSet();
        for (ThymeleafViewResolverHelper helper : (ThymeleafViewResolverHelper[])Extensions.getExtensions(ThymeleafViewResolverHelper.EP_NAME)) {
            strings.addAll(helper.getTemplateResolverPrefixes(module));
        }
        com.intellij.util.containers.hash.HashSet hashSet = strings;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider", "getTemplateResolverPrefixes"));
        }
        return hashSet;
    }
}

