/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.javaee;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.Ear;
import org.jetbrains.plugins.gradle.model.data.EarConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.WebResource;
import org.jetbrains.plugins.gradle.model.ear.EarConfiguration;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaEEGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(JavaEEGradleProjectResolverExtension.class);

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, final @NotNull DataNode<ModuleData> ideModule) {
        EarConfiguration earConfiguration;
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension", "populateModuleExtraModels"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension", "populateModuleExtraModels"));
        }
        WebConfiguration webConfiguration = this.resolverCtx.getExtraProject(gradleModule, WebConfiguration.class);
        NotNullLazyValue<DataNode<? extends ModuleData>> findTargetModuleNode = new NotNullLazyValue<DataNode<? extends ModuleData>>(){

            @NotNull
            protected DataNode<? extends ModuleData> compute() {
                String mainSourceSetModuleId = ((ModuleData)ideModule.getData()).getId() + ":main";
                DataNode targetModuleNode = ExternalSystemApiUtil.find((DataNode)ideModule, GradleSourceSetData.KEY, node -> mainSourceSetModuleId.equals(((GradleSourceSetData)((Object)((Object)node.getData()))).getId()));
                if (targetModuleNode == null) {
                    targetModuleNode = ideModule;
                }
                DataNode dataNode = targetModuleNode;
                if (dataNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension$1", "compute"));
                }
                return dataNode;
            }
        };
        if (webConfiguration != null) {
            List warModels = ContainerUtil.map((Collection)webConfiguration.getWarModels(), (Function)new Function<WebConfiguration.WarModel, War>(){

                public War fun(WebConfiguration.WarModel model) {
                    War war = new War(model.getWarName(), model.getWebAppDirName(), model.getWebAppDir());
                    war.setWebXml(model.getWebXml());
                    war.setWebResources(JavaEEGradleProjectResolverExtension.mapWebResources(model.getWebResources()));
                    war.setClasspath(model.getClasspath());
                    war.setManifestContent(model.getManifestContent());
                    war.setArchivePath(model.getArchivePath());
                    return war;
                }
            });
            ((DataNode)findTargetModuleNode.getValue()).createChild(WebConfigurationModelData.KEY, (Object)new WebConfigurationModelData(GradleConstants.SYSTEM_ID, warModels));
        }
        if ((earConfiguration = this.resolverCtx.getExtraProject(gradleModule, EarConfiguration.class)) != null) {
            List warModels = ContainerUtil.map((Collection)earConfiguration.getEarModels(), (Function)new Function<EarConfiguration.EarModel, Ear>(){

                public Ear fun(EarConfiguration.EarModel model) {
                    Ear ear = new Ear(model.getEarName(), model.getAppDirName(), model.getLibDirName());
                    ear.setManifestContent(model.getManifestContent());
                    ear.setDeploymentDescriptor(model.getDeploymentDescriptor());
                    ear.setResources(JavaEEGradleProjectResolverExtension.mapEarResources(model.getResources()));
                    ear.setArchivePath(model.getArchivePath());
                    return ear;
                }
            });
            Collection<DependencyData> deployDependencies = GradleProjectResolverUtil.getIdeDependencies((DataNode<? extends ModuleData>)((DataNode)findTargetModuleNode.getValue()), earConfiguration.getDeployDependencies());
            Collection<DependencyData> earlibDependencies = GradleProjectResolverUtil.getIdeDependencies((DataNode<? extends ModuleData>)((DataNode)findTargetModuleNode.getValue()), earConfiguration.getEarlibDependencies());
            ((DataNode)findTargetModuleNode.getValue()).createChild(EarConfigurationModelData.KEY, (Object)new EarConfigurationModelData(GradleConstants.SYSTEM_ID, warModels, deployDependencies, earlibDependencies));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @Override
    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{WebConfiguration.class, EarConfiguration.class});
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension", "getExtraProjectModelClasses"));
        }
        return set;
    }

    private static List<WebResource> mapWebResources(List<WebConfiguration.WebResource> webResources) {
        return ContainerUtil.mapNotNull(webResources, resource -> {
            if (resource == null) {
                return null;
            }
            WarDirectory warDirectory = WarDirectory.fromPath(resource.getWarDirectory());
            return new WebResource(warDirectory, resource.getRelativePath(), resource.getFile());
        });
    }

    private static List<EarResource> mapEarResources(List<EarConfiguration.EarResource> resources) {
        return ContainerUtil.mapNotNull(resources, resource -> {
            if (resource == null) {
                return null;
            }
            return new EarResource(resource.getEarDirectory(), resource.getRelativePath(), resource.getFile());
        });
    }
}

