/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class MutableTestExecutionSummary
implements TestExecutionSummary {
    private static final String TAB = "  ";
    private static final String DOUBLE_TAB = "    ";
    final AtomicLong testsFound = new AtomicLong();
    final AtomicLong testsStarted = new AtomicLong();
    final AtomicLong testsSkipped = new AtomicLong();
    final AtomicLong testsAborted = new AtomicLong();
    final AtomicLong testsSucceeded = new AtomicLong();
    final AtomicLong testsFailed = new AtomicLong();
    final AtomicLong containersFailed = new AtomicLong();
    private final TestPlan testPlan;
    private final List<Failure> failures = new ArrayList<Failure>();
    private final long timeStarted;
    long timeFinished;

    MutableTestExecutionSummary(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.testsFound.set(testPlan.countTestIdentifiers(TestIdentifier::isTest));
        this.timeStarted = System.currentTimeMillis();
    }

    void addFailure(TestIdentifier testIdentifier, Throwable throwable) {
        this.failures.add(new Failure(testIdentifier, throwable));
    }

    @Override
    public long getTestsFoundCount() {
        return this.testsFound.get();
    }

    @Override
    public long getTestsStartedCount() {
        return this.testsStarted.get();
    }

    @Override
    public long getTestsSkippedCount() {
        return this.testsSkipped.get();
    }

    @Override
    public long getTestsAbortedCount() {
        return this.testsAborted.get();
    }

    @Override
    public long getTestsSucceededCount() {
        return this.testsSucceeded.get();
    }

    @Override
    public long getTestsFailedCount() {
        return this.testsFailed.get();
    }

    @Override
    public long getContainersFailedCount() {
        return this.containersFailed.get();
    }

    @Override
    public long getTotalFailureCount() {
        return this.getTestsFailedCount() + this.getContainersFailedCount();
    }

    @Override
    public long getTimeStarted() {
        return this.timeStarted;
    }

    @Override
    public long getTimeFinished() {
        return this.timeFinished;
    }

    @Override
    public void printTo(PrintWriter writer) {
        writer.println(String.format("%nTest run finished after %d ms%n[%10d tests found      ]%n[%10d tests skipped    ]%n[%10d tests started    ]%n[%10d tests aborted    ]%n[%10d tests successful ]%n[%10d tests failed     ]%n[%10d containers failed]%n", this.timeFinished - this.timeStarted, this.testsFound.get(), this.testsSkipped.get(), this.testsStarted.get(), this.testsAborted.get(), this.testsSucceeded.get(), this.testsFailed.get(), this.containersFailed.get()));
        writer.flush();
    }

    @Override
    public void printFailuresTo(PrintWriter writer) {
        if (this.getTotalFailureCount() > 0L) {
            writer.println();
            writer.println(String.format("Failures (%d):", this.getTotalFailureCount()));
            this.failures.forEach(failure -> {
                writer.println(TAB + this.describeTest(failure.getTestIdentifier()));
                failure.getTestIdentifier().getSource().ifPresent(source -> writer.println(DOUBLE_TAB + source));
                writer.println(String.format("%s=> %s", DOUBLE_TAB, failure.getException()));
            });
            writer.flush();
        }
    }

    private String describeTest(TestIdentifier testIdentifier) {
        ArrayList<String> descriptionParts = new ArrayList<String>();
        this.collectTestDescription(Optional.of(testIdentifier), descriptionParts);
        return descriptionParts.stream().collect(Collectors.joining(":"));
    }

    private void collectTestDescription(Optional<TestIdentifier> optionalIdentifier, List<String> descriptionParts) {
        optionalIdentifier.ifPresent(testIdentifier -> {
            descriptionParts.add(0, testIdentifier.getDisplayName());
            this.collectTestDescription(this.testPlan.getParent((TestIdentifier)testIdentifier), descriptionParts);
        });
    }

    private static class Failure {
        private final TestIdentifier testIdentifier;
        private final Throwable exception;

        Failure(TestIdentifier testIdentifier, Throwable exception) {
            this.testIdentifier = testIdentifier;
            this.exception = exception;
        }

        TestIdentifier getTestIdentifier() {
            return this.testIdentifier;
        }

        Throwable getException() {
            return this.exception;
        }
    }
}

