/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.browserConnection;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.jetbrains.browserConnection.BrowserConnector;
import com.jetbrains.browserConnection.BrowserQualifier;
import com.jetbrains.javascript.debugger.JsFileUtil;
import io.netty.handler.codec.http.FullHttpRequest;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

public class BrowserConnectionManager {
    private static final Logger LOG = Logger.getInstance(BrowserConnectionManager.class);
    private static final Key<BrowserQualifier> BROWSER_KEY = Key.create((String)"browser");
    @Nullable
    private ClientManager server;
    @Nullable
    private JsonRpcServer rpcServer;
    private final ConcurrentMultiMap<BrowserQualifier, AsyncPromise<Client>> pendingActions = new ConcurrentMultiMap();
    private final EventDispatcher<ClientListener> webSocketServerListenerEventDispatcher = EventDispatcher.create(ClientListener.class);

    public static BrowserConnectionManager getInstance() {
        return (BrowserConnectionManager)ServiceManager.getService(BrowserConnectionManager.class);
    }

    @Nullable
    private static String safeGet(String name, Map<String, List<String>> parameters) {
        List<String> values = parameters.get(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public void addWebSocketServerListener(@NotNull ClientListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/browserConnection/BrowserConnectionManager", "addWebSocketServerListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/browserConnection/BrowserConnectionManager", "addWebSocketServerListener"));
        }
        this.webSocketServerListenerEventDispatcher.addListener((EventListener)listener, disposable);
    }

    public boolean hasConnections() {
        return this.server != null && this.server.hasClients();
    }

    @Nullable
    public JsonRpcServer getRpcServer() {
        return this.rpcServer;
    }

    @NotNull
    public Promise<Client> getConnectedBrowser(@NotNull WebBrowser browser, @Nullable Disposable parentDisposable) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/browserConnection/BrowserConnectionManager", "getConnectedBrowser"));
        }
        Client connectedBrowser = this.findConnectedBrowser(browser);
        if (connectedBrowser != null) {
            Promise promise = Promise.resolve((Object)connectedBrowser);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "getConnectedBrowser"));
            }
            return promise;
        }
        BrowserQualifier browserQualifier = BrowserConnectionManager.browserToQualifier(browser);
        final AsyncPromise result = new AsyncPromise();
        this.pendingActions.putValue((Object)browserQualifier, (Object)result);
        result.rejected(throwable -> this.pendingActions.remove((Object)browserQualifier, (Object)result));
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    result.setError("rejected");
                }
            });
        }
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "getConnectedBrowser"));
        }
        return asyncPromise;
    }

    @Nullable
    public Client findConnectedBrowser(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/browserConnection/BrowserConnectionManager", "findConnectedBrowser"));
        }
        if (this.server == null) {
            return null;
        }
        BrowserQualifier browserQualifier = BrowserConnectionManager.browserToQualifier(browser);
        return this.findClient((Condition<Client>)((Condition)client -> browserQualifier.equals(BROWSER_KEY.get((UserDataHolder)client))));
    }

    @Nullable
    public WebBrowser getBrowser(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/jetbrains/browserConnection/BrowserConnectionManager", "getBrowser"));
        }
        BrowserQualifier browserQualifier = (BrowserQualifier)((Object)BROWSER_KEY.get((UserDataHolder)client));
        return browserQualifier == null ? null : BrowserConnectionManager.qualifierToBrowser(browserQualifier);
    }

    @Nullable
    public Client findClient(@NotNull Condition<Client> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/browserConnection/BrowserConnectionManager", "findClient"));
        }
        if (this.server == null) {
            return null;
        }
        Ref result = Ref.create();
        this.server.forEachClient(client -> {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/browserConnection/BrowserConnectionManager", "lambda$findClient$2"));
            }
            if (condition.value(client)) {
                result.set(client);
            }
            return result.isNull();
        });
        return (Client)result.get();
    }

    @NotNull
    public static BrowserQualifier browserToQualifier(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
        }
        if (WebBrowserManager.isYandexBrowser((WebBrowser)browser)) {
            BrowserQualifier browserQualifier = BrowserQualifier.YANDEX;
            if (browserQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
            }
            return browserQualifier;
        }
        if (WebBrowserManager.isDartium((WebBrowser)browser)) {
            BrowserQualifier browserQualifier = BrowserQualifier.DARTIUM;
            if (browserQualifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
            }
            return browserQualifier;
        }
        switch (browser.getFamily()) {
            case FIREFOX: {
                BrowserQualifier browserQualifier = BrowserQualifier.FIREFOX;
                if (browserQualifier == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
                }
                return browserQualifier;
            }
            case EXPLORER: {
                BrowserQualifier browserQualifier = BrowserQualifier.EXPLORER;
                if (browserQualifier == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
                }
                return browserQualifier;
            }
            case SAFARI: {
                BrowserQualifier browserQualifier = BrowserQualifier.SAFARI;
                if (browserQualifier == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
                }
                return browserQualifier;
            }
            case OPERA: {
                BrowserQualifier browserQualifier = BrowserQualifier.OPERA;
                if (browserQualifier == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
                }
                return browserQualifier;
            }
        }
        BrowserQualifier browserQualifier = BrowserQualifier.CHROME;
        if (browserQualifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "browserToQualifier"));
        }
        return browserQualifier;
    }

    @NotNull
    private static WebBrowser qualifierToBrowser(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserQualifier", "com/jetbrains/browserConnection/BrowserConnectionManager", "qualifierToBrowser"));
        }
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        switch (browserQualifier) {
            case CHROME: {
                WebBrowser webBrowser = browserManager.getFirstBrowser(BrowserFamily.CHROME);
                if (webBrowser == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "qualifierToBrowser"));
                }
                return webBrowser;
            }
            case DARTIUM: 
            case YANDEX: {
                Condition browserCondition = browser -> {
                    if (browserQualifier == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserQualifier", "com/jetbrains/browserConnection/BrowserConnectionManager", "lambda$qualifierToBrowser$3"));
                    }
                    if (browser.getFamily().equals((Object)BrowserFamily.CHROME)) {
                        if (browserQualifier == BrowserQualifier.DARTIUM) {
                            return WebBrowserManager.isDartium((WebBrowser)browser);
                        }
                        if (browserQualifier == BrowserQualifier.YANDEX) {
                            return WebBrowserManager.isYandexBrowser((WebBrowser)browser);
                        }
                    }
                    return false;
                };
                List browsers = browserManager.getBrowsers(browserCondition, true);
                if (browsers.isEmpty()) {
                    browsers = browserManager.getBrowsers(browserCondition, false);
                }
                WebBrowser webBrowser = browsers.isEmpty() ? browserManager.getFirstBrowser(BrowserFamily.CHROME) : (WebBrowser)browsers.get(0);
                if (webBrowser == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "qualifierToBrowser"));
                }
                return webBrowser;
            }
            case FIREFOX: {
                WebBrowser webBrowser = browserManager.getFirstBrowser(BrowserFamily.FIREFOX);
                if (webBrowser == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "qualifierToBrowser"));
                }
                return webBrowser;
            }
            case OPERA: {
                WebBrowser webBrowser = browserManager.getFirstBrowser(BrowserFamily.OPERA);
                if (webBrowser == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "qualifierToBrowser"));
                }
                return webBrowser;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public Promise<?> ensureExtensionInstalled(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/browserConnection/BrowserConnectionManager", "ensureExtensionInstalled"));
        }
        if (this.findConnectedBrowser(browser) != null || JsFileUtil.isWebKitRuntime(browser)) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "ensureExtensionInstalled"));
            }
            return promise;
        }
        BrowserConnector connector = BrowserConnector.get(browser);
        Promise<?> promise = connector == null ? Promises.rejectedPromise() : connector.ensureExtensionInstalled(browser, project);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "ensureExtensionInstalled"));
        }
        return promise;
    }

    public void launchBrowser(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/browserConnection/BrowserConnectionManager", "launchBrowser"));
        }
        if (this.findConnectedBrowser(browser) != null) {
            return;
        }
        BrowserConnector connector = BrowserConnector.get(browser);
        BrowserLauncher.getInstance().browseUsingPath(null, null, browser, project, connector == null ? ArrayUtil.EMPTY_STRING_ARRAY : connector.getLaunchParameters());
    }

    @NotNull
    public Promise<Double> attachInspector(@NotNull Client client, @NotNull CharSequence url, boolean usePreliminaryPage) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/jetbrains/browserConnection/BrowserConnectionManager", "attachInspector"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/browserConnection/BrowserConnectionManager", "attachInspector"));
        }
        assert (this.rpcServer != null);
        Promise promise = this.rpcServer.call(client, "Debugger", "attach", new Object[]{url, usePreliminaryPage});
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager", "attachInspector"));
        }
        return promise;
    }

    public void openUrl(Client client, CharSequence url) {
        assert (this.rpcServer != null);
        this.rpcServer.send(client, "Dom", "openUrl", new Object[]{url});
    }

    static final class BrowserConnectionRequestHandler
    extends WebSocketHandshakeHandler {
        BrowserConnectionRequestHandler() {
        }

        protected void serverCreated(@NotNull ClientManager server) {
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/browserConnection/BrowserConnectionManager$BrowserConnectionRequestHandler", "serverCreated"));
            }
            BrowserConnectionManager browserConnectionManager = BrowserConnectionManager.getInstance();
            browserConnectionManager.server = server;
            browserConnectionManager.rpcServer = new JsonRpcServer(server);
            JsonRpcServerKt.registerFromEp((JsonRpcServer)browserConnectionManager.rpcServer);
        }

        public boolean isSupported(@NotNull FullHttpRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/browserConnection/BrowserConnectionManager$BrowserConnectionRequestHandler", "isSupported"));
            }
            return super.isSupported(request) && BrowserConnectionRequestHandler.checkPrefix((String)request.uri(), (String)"jsonRpc");
        }

        @NotNull
        protected MessageServer getMessageServer() {
            JsonRpcServer jsonRpcServer = BrowserConnectionManager.getInstance().rpcServer;
            if (jsonRpcServer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/browserConnection/BrowserConnectionManager$BrowserConnectionRequestHandler", "getMessageServer"));
            }
            return jsonRpcServer;
        }

        public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
            BrowserQualifier browserQualifier;
            String userAgent;
            String version;
            block13: {
                if (client == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/jetbrains/browserConnection/BrowserConnectionManager$BrowserConnectionRequestHandler", "connected"));
                }
                ((ClientListener)BrowserConnectionManager.getInstance().webSocketServerListenerEventDispatcher.getMulticaster()).connected(client, parameters);
                version = BrowserConnectionManager.safeGet("v", parameters);
                userAgent = BrowserConnectionManager.safeGet("f", parameters);
                LOG.info("Browser connected: version " + version + ", " + userAgent);
                if (userAgent != null) {
                    try {
                        browserQualifier = BrowserQualifier.valueOf(userAgent);
                    }
                    catch (IllegalArgumentException ignored) {
                        if (userAgent.contains("YaBrowser/")) {
                            browserQualifier = BrowserQualifier.YANDEX;
                            break block13;
                        }
                        if (userAgent.contains("(Dart)")) {
                            browserQualifier = BrowserQualifier.DARTIUM;
                            break block13;
                        }
                        if (userAgent.contains(" OPR/")) {
                            browserQualifier = BrowserQualifier.OPERA;
                            break block13;
                        }
                        browserQualifier = BrowserQualifier.CHROME;
                    }
                } else {
                    browserQualifier = BrowserQualifier.CHROME;
                }
            }
            BROWSER_KEY.set((UserDataHolder)client, (Object)browserQualifier);
            BrowserConnector connector = BrowserConnector.get(browserQualifier);
            if (connector == null) {
                LOG.warn("No connector for " + userAgent);
                return;
            }
            WebBrowser browser = BrowserConnectionManager.qualifierToBrowser(browserQualifier);
            connector.checkVersion(browser, version, null);
            Collection asyncResults = BrowserConnectionManager.getInstance().pendingActions.remove((Object)browserQualifier);
            if (asyncResults != null) {
                for (AsyncPromise asyncResult : asyncResults) {
                    try {
                        asyncResult.setResult((Object)client);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }

        public void disconnected(@NotNull Client client) {
            if (client == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/jetbrains/browserConnection/BrowserConnectionManager$BrowserConnectionRequestHandler", "disconnected"));
            }
            ((ClientListener)BrowserConnectionManager.getInstance().webSocketServerListenerEventDispatcher.getMulticaster()).disconnected(client);
            BrowserQualifier browserQualifier = (BrowserQualifier)((Object)BROWSER_KEY.get((UserDataHolder)client));
            if (browserQualifier != null) {
                BROWSER_KEY.set((UserDataHolder)client, null);
                LOG.info("Browser disconnected: " + (Object)((Object)browserQualifier));
            }
        }
    }
}

