/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.settings.CustomObjectPresentationState;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.V8ValueMarkerProviderKt;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CustomPropertiesValuePresentation;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.values.ObjectValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a%\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0000\u00a8\u0006\u001d"}, d2={"doSetObjectPresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "properties", "", "Lorg/jetbrains/debugger/Variable;", "objectValue", "Lorg/jetbrains/debugger/values/ObjectValue;", "icon", "Ljavax/swing/Icon;", "getContextElement", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "project", "Lcom/intellij/openapi/project/Project;", "getDebugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "context", "Lorg/jetbrains/debugger/VariableContext;", "getPropertiesToShow", "", "isVariableVisible", "", "variable", "JavaScriptDebugger"})
public final class JavaScriptDebuggerViewSupportKt {
    public static final void doSetObjectPresentation(@NotNull XValueNode node, @NotNull List<? extends Variable> properties, @NotNull ObjectValue objectValue, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)objectValue, (String)"objectValue");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        if (properties.isEmpty()) {
            VariableView.Companion.setObjectPresentation(objectValue, icon, node);
        } else {
            node.setPresentation(icon, (XValuePresentation)new CustomPropertiesValuePresentation(objectValue, properties), true);
        }
    }

    @Nullable
    public static final PsiElement getContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return XDebuggerUtil.getInstance().findContextElement(virtualFile, offset, project, true);
    }

    @NotNull
    public static final JavaScriptDebugProcess<?> getDebugProcess(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DebuggerViewSupport debuggerViewSupport = context.getViewSupport();
        if (debuggerViewSupport == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport");
        }
        return ((JavaScriptDebuggerViewSupport)debuggerViewSupport).getDebugProcess();
    }

    public static final boolean isVariableVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        String name = variable.getName();
        return Intrinsics.areEqual((Object)name, (Object)"_jb_debug_helper") ^ true && Intrinsics.areEqual((Object)name, (Object)V8ValueMarkerProviderKt.MARKED_OBJECTS_PROPERTY) ^ true && Intrinsics.areEqual((Object)name, (Object)"$_JbV8DebuggerSupport") ^ true;
    }

    private static final List<String> getPropertiesToShow() {
        List<String> list;
        CustomObjectPresentationState presentationState = JavaScriptDebuggerSettings.getInstance().getObjectPresentation();
        if (presentationState.isEnabled()) {
            List<String> list2 = presentationState.getPropertiesToShow();
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"presentationState.propertiesToShow");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final /* synthetic */ List access$getPropertiesToShow() {
        return JavaScriptDebuggerViewSupportKt.getPropertiesToShow();
    }
}

