/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Function;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.jetbrains.javascript.debugger.execution.DebuggableRunProfileState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010%\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001c\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J!\u0010&\u001a\u0015\u0012\f\u0012\n -*\u0004\u0018\u00010$0$0,\u00a2\u0006\u0002\b.2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000,H\u0014J\u0010\u00101\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lcom/jetbrains/javascript/debugger/execution/DebuggableProcessState;", "T", "Lcom/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/execution/configurations/RunProfileState;", "Lcom/jetbrains/javascript/debugger/execution/DebuggableRunProfileState;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "getConfiguration", "()Lcom/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/jetbrains/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "inputPath", "", "getInputPath", "()Ljava/lang/String;", "addConsoleFilters", "", "builder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "addInputPathArg", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configureCommandLine", "debugPort", "", "configureEnvironment", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "isDebug", "", "createExecutionResult", "Lcom/intellij/execution/ExecutionResult;", "createProcessHandler", "execute", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "Lorg/jetbrains/concurrency/Promise;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "prepareDebug", "", "startProcess", "JavaScriptDebugger"})
public abstract class DebuggableProcessState<T extends DebuggableProcessRunConfiguration>
implements RunProfileState,
DebuggableRunProfileState {
    @NotNull
    private final T configuration;
    @NotNull
    private final ExecutionEnvironment environment;

    @NotNull
    protected String getInputPath() {
        String string = this.configuration.getInputPath();
        if (string == null) {
            throw (Throwable)new ExecutionException("Program input path not specified");
        }
        String inputPath = string;
        if (ScriptFileUtil.isMemoryScriptPath((String)inputPath)) {
            String string2 = inputPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inputPath");
            return string2;
        }
        String string3 = FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.environment.getProject())).expandPath(inputPath));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtilRt.toSystemDepen\u2026t).expandPath(inputPath))");
        return string3;
    }

    @NotNull
    public final ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<RunnerSettings> runner) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        return this.createExecutionResult(-1);
    }

    @Override
    @NotNull
    public final Promise<ExecutionResult> execute(int debugPort) {
        return this.prepareDebug().then((Function)new Function<Object, ExecutionResult>(this, debugPort){
            final /* synthetic */ DebuggableProcessState this$0;
            final /* synthetic */ int $debugPort;

            @NotNull
            public final ExecutionResult fun(@Nullable Object it) {
                return this.this$0.createExecutionResult(this.$debugPort);
            }
            {
                this.this$0 = debuggableProcessState;
                this.$debugPort = n;
            }
        });
    }

    @NotNull
    protected ExecutionResult createExecutionResult(int debugPort) {
        ProcessHandler processHandler = this.startProcess(debugPort);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)this.createConsole(processHandler, debugPort != -1), processHandler);
    }

    private final ConsoleView createConsole(ProcessHandler processHandler, boolean isDebug) {
        ConsoleView console2;
        if (isDebug) {
            return null;
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.environment.getProject());
        if (consoleBuilder instanceof TextConsoleBuilderImpl) {
            ((TextConsoleBuilderImpl)consoleBuilder).setUsePredefinedMessageFilter(true);
        }
        TextConsoleBuilder textConsoleBuilder = consoleBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)textConsoleBuilder, (String)"consoleBuilder");
        this.addConsoleFilters(textConsoleBuilder);
        ConsoleView consoleView = console2 = consoleBuilder.getConsole();
        if (consoleView == null) {
            Intrinsics.throwNpe();
        }
        consoleView.attachToProcess(processHandler);
        return console2;
    }

    protected void addConsoleFilters(@NotNull TextConsoleBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
    }

    @NotNull
    protected Promise<Object> prepareDebug() {
        return Promises.resolvedPromise();
    }

    @NotNull
    protected final ProcessHandler startProcess(int debugPort) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String string = this.configuration.getEffectiveExePath();
        if (string == null) {
            throw (Throwable)new ExecutionException("Program path not specified");
        }
        String exePath = string;
        commandLine.setExePath(this.configuration.correctExePath(exePath));
        String string2 = this.configuration.getEffectiveWorkingDirectory();
        if (string2 != null) {
            String string3 = string2;
            String it = string3;
            commandLine.withWorkDirectory(it);
        }
        this.configureCommandLine(commandLine, debugPort);
        this.configureEnvironment(commandLine);
        ProcessHandler processHandler = this.createProcessHandler(commandLine, debugPort);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)this.environment.getProject());
        return processHandler;
    }

    protected void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        commandLine.withEnvironment(this.configuration.getEnvs());
        commandLine.withParentEnvironmentType(this.configuration.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    protected final void addInputPathArg(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        commandLine.addParameters(new String[]{this.getInputPath()});
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return (ProcessHandler)new OSProcessHandler(commandLine);
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
    }

    @NotNull
    protected final T getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public DebuggableProcessState(@NotNull T configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
    }
}

