/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.files.FtlEditorHighlighter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.FreemarkerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlFileType
extends LanguageFileType
implements TemplateLanguageFileType {
    public static final FtlFileType INSTANCE = new FtlFileType();

    private FtlFileType() {
        super((Language)FtlLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/freemarker/psi/files/FtlFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/freemarker/psi/files/FtlFileType$1", "getEditorHighlighter"));
                }
                return new FtlEditorHighlighter(project, virtualFile, colors);
            }
        });
    }

    @NotNull
    @NonNls
    public String getName() {
        if ("FTL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFileType", "getName"));
        }
        return "FTL";
    }

    @NotNull
    public String getDescription() {
        String string = FreeMarkerBundle.message("file.type.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        if ("ftl" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFileType", "getDefaultExtension"));
        }
        return "ftl";
    }

    @Nullable
    public Icon getIcon() {
        return FreemarkerIcons.Freemarker_icon;
    }
}

