/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSInjectionController;
import com.intellij.lang.javascript.JSLanguageInjector;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Arrays;
import java.util.List;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.lang.injection.CoffeeScriptInjectionUtil;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.psi.impl.CoffeeScriptHeregexImpl;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptInjector
implements MultiHostInjector {
    private static final Language regexpLanguage = Language.findLanguageByID((String)"RegExp");

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element) {
        String text;
        int offset;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/coffeescript/lang/injection/CoffeeScriptInjector", "getLanguagesToInject"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/injection/CoffeeScriptInjector", "getLanguagesToInject"));
        }
        if (element instanceof JSLiteralExpression) {
            ASTNode firstChild = element.getNode().getFirstChildNode();
            if (firstChild != null && firstChild.getElementType() == CoffeeScriptTokenTypes.HEREDOC_START) {
                if (JSInjectionController.willInjectHtml((PsiElement)element)) {
                    CoffeeScriptInjectionUtil.injectInDocString(registrar, element, (Language)HTMLLanguage.INSTANCE);
                }
            } else if (CoffeeScriptUtil.isCoffeeScriptContent(element) && firstChild != null && firstChild.getElementType() == CoffeeScriptTokenTypes.STRING_LITERAL) {
                HTMLLanguage languageToInject = null;
                if (JSInjectionController.willInjectHtml((PsiElement)element)) {
                    languageToInject = HTMLLanguage.INSTANCE;
                } else if (JSInjectionController.willInjectCss((PsiElement)element)) {
                    languageToInject = CSSLanguage.INSTANCE;
                }
                if (languageToInject != null) {
                    CoffeeScriptInjectionUtil.injectInString(registrar, element, (Language)languageToInject);
                }
            } else if (CoffeeScriptUtil.isCoffeeScriptContent(element) && ((JSLiteralExpression)element).isRegExpLiteral()) {
                JSLanguageInjector.injectRegex((MultiHostRegistrar)registrar, (PsiElement)element);
            }
        } else if (element instanceof CoffeeScriptHeregexImpl && (offset = (text = element.getText()).lastIndexOf("///")) > 3) {
            TextRange range = new TextRange(3, offset);
            registrar.startInjecting(regexpLanguage).addPlace(null, null, (PsiLanguageInjectionHost)element, range).doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(JSLiteralExpression.class, CoffeeScriptHeregexImpl.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/injection/CoffeeScriptInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

