/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.manipulators;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.hibernate.model.enums.CascadeType;
import com.intellij.hibernate.model.enums.HibernateAttributeType;
import com.intellij.hibernate.model.enums.LazyType;
import com.intellij.hibernate.model.enums.NotFoundType;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmClass;
import com.intellij.hibernate.model.xml.mapping.HbmClassBase;
import com.intellij.hibernate.model.xml.mapping.HbmColumn;
import com.intellij.hibernate.model.xml.mapping.HbmColumnsHolderBase;
import com.intellij.hibernate.model.xml.mapping.HbmComponent;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeElement;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeId;
import com.intellij.hibernate.model.xml.mapping.HbmContainer;
import com.intellij.hibernate.model.xml.mapping.HbmElement;
import com.intellij.hibernate.model.xml.mapping.HbmId;
import com.intellij.hibernate.model.xml.mapping.HbmIdbag;
import com.intellij.hibernate.model.xml.mapping.HbmList;
import com.intellij.hibernate.model.xml.mapping.HbmMap;
import com.intellij.hibernate.model.xml.mapping.HbmPersistentObjectBase;
import com.intellij.hibernate.model.xml.mapping.HbmPersistentObjectBaseEx;
import com.intellij.hibernate.model.xml.mapping.HbmPrimitiveArray;
import com.intellij.hibernate.model.xml.mapping.HbmProperty;
import com.intellij.hibernate.model.xml.mapping.HbmPropertyBase;
import com.intellij.hibernate.model.xml.mapping.HbmQuery;
import com.intellij.hibernate.model.xml.mapping.HbmRelationAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmSet;
import com.intellij.hibernate.model.xml.mapping.HbmTableInfoProvider;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.model.manipulators.ObjectManipulatorBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.model.manipulators.PersistentRelationshipAttributeManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.JdbcTypesUtil;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class HibernateObjectManipulator
extends ObjectManipulatorBase<HbmPersistentObjectBase> {
    public HibernateObjectManipulator(HbmPersistentObjectBase target) {
        super((PersistentObject)target);
    }

    public List<PersistenceAction> getCreateActions() {
        ArrayList<PersistenceAction> result = new ArrayList<PersistenceAction>();
        for (AttributeType type : AttributeType.values()) {
            if (!(type instanceof HibernateAttributeType) || !ReflectionUtil.isAssignable(DomElement.class, (Class)type.getAttributeClass())) continue;
            result.add((PersistenceAction)new MyDomAttributeAction(this, (HibernateAttributeType)type));
        }
        return result;
    }

    public void setTable(DasTable tableInfo) throws IncorrectOperationException {
        HbmPersistentObjectBase target = (HbmPersistentObjectBase)this.getManipulatorTarget();
        assert (target instanceof HbmTableInfoProvider);
        HbmTableInfoProvider tableInfoProvider = (HbmTableInfoProvider)((Object)target);
        tableInfoProvider.getTableName().setStringValue(tableInfo.getName());
        tableInfoProvider.getSchema().setStringValue(DasUtil.getSchema((DasObject)tableInfo));
        if (StringUtil.isNotEmpty((String)DasUtil.getCatalog((DasObject)tableInfo))) {
            tableInfoProvider.getCatalog().setStringValue(DasUtil.getCatalog((DasObject)tableInfo));
        }
    }

    public PersistentEmbeddedAttribute addEmbeddedAttribute(PersistentEmbeddable embeddable, String attributeName, PropertyMemberType accessMode) throws IncorrectOperationException {
        PsiClass embeddableClass;
        HbmPersistentObjectBase object = (HbmPersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof HbmClassBase);
        HbmComponent component = ((HbmClassBase)object).addComponent();
        component.getName().setValue((Object)attributeName);
        component.getClazz().setValue(embeddable.getClazz().getValue());
        if (this.ensureClassExists() == null) {
            return component;
        }
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)embeddable, PersistentObjectManipulator.class);
        if (manipulator == null || (embeddableClass = manipulator.ensureClassExists()) == null) {
            return component;
        }
        component.getClazz().setValue(embeddable.getClazz().getValue());
        this.ensurePropertyExists((PsiClass)((HbmPersistentObjectBase)this.getManipulatorTarget()).getClazz().getValue(), attributeName, (PsiType)JavaPsiFacade.getInstance((Project)embeddableClass.getProject()).getElementFactory().createType(embeddableClass), accessMode, PsiAnnotation.EMPTY_ARRAY);
        return component;
    }

    public PersistentRelationshipAttribute addRelationshipAttribute(PersistentEntityBase entity, RelationshipType relationshipType, JavaContainerType containerType, String attributeName, String targetAttributeName, boolean inverse, boolean optional, String fetchType, Collection<String> cascadeVariants, PropertyMemberType accessMode) throws IncorrectOperationException {
        PsiClass psiClass;
        PsiClass curClass;
        DomElement parent;
        boolean sameAttr;
        HbmRelationAttributeBase attrBase;
        HbmPersistentObjectBase object = (HbmPersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof HbmClassBase);
        HbmClassBase thisEntity = (HbmClassBase)object;
        switch (relationshipType) {
            case MANY_TO_MANY: {
                attrBase = HibernateObjectManipulator.addContainer(thisEntity, containerType, false).getManyToMany();
                break;
            }
            case MANY_TO_ONE: {
                attrBase = thisEntity.addManyToOne();
                break;
            }
            case ONE_TO_MANY: {
                attrBase = HibernateObjectManipulator.addContainer(thisEntity, containerType, false).getOneToMany();
                break;
            }
            case ONE_TO_ONE: {
                attrBase = thisEntity.addOneToOne();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        attrBase.getName().setValue((Object)attributeName);
        ArrayList<CascadeType> cascadeTypesValue = new ArrayList<CascadeType>();
        for (CascadeType cascadeType : CascadeType.values()) {
            if (!cascadeVariants.contains(cascadeType.getDisplayName())) continue;
            cascadeTypesValue.add(cascadeType);
        }
        if (!cascadeTypesValue.isEmpty()) {
            attrBase.getCascade().setValue(cascadeTypesValue);
        }
        if (fetchType != null) {
            for (Enum enum_ : LazyType.values()) {
                if (!((LazyType)enum_).getDisplayName().equals(fetchType)) continue;
                attrBase.getLazy().setValue((Object)enum_);
                break;
            }
        }
        boolean bl = sameAttr = thisEntity == entity && attributeName.equals(targetAttributeName);
        if (optional && attrBase instanceof HbmRelationAttributeBase.AnyToManyBase) {
            ((HbmRelationAttributeBase.AnyToManyBase)attrBase).getNotFound().setValue((Object)(optional ? NotFoundType.IGNORE : NotFoundType.EXCEPTION));
        }
        if (inverse && !sameAttr && (parent = attrBase.getParent()) instanceof HbmContainer && !(parent instanceof HbmPrimitiveArray) && !(parent instanceof HbmIdbag)) {
            ((HbmContainer)parent).getInverse().setValue((Object)Boolean.TRUE);
        }
        if ((curClass = this.ensureClassExists()) == null) {
            return attrBase;
        }
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)entity, PersistentObjectManipulator.class);
        if (manipulator == null || (psiClass = manipulator.ensureClassExists()) == null) {
            return attrBase;
        }
        attrBase.getTargetEntityClass().setValue((Object)psiClass);
        PsiClassType entityClassType = JavaPsiFacade.getInstance((Project)curClass.getProject()).getElementFactory().createType(psiClass);
        PsiClassType propertyType = relationshipType.isMany(false) ? containerType.createCollectionType((PsiElement)curClass, (PsiType)entityClassType, null) : entityClassType;
        this.ensurePropertyExists(curClass, attributeName, (PsiType)propertyType, accessMode, PsiAnnotation.EMPTY_ARRAY);
        return attrBase;
    }

    @NotNull
    private static HbmContainer addContainer(HbmPersistentObjectBaseEx thisEntity, JavaContainerType containerType, boolean isPrimitive) {
        switch (containerType) {
            case ARRAY: {
                HbmContainer hbmContainer = isPrimitive ? thisEntity.addPrimitiveArray() : thisEntity.addArray();
                if (hbmContainer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/manipulators/HibernateObjectManipulator", "addContainer"));
                }
                return hbmContainer;
            }
            case COLLECTION: {
                HbmSet hbmSet = thisEntity.addSet();
                if (hbmSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/manipulators/HibernateObjectManipulator", "addContainer"));
                }
                return hbmSet;
            }
            case LIST: {
                HbmList hbmList = thisEntity.addList();
                if (hbmList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/manipulators/HibernateObjectManipulator", "addContainer"));
                }
                return hbmList;
            }
            case MAP: {
                HbmMap hbmMap = thisEntity.addMap();
                if (hbmMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/manipulators/HibernateObjectManipulator", "addContainer"));
                }
                return hbmMap;
            }
            case SET: {
                HbmSet hbmSet = thisEntity.addSet();
                if (hbmSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/manipulators/HibernateObjectManipulator", "addContainer"));
                }
                return hbmSet;
            }
        }
        throw new AssertionError(containerType);
    }

    public void addCascadeVariants(Collection<String> cascadeVariants) {
        for (CascadeType type : CascadeType.values()) {
            cascadeVariants.add(type.getValue());
        }
    }

    public void addFetchVariants(Collection<String> fetchVariants) {
        for (LazyType type : LazyType.values()) {
            fetchVariants.add(type.getDisplayName());
        }
    }

    public PersistentAttribute addAttribute(String name, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns) throws IncorrectOperationException {
        HbmPersistentObjectBase object = (HbmPersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof HbmClassBase);
        HbmClassBase thisEntity = (HbmClassBase)object;
        HbmProperty attrBase = thisEntity.addProperty();
        attrBase.getName().setValue((Object)name);
        HibernateObjectManipulator.setColumns(attrBase, columns, true, this.isGenerateColumnProperties());
        PsiClass curClass = this.ensureClassExists();
        if (curClass == null) {
            return attrBase;
        }
        this.ensurePropertyExists(curClass, name, attributeType, accessType, PsiAnnotation.EMPTY_ARRAY);
        return attrBase;
    }

    public PersistentAttribute addIdAttribute(boolean compositeId, String name, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns) throws IncorrectOperationException {
        HbmPropertyBase attrBase;
        HbmPersistentObjectBase object = (HbmPersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof HbmClass);
        HbmClass thisEntity = (HbmClass)object;
        HbmPropertyBase hbmPropertyBase = attrBase = compositeId ? thisEntity.getCompositeId().addProperty() : thisEntity.getId();
        if (compositeId) {
            thisEntity.getCompositeId().getMapped().setValue((Object)Boolean.TRUE);
        }
        attrBase.getName().setValue((Object)name);
        HibernateObjectManipulator.setColumns(attrBase, columns, true, this.isGenerateColumnProperties());
        PsiClass curClass = this.ensureClassExists();
        if (curClass == null) {
            return attrBase;
        }
        this.ensurePropertyExists(curClass, name, attributeType, accessType, PsiAnnotation.EMPTY_ARRAY);
        return attrBase;
    }

    static void setColumns(HbmColumnsHolderBase columnsHolder, Collection<? extends DasColumn> columns, boolean insertSqlType, boolean columnProperties) {
        if (columns.size() == 1 && !columnProperties) {
            columnsHolder.getColumn().setValue((Object)columns.iterator().next().getName());
        } else {
            columnsHolder.getColumn().undefine();
            for (DasColumn dasColumn : columns) {
                boolean notNull;
                HbmColumn column = columnsHolder.addColumn();
                column.getName().setValue((Object)dasColumn.getName());
                if (!columnProperties) continue;
                if (insertSqlType) {
                    DataType dataType = dasColumn.getDataType();
                    column.getSqlType().setValue((Object)dataType.getSpecification().toLowerCase(Locale.ENGLISH));
                    int jdbcType = JdbcTypesUtil.getJdbcType((DasTypedObject)dasColumn, null);
                    if (JdbcUtil.hasLength((int)jdbcType)) {
                        int length = dataType.getLength();
                        if (length > 0 && length != 255) {
                            column.getLength().setValue((Object)length);
                        }
                    } else if (JdbcUtil.hasScaleAndPrecision((int)jdbcType)) {
                        int precision = dataType.getPrecision();
                        int scale = dataType.getScale();
                        if (precision != 0) {
                            column.getPrecision().setValue((Object)precision);
                        }
                        if (scale != 0) {
                            column.getScale().setValue((Object)scale);
                        }
                    }
                }
                if (!(notNull = !dasColumn.isNotNull())) continue;
                column.getNotNull().setValue((Object)notNull);
            }
        }
    }

    public void setIdClass(String qualifiedName) throws IncorrectOperationException {
        HbmPersistentObjectBase target = (HbmPersistentObjectBase)this.getManipulatorTarget();
        assert (target instanceof HbmClass);
        ((HbmClass)target).getCompositeId().getClazz().setStringValue(qualifiedName);
    }

    public void addNamedQuery(String queryName, String queryText) {
        HbmPersistentObjectBase target = (HbmPersistentObjectBase)this.getManipulatorTarget();
        assert (target instanceof HbmClassBase);
        HbmQuery query = ((HbmClassBase)target).addQuery();
        query.getName().setValue((Object)queryName);
        query.setValue(queryText);
    }

    public static class MyDomAttributeAction
    extends ObjectManipulatorBase.MyAttributeAction<HibernateObjectManipulator> {
        public MyDomAttributeAction(HibernateObjectManipulator manipulator, HibernateAttributeType attributeType) {
            super((ObjectManipulatorBase)manipulator, (AttributeType)attributeType);
        }

        protected RelationshipType getRelationshipType() {
            return this.myAttributeType.getRelationshipType();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (this.getPresentation().isEnabled()) {
                this.getPresentation().setEnabled(this.acceptedBy((PersistentObject)((HibernateObjectManipulator)this.getManipulator()).getManipulatorTarget()));
            }
        }

        public Object getActionKey() {
            return this.myAttributeType == HibernateAttributeType.ELEMENTS || this.myAttributeType == HibernateAttributeType.COMPOSITE_ELEMENTS || this.myAttributeType == HibernateAttributeType.TIMESTAMP ? this.myAttributeType : super.getActionKey();
        }

        private boolean acceptedBy(PersistentObject object) {
            if (this.myAttributeType == HibernateAttributeType.MANY_TO_ONE || this.myAttributeType == HibernateAttributeType.PROPERTY) {
                return object instanceof HbmPersistentObjectBase;
            }
            if (this.myAttributeType == HibernateAttributeType.ELEMENTS || this.myAttributeType == HibernateAttributeType.COMPOSITE_ELEMENTS || this.myAttributeType == HibernateAttributeType.COMPONENT || this.myAttributeType == HibernateAttributeType.DYNAMIC_COMPONENT || this.myAttributeType == HibernateAttributeType.ANY || this.myAttributeType == HibernateAttributeType.ONE_TO_MANY || this.myAttributeType == HibernateAttributeType.ONE_TO_ONE || this.myAttributeType == HibernateAttributeType.MANY_TO_MANY) {
                return object instanceof HbmPersistentObjectBaseEx;
            }
            if (this.myAttributeType == HibernateAttributeType.ID || this.myAttributeType == HibernateAttributeType.TIMESTAMP || this.myAttributeType == HibernateAttributeType.VERSION || this.myAttributeType == HibernateAttributeType.COMPOSITE_ID) {
                return object instanceof HbmClass;
            }
            throw new AssertionError();
        }

        public void invokeAction(@NotNull Collection<PsiElement> result) throws IncorrectOperationException {
            HbmAttributeBase attribute;
            HbmContainer attributeContainer;
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/hibernate/model/manipulators/HibernateObjectManipulator$MyDomAttributeAction", "invokeAction"));
            }
            HbmPersistentObjectBase object = (HbmPersistentObjectBase)((HibernateObjectManipulator)this.getManipulator()).getManipulatorTarget();
            JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)this.myInfo.type);
            PsiClass attributeClass = this.myInfo.type instanceof PsiClassType ? ((PsiClassType)this.myInfo.type).resolve() : null;
            PsiClass elementClass = PsiTypesUtil.getPsiClass((PsiType)typeInfo.getValueType());
            boolean containerType = this.myAttributeType.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY);
            if (containerType) {
                assert (typeInfo.containerType != null);
                boolean isPrimitive = typeInfo.getValueType() != null && typeInfo.getValueType() instanceof PsiPrimitiveType;
                attributeContainer = HibernateObjectManipulator.addContainer((HbmPersistentObjectBaseEx)object, typeInfo.containerType, isPrimitive);
            } else {
                attributeContainer = null;
            }
            if (this.myAttributeType == HibernateAttributeType.ANY) {
                attribute = ((HbmPersistentObjectBaseEx)object).addAny();
            } else if (this.myAttributeType == HibernateAttributeType.COMPONENT) {
                HbmComponent component = ((HbmPersistentObjectBaseEx)object).addComponent();
                component.getClazz().setValue((Object)attributeClass);
                attribute = component;
            } else if (this.myAttributeType == HibernateAttributeType.DYNAMIC_COMPONENT) {
                attribute = ((HbmPersistentObjectBaseEx)object).addDynamicComponent();
            } else if (this.myAttributeType == HibernateAttributeType.COMPOSITE_ELEMENTS) {
                assert (attributeContainer != null);
                HbmCompositeElement compositeElement = attributeContainer.getCompositeElement();
                compositeElement.getClazz().setValue((Object)elementClass);
                attribute = compositeElement;
            } else if (this.myAttributeType == HibernateAttributeType.COMPOSITE_ID) {
                HbmCompositeId compositeId = ((HbmClass)object).getCompositeId();
                compositeId.getClazz().setValue((Object)elementClass);
                attribute = compositeId;
            } else if (this.myAttributeType == HibernateAttributeType.ELEMENTS) {
                assert (attributeContainer != null);
                HbmElement element = attributeContainer.getElement();
                element.getTypeAttr().setValue((Object)typeInfo.getValueType());
                attribute = element;
            } else if (this.myAttributeType == HibernateAttributeType.ID) {
                HbmId id = ((HbmClass)object).getId();
                attribute = id;
                if (this.myInfo.generated && id.getGenerator().getXmlElement() == null) {
                    id.getGenerator().getClazz().setStringValue("native");
                }
            } else if (this.myAttributeType == HibernateAttributeType.MANY_TO_MANY) {
                assert (attributeContainer != null);
                attribute = attributeContainer.getManyToMany();
            } else if (this.myAttributeType == HibernateAttributeType.MANY_TO_ONE) {
                attribute = object.addManyToOne();
            } else if (this.myAttributeType == HibernateAttributeType.ONE_TO_MANY) {
                assert (attributeContainer != null);
                attribute = attributeContainer.getOneToMany();
            } else if (this.myAttributeType == HibernateAttributeType.ONE_TO_ONE) {
                attribute = ((HbmPersistentObjectBaseEx)object).addOneToOne();
            } else if (this.myAttributeType == HibernateAttributeType.PROPERTY) {
                attribute = object.addProperty();
            } else if (this.myAttributeType == HibernateAttributeType.TIMESTAMP) {
                attribute = ((HbmClass)object).getTimestamp();
            } else if (this.myAttributeType == HibernateAttributeType.VERSION) {
                attribute = ((HbmClass)object).getVersion();
            } else {
                throw new AssertionError((Object)("invalid type: " + this.myAttributeType));
            }
            attribute.getName().setValue((Object)this.myInfo.name);
            if (this.getRelationshipType() != null) {
                ((HbmRelationAttributeBase)attribute).getTargetEntityClass().setValue((Object)(containerType ? elementClass : attributeClass));
                PersistentRelationshipAttributeManipulator manipulator = (PersistentRelationshipAttributeManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)attribute, PersistentRelationshipAttributeManipulator.class);
                if (manipulator != null) {
                    manipulator.setMappedByAndInverse(this.myInfo.targetAttribute, this.myInfo.inverse);
                }
            }
            super.invokeAction(result);
        }
    }
}

