/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import com.intellij.lang.PsiBuilder;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.jetbrains.annotations.NotNull;

public class PsiBuilderFillingVisitor
extends RecursiveVisitor {
    @NotNull
    private final PsiBuilder builder;

    public PsiBuilderFillingVisitor(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/intellij/plugins/markdown/lang/parser/PsiBuilderFillingVisitor", "<init>"));
        }
        this.builder = builder;
    }

    public void visitNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/parser/PsiBuilderFillingVisitor", "visitNode"));
        }
        if (node instanceof LeafASTNode) {
            return;
        }
        this.ensureBuilderInPosition(node.getStartOffset());
        PsiBuilder.Marker marker = this.builder.mark();
        super.visitNode(node);
        this.ensureBuilderInPosition(node.getEndOffset());
        marker.done(MarkdownElementType.platformType(node.getType()));
    }

    private void ensureBuilderInPosition(int position) {
        while (this.builder.getCurrentOffset() < position) {
            this.builder.advanceLexer();
        }
        if (this.builder.getCurrentOffset() != position) {
            throw new AssertionError((Object)"parsed tree and lexer are unsynchronized");
        }
    }
}

