/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.DelegatingItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.jetbrains.annotations.NotNull;

public class MarkdownHeaderImpl
extends MarkdownCompositePsiElementBase {
    public MarkdownHeaderImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderImpl", "<init>"));
        }
        super(node);
    }

    @Override
    protected String getPresentableTagName() {
        return "h" + this.getHeaderNumber();
    }

    @Override
    public ItemPresentation getPresentation() {
        return new DelegatingItemPresentation(super.getPresentation()){

            public String getLocationString() {
                if (!MarkdownHeaderImpl.this.isValid()) {
                    return null;
                }
                PsiElement contentHolder = MarkdownHeaderImpl.this.findChildByType(MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES);
                if (contentHolder == null) {
                    return null;
                }
                return contentHolder.getText();
            }
        };
    }

    private int getHeaderNumber() {
        IElementType type = this.getNode().getElementType();
        if (MarkdownTokenTypeSets.HEADER_LEVEL_1_SET.contains(type)) {
            return 1;
        }
        if (MarkdownTokenTypeSets.HEADER_LEVEL_2_SET.contains(type)) {
            return 2;
        }
        if (type == MarkdownElementTypes.ATX_3) {
            return 3;
        }
        if (type == MarkdownElementTypes.ATX_4) {
            return 4;
        }
        if (type == MarkdownElementTypes.ATX_5) {
            return 5;
        }
        if (type == MarkdownElementTypes.ATX_6) {
            return 6;
        }
        throw new IllegalStateException("Type should be one of header types");
    }
}

