/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.xmlb.annotations.Attribute;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.jetbrains.annotations.NotNull;

public abstract class MarkdownHtmlPanelProvider {
    public static final ExtensionPointName<MarkdownHtmlPanelProvider> EP_NAME = ExtensionPointName.create((String)"org.intellij.markdown.html.panel.provider");
    private static MarkdownHtmlPanelProvider[] ourProviders = null;

    @NotNull
    public abstract MarkdownHtmlPanel createHtmlPanel();

    @NotNull
    public abstract AvailabilityInfo isAvailable();

    @NotNull
    public abstract ProviderInfo getProviderInfo();

    @NotNull
    public static MarkdownHtmlPanelProvider[] getProviders() {
        if (ourProviders == null) {
            ourProviders = (MarkdownHtmlPanelProvider[])EP_NAME.getExtensions();
        }
        if (ourProviders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider", "getProviders"));
        }
        return ourProviders;
    }

    @NotNull
    public static MarkdownHtmlPanelProvider createFromInfo(@NotNull ProviderInfo providerInfo) {
        MarkdownHtmlPanelProvider markdownHtmlPanelProvider;
        if (providerInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerInfo", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider", "createFromInfo"));
        }
        try {
            markdownHtmlPanelProvider = (MarkdownHtmlPanelProvider)Class.forName(providerInfo.getClassName()).newInstance();
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)("Cannot set preview panel provider (" + providerInfo.getName() + "):\n" + e.getMessage()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            Logger.getInstance(MarkdownHtmlPanelProvider.class).error((Throwable)e);
            MarkdownHtmlPanelProvider markdownHtmlPanelProvider2 = MarkdownHtmlPanelProvider.getProviders()[0];
            if (markdownHtmlPanelProvider2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider", "createFromInfo"));
            }
            return markdownHtmlPanelProvider2;
        }
        if (markdownHtmlPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider", "createFromInfo"));
        }
        return markdownHtmlPanelProvider;
    }

    public static abstract class AvailabilityInfo {
        public static final AvailabilityInfo AVAILABLE = new AvailabilityInfo(){

            @Override
            public boolean checkAvailability(@NotNull JComponent parentComponent) {
                if (parentComponent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$AvailabilityInfo$1", "checkAvailability"));
                }
                return true;
            }
        };
        public static final AvailabilityInfo UNAVAILABLE = new AvailabilityInfo(){

            @Override
            public boolean checkAvailability(@NotNull JComponent parentComponent) {
                if (parentComponent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$AvailabilityInfo$2", "checkAvailability"));
                }
                return false;
            }
        };

        public abstract boolean checkAvailability(@NotNull JComponent var1);
    }

    public static class ProviderInfo {
        @Attribute(value="name")
        @NotNull
        private String myName;
        @Attribute(value="className")
        @NotNull
        private String className;

        private ProviderInfo() {
            this.myName = "";
            this.className = "";
        }

        public ProviderInfo(@NotNull String name, @NotNull String className) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo", "<init>"));
            }
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo", "<init>"));
            }
            this.myName = name;
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo", "getName"));
            }
            return string;
        }

        @NotNull
        public String getClassName() {
            String string = this.className;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo", "getClassName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProviderInfo info = (ProviderInfo)o;
            if (!this.myName.equals(info.myName)) {
                return false;
            }
            return this.className.equals(info.className);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.className.hashCode();
            return result;
        }

        public String toString() {
            return this.myName;
        }
    }
}

