/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.PageEngine;

public class BasePageEngine<T>
implements PageEngine<List<T>> {
    @NotNull
    private final List<List<T>> mySplitData;
    private int myIdx;

    public BasePageEngine(@NotNull List<T> data, int pageSize) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/dialogs/BasePageEngine", "<init>"));
        }
        this.mySplitData = JBIterable.from(data).partition(pageSize, false).toList();
        this.myIdx = 0;
    }

    @Override
    public List<T> getCurrent() {
        return this.mySplitData.get(this.myIdx);
    }

    @Override
    public boolean hasNext() {
        return this.myIdx < this.mySplitData.size() - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.myIdx > 0;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.myIdx;
        return this.mySplitData.get(this.myIdx);
    }

    @Override
    public List<T> previous() {
        if (!this.hasPrevious()) {
            return null;
        }
        --this.myIdx;
        return this.mySplitData.get(this.myIdx);
    }
}

