/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.treeConflict.ApplyPatchSaveToFileExecutor;
import org.jetbrains.idea.svn.treeConflict.SvnTreeConflictResolver;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class MergeFromTheirsResolver {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final TreeConflictDescription myDescription;
    @NotNull
    private final Change myChange;
    @NotNull
    private final FilePath myOldFilePath;
    @NotNull
    private final FilePath myNewFilePath;
    @NotNull
    private final String myOldPresentation;
    @NotNull
    private final String myNewPresentation;
    private final SvnRevisionNumber myCommittedRevision;
    private Boolean myAdd;
    @NotNull
    private final List<Change> myTheirsChanges;
    @NotNull
    private final List<Change> myTheirsBinaryChanges;
    @NotNull
    private final List<VcsException> myWarnings;
    private List<TextFilePatch> myTextPatches;
    private final VirtualFile myBaseForPatch;

    public MergeFromTheirsResolver(@NotNull SvnVcs vcs, @NotNull TreeConflictDescription description, @NotNull Change change, SvnRevisionNumber revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "<init>"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "<init>"));
        }
        this.myVcs = vcs;
        this.myDescription = description;
        this.myChange = change;
        this.myCommittedRevision = revision;
        this.myOldFilePath = ((ContentRevision)ObjectUtils.notNull((Object)this.myChange.getBeforeRevision())).getFile();
        this.myNewFilePath = ((ContentRevision)ObjectUtils.notNull((Object)this.myChange.getAfterRevision())).getFile();
        this.myBaseForPatch = ChangesUtil.findValidParentAccurately((FilePath)this.myNewFilePath);
        this.myOldPresentation = TreeConflictRefreshablePanel.filePath(this.myOldFilePath);
        this.myNewPresentation = TreeConflictRefreshablePanel.filePath(this.myNewFilePath);
        this.myTheirsChanges = ContainerUtilRt.newArrayList();
        this.myTheirsBinaryChanges = ContainerUtilRt.newArrayList();
        this.myWarnings = ContainerUtilRt.newArrayList();
        this.myTextPatches = Collections.emptyList();
    }

    public void execute() {
        String messageKey = this.myChange.isMoved() ? "confirmation.resolve.tree.conflict.merge.moved" : "confirmation.resolve.tree.conflict.merge.renamed";
        String message = SvnBundle.message(messageKey, this.myOldPresentation, this.myNewPresentation);
        int ok = Messages.showOkCancelDialog((Project)this.myVcs.getProject(), (String)message, (String)"Resolve tree conflict", (Icon)Messages.getQuestionIcon());
        if (0 != ok) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Continuation fragmented = Continuation.createFragmented((Project)this.myVcs.getProject(), (boolean)false);
        fragmented.addExceptionHandler(VcsException.class, e -> {
            this.myWarnings.add((VcsException)((Object)e));
            if (!e.isWarning()) {
                AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showErrors(this.myWarnings, "Resolve tree conflict");
            }
        });
        SmartList tasks = new SmartList();
        tasks.add(this.myDescription.isDirectory() ? new PreloadChangesContentsForDir() : new PreloadChangesContentsForFile());
        tasks.add(new ConvertTextPaths());
        tasks.add(new PatchCreator());
        tasks.add(new SelectPatchesInApplyPatchDialog());
        tasks.add(new SelectBinaryFiles());
        fragmented.run((List)tasks);
    }

    @Nullable
    private Collection<FilePath> chooseBinaryFiles(@NotNull List<Change> changes, @NotNull Set<FilePath> paths) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "chooseBinaryFiles"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "chooseBinaryFiles"));
        }
        String singleMessage = "";
        if (changes.size() == 1) {
            FileStatus status = changes.get(0).getFileStatus();
            FilePath path = ChangesUtil.getFilePath((Change)changes.get(0));
            String prefix = FileStatus.DELETED.equals(status) ? "Delete" : (FileStatus.ADDED.equals(status) ? "Create" : "Apply changes to");
            singleMessage = prefix + "binary file " + TreeConflictRefreshablePanel.filePath(path) + " (according to theirs changes)?";
        }
        return AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).selectFilePathsToProcess((List)ContainerUtilRt.newArrayList(paths), "Resolve tree conflict", "Select binary files to patch", "Resolve tree conflict", singleMessage, new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return null;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
            }

            public boolean isPersistent() {
                return false;
            }
        });
    }

    @NotNull
    private List<Change> convertPaths(@NotNull List<Change> changes) throws VcsException {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "convertPaths"));
        }
        this.initAddOption();
        ArrayList result = ContainerUtilRt.newArrayList();
        for (Change change : changes) {
            if (!MergeFromTheirsResolver.isUnderOldDir(change, this.myOldFilePath)) continue;
            result.add(new Change(this.convertBeforeRevision(change.getBeforeRevision()), this.convertAfterRevision(change, change.getAfterRevision())));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "convertPaths"));
        }
        return arrayList;
    }

    @Nullable
    private ContentRevision convertBeforeRevision(@Nullable ContentRevision revision) throws VcsException {
        return revision != null ? this.toSimpleRevision(revision, true) : null;
    }

    @Nullable
    private ContentRevision convertAfterRevision(@NotNull Change change, @Nullable ContentRevision revision) throws VcsException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "convertAfterRevision"));
        }
        if (revision == null) {
            return null;
        }
        return this.myAdd != false && (change.getBeforeRevision() == null || change.isMoved() || change.isRenamed()) ? revision : this.toSimpleRevision(revision, true);
    }

    @NotNull
    private SimpleContentRevision toSimpleRevision(@NotNull ContentRevision revision, boolean rebasePath) throws VcsException {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "toSimpleRevision"));
        }
        SimpleContentRevision simpleContentRevision = new SimpleContentRevision(revision.getContent(), rebasePath ? MergeFromTheirsResolver.rebasePath(this.myOldFilePath, this.myNewFilePath, revision.getFile()) : this.myNewFilePath, revision.getRevisionNumber().asString());
        if (simpleContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "toSimpleRevision"));
        }
        return simpleContentRevision;
    }

    private static boolean isUnderOldDir(@NotNull Change change, @NotNull FilePath path) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "isUnderOldDir"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "isUnderOldDir"));
        }
        FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
        return beforePath != null && FileUtil.isAncestor((String)path.getPath(), (String)beforePath.getPath(), (boolean)true) || afterPath != null && FileUtil.isAncestor((String)path.getPath(), (String)afterPath.getPath(), (boolean)true);
    }

    @NotNull
    private static FilePath rebasePath(@NotNull FilePath oldBase, @NotNull FilePath newBase, @NotNull FilePath path) {
        if (oldBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBase", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        if (newBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBase", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        String relativePath = (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)oldBase.getPath(), (String)path.getPath(), (char)'/'));
        FilePath filePath = VcsUtil.getFilePath((String)(newBase.getPath() + "/" + relativePath), (boolean)path.isDirectory());
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        return filePath;
    }

    private static void preloadRevisionContents(@Nullable ContentRevision revision) throws VcsException {
        if (revision != null) {
            if (revision instanceof BinaryContentRevision) {
                ((BinaryContentRevision)revision).getBinaryContent();
            } else {
                revision.getContent();
            }
        }
    }

    @NotNull
    private List<SvnChangeList> loadSvnChangeListsForPatch(@NotNull TreeConflictDescription description) throws VcsException {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "loadSvnChangeListsForPatch"));
        }
        long max = description.getSourceRightVersion().getPegRevision();
        long min = description.getSourceLeftVersion().getPegRevision();
        SvnRepositoryLocation location = new SvnRepositoryLocation(description.getSourceRightVersion().getRepositoryRoot().toString());
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_BEFORE = String.valueOf(max);
        settings.CHANGE_AFTER = String.valueOf(min);
        List committedChanges = ((CachingCommittedChangesProvider)ObjectUtils.notNull((Object)this.myVcs.getCachingCommittedChangesProvider())).getCommittedChanges(settings, (RepositoryLocation)location, 0);
        List list = ContainerUtil.filter((Collection)committedChanges, changeList -> changeList.getNumber() != min);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "loadSvnChangeListsForPatch"));
        }
        return list;
    }

    private void initAddOption() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAdd == null) {
            this.myAdd = this.getAddedFilesPlaceOption();
        }
    }

    private boolean getAddedFilesPlaceOption() {
        final SvnConfiguration configuration = this.myVcs.getSvnConfiguration();
        Boolean add = configuration.isKeepNewFilesAsIsForTreeConflictMerge();
        if (add != null) {
            return add;
        }
        if (!MergeFromTheirsResolver.containAdditions(this.myTheirsChanges) && !MergeFromTheirsResolver.containAdditions(this.myTheirsBinaryChanges)) {
            return false;
        }
        return 0 == ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Resolve tree conflict", (String)"Keep newly created file(s) in their original place?").yesText("Keep")).noText("Move")).doNotAsk(new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    configuration.setKeepNewFilesAsIsForTreeConflictMerge(exitCode == 0);
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$2", "getDoNotShowMessage"));
                }
                return string;
            }
        })).show();
    }

    private static boolean containAdditions(@NotNull List<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "containAdditions"));
        }
        return changes.stream().anyMatch(change -> change.getBeforeRevision() == null || change.isMoved() || change.isRenamed());
    }

    private class PreloadChangesContentsForDir
    extends TaskDescriptor {
        private PreloadChangesContentsForDir() {
            super("Getting base and theirs revisions content", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            List changes;
            try {
                changes = CommittedChangesTreeBrowser.collectChanges((List)MergeFromTheirsResolver.this.loadSvnChangeListsForPatch(MergeFromTheirsResolver.this.myDescription), (boolean)true);
                for (Change change : changes) {
                    MergeFromTheirsResolver.preloadRevisionContents(change.getBeforeRevision());
                    MergeFromTheirsResolver.preloadRevisionContents(change.getAfterRevision());
                }
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
                return;
            }
            Map<Boolean, List<Change>> changesSplit = changes.stream().collect(Collectors.partitioningBy(ChangesUtil::isBinaryChange));
            MergeFromTheirsResolver.this.myTheirsBinaryChanges.addAll((Collection)changesSplit.get(Boolean.TRUE));
            MergeFromTheirsResolver.this.myTheirsChanges.addAll((Collection)changesSplit.get(Boolean.FALSE));
        }
    }

    private class PreloadChangesContentsForFile
    extends TaskDescriptor {
        private PreloadChangesContentsForFile() {
            super("Getting base and theirs revisions content", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            SvnContentRevision base = SvnContentRevision.createBaseRevision(MergeFromTheirsResolver.this.myVcs, MergeFromTheirsResolver.this.myNewFilePath, MergeFromTheirsResolver.this.myCommittedRevision.getRevision());
            SvnContentRevision remote = SvnContentRevision.createRemote(MergeFromTheirsResolver.this.myVcs, MergeFromTheirsResolver.this.myOldFilePath, SVNRevision.create((long)MergeFromTheirsResolver.this.myDescription.getSourceRightVersion().getPegRevision()));
            try {
                MergeFromTheirsResolver.this.myTheirsChanges.add(new Change((ContentRevision)MergeFromTheirsResolver.this.toSimpleRevision((ContentRevision)base, false), (ContentRevision)MergeFromTheirsResolver.this.toSimpleRevision((ContentRevision)remote, false)));
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
        }
    }

    private class ApplyBinaryChanges
    extends TaskDescriptor {
        private ApplyBinaryChanges() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            if (MergeFromTheirsResolver.this.myTheirsBinaryChanges.isEmpty()) {
                return;
            }
            ArrayList dirtyPaths = ContainerUtilRt.newArrayList();
            for (Change change : MergeFromTheirsResolver.this.myTheirsBinaryChanges) {
                try {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        try {
                            if (change.getAfterRevision() == null) {
                                FilePath path = ((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getFile();
                                dirtyPaths.add(path);
                                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path.getPath());
                                if (file == null) {
                                    context.handleException((Exception)((Object)new VcsException("Can not delete file: " + path.getPath(), true)), false);
                                    return null;
                                }
                                file.delete(TreeConflictRefreshablePanel.class);
                            } else {
                                FilePath file = change.getAfterRevision().getFile();
                                dirtyPaths.add(file);
                                String parentPath = ((FilePath)ObjectUtils.notNull((Object)file.getParentPath())).getPath();
                                VirtualFile parentFile = VfsUtil.createDirectoryIfMissing((String)parentPath);
                                if (parentFile == null) {
                                    context.handleException((Exception)((Object)new VcsException("Can not create directory: " + parentPath, true)), false);
                                    return null;
                                }
                                VirtualFile child = parentFile.createChildData(TreeConflictRefreshablePanel.class, file.getName());
                                byte[] content = ((BinaryContentRevision)change.getAfterRevision()).getBinaryContent();
                                if (content == null) {
                                    context.handleException((Exception)((Object)new VcsException("Can not load Theirs content for file " + file.getPath())), false);
                                    return null;
                                }
                                child.setBinaryContent(content);
                            }
                        }
                        catch (IOException e) {
                            throw new VcsException((Throwable)e);
                        }
                        return null;
                    });
                }
                catch (VcsException e) {
                    context.handleException((Exception)((Object)e), true);
                    return;
                }
            }
            VcsDirtyScopeManager.getInstance((Project)MergeFromTheirsResolver.this.myVcs.getProject()).filePathsDirty((Collection)dirtyPaths, null);
        }
    }

    private class SelectBinaryFiles
    extends TaskDescriptor {
        private SelectBinaryFiles() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            List converted;
            try {
                converted = MergeFromTheirsResolver.this.convertPaths(MergeFromTheirsResolver.this.myTheirsBinaryChanges);
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
                return;
            }
            if (converted.isEmpty()) {
                return;
            }
            Map map = converted.stream().collect(Collectors.toMap(ChangesUtil::getFilePath, Function.identity()));
            Collection selected = MergeFromTheirsResolver.this.chooseBinaryFiles(converted, map.keySet());
            MergeFromTheirsResolver.this.myTheirsBinaryChanges.clear();
            if (!ContainerUtil.isEmpty((Collection)selected)) {
                for (FilePath filePath : selected) {
                    MergeFromTheirsResolver.this.myTheirsBinaryChanges.add(map.get(filePath));
                }
            }
        }
    }

    private class PatchCreator
    extends TaskDescriptor {
        private PatchCreator() {
            super("Creating patch for theirs changes", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            try {
                List patches = IdeaTextPatchBuilder.buildPatch((Project)MergeFromTheirsResolver.this.myVcs.getProject(), (Collection)MergeFromTheirsResolver.this.myTheirsChanges, (String)((VirtualFile)ObjectUtils.notNull((Object)MergeFromTheirsResolver.this.myBaseForPatch)).getPath(), (boolean)false);
                MergeFromTheirsResolver.this.myTextPatches = ContainerUtil.map((Collection)patches, o -> (TextFilePatch)o);
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
        }
    }

    private class DirectoryAddition
    extends TaskDescriptor {
        private DirectoryAddition() {
            super("Adding " + MergeFromTheirsResolver.this.myOldPresentation + " to Subversion", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            try {
                MergeFromTheirsResolver.this.myVcs.getFactory(MergeFromTheirsResolver.this.myOldFilePath.getIOFile()).createAddClient().add(MergeFromTheirsResolver.this.myOldFilePath.getIOFile(), Depth.EMPTY, true, false, true, null);
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
        }
    }

    private class TreeConflictApplyTheirsPatchExecutor
    implements ApplyPatchExecutor<TextFilePatchInProgress> {
        @NotNull
        private final SvnVcs myVcs;
        @NotNull
        private final ContinuationContext myInner;
        private final VirtualFile myBaseDir;

        public TreeConflictApplyTheirsPatchExecutor(@NotNull SvnVcs vcs, ContinuationContext inner, VirtualFile baseDir) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$TreeConflictApplyTheirsPatchExecutor", "<init>"));
            }
            if (inner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$TreeConflictApplyTheirsPatchExecutor", "<init>"));
            }
            this.myVcs = vcs;
            this.myInner = inner;
            this.myBaseDir = baseDir;
        }

        public String getName() {
            return "Apply Patch";
        }

        public void apply(@NotNull List<FilePatch> remaining, @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
            List<FilePatch> patches;
            if (remaining == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remaining", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$TreeConflictApplyTheirsPatchExecutor", "apply"));
            }
            if (patchGroupsToApply == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroupsToApply", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$TreeConflictApplyTheirsPatchExecutor", "apply"));
            }
            try {
                patches = ApplyPatchSaveToFileExecutor.toOnePatchGroup(patchGroupsToApply, this.myBaseDir);
            }
            catch (IOException e) {
                this.myInner.handleException((Exception)e, true);
                return;
            }
            new PatchApplier(this.myVcs.getProject(), this.myBaseDir, patches, localList, null, null).execute(false, true);
            boolean thereAreCreations = patches.stream().anyMatch(patch -> patch.isNewFile() || !Comparing.equal((String)patch.getAfterName(), (String)patch.getBeforeName()));
            if (thereAreCreations) {
                this.myInner.next(new TaskDescriptor[]{new DirectoryAddition()});
            }
            this.myInner.next(new TaskDescriptor[]{new ResolveConflictInSvn()});
            this.myInner.last(new TaskDescriptor[]{new ApplyBinaryChanges(), new FinalNotification()});
            this.myInner.ping();
        }
    }

    private class SelectPatchesInApplyPatchDialog
    extends TaskDescriptor {
        private SelectPatchesInApplyPatchDialog() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            LocalChangeList changeList = ChangeListManager.getInstance((Project)MergeFromTheirsResolver.this.myVcs.getProject()).getChangeList(MergeFromTheirsResolver.this.myChange);
            ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(MergeFromTheirsResolver.this.myVcs.getProject(), (ApplyPatchExecutor)new TreeConflictApplyTheirsPatchExecutor(MergeFromTheirsResolver.this.myVcs, context, MergeFromTheirsResolver.this.myBaseForPatch), Collections.singletonList(new ApplyPatchSaveToFileExecutor(MergeFromTheirsResolver.this.myVcs.getProject(), MergeFromTheirsResolver.this.myBaseForPatch)), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, MergeFromTheirsResolver.this.myTextPatches, changeList);
            context.suspend();
            dialog.show();
        }
    }

    private class ConvertTextPaths
    extends TaskDescriptor {
        private ConvertTextPaths() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            Object convertedChanges = new SmartList();
            try {
                convertedChanges = MergeFromTheirsResolver.this.convertPaths(MergeFromTheirsResolver.this.myTheirsChanges);
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
            MergeFromTheirsResolver.this.myTheirsChanges.clear();
            MergeFromTheirsResolver.this.myTheirsChanges.addAll(convertedChanges);
        }
    }

    private class ResolveConflictInSvn
    extends TaskDescriptor {
        private ResolveConflictInSvn() {
            super("Accepting working state", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            try {
                new SvnTreeConflictResolver(MergeFromTheirsResolver.this.myVcs, MergeFromTheirsResolver.this.myOldFilePath, null).resolveSelectMineFull();
            }
            catch (VcsException e1) {
                context.handleException((Exception)((Object)e1), false);
            }
        }
    }

    private class FinalNotification
    extends TaskDescriptor {
        private FinalNotification() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)MergeFromTheirsResolver.this.myVcs.getProject(), (String)("Theirs changes merged for " + MergeFromTheirsResolver.this.myOldPresentation), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
            if (!MergeFromTheirsResolver.this.myWarnings.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)MergeFromTheirsResolver.this.myVcs.getProject()).showErrors(MergeFromTheirsResolver.this.myWarnings, "Resolve tree conflict");
            }
        }
    }
}

