/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;

public class RenameFix
extends GroovyFix {
    private final String targetName;

    public RenameFix() {
        this.targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.targetName = targetName;
    }

    @NotNull
    public String getName() {
        if (this.targetName == null) {
            if ("Rename" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/RenameFix", "getName"));
            }
            return "Rename";
        }
        String string = "Rename to " + this.targetName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/RenameFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/naming/RenameFix", "doFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/naming/RenameFix", "doFix"));
        }
        PsiElement nameIdentifier = descriptor2.getPsiElement();
        PsiElement elementToRename = nameIdentifier.getParent();
        if (this.targetName == null) {
            RefactoringActionHandlerFactory factory = RefactoringActionHandlerFactory.getInstance();
            RefactoringActionHandler renameHandler = factory.createRenameHandler();
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext();
            renameHandler.invoke(project, new PsiElement[]{elementToRename}, dataContext);
        } else {
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.targetName);
            renameRefactoring.run();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

