/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrUnnecessarySemicolonInspection
extends GroovySuppressableInspectionTool
implements CleanupLocalInspectionTool {
    private static final TokenSet NLS_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mNLS});
    private static final TokenSet FORWARD_SET = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSets.WHITE_SPACES_OR_COMMENTS, TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSEMI})}), (TokenSet)NLS_SET);
    private static final TokenSet BACKWARD_SET = TokenSet.andNot((TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS, (TokenSet)NLS_SET);
    private static final LocalQuickFix FIX = new LocalQuickFix(){

        @Nls
        @NotNull
        public String getName() {
            if ("Remove semicolon" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection$1", "getName"));
            }
            return "Remove semicolon";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection$1", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection$1", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection$1", "applyFix"));
            }
            PsiElement element = descriptor2.getPsiElement();
            if (element != null && element.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
                CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> ((PsiElement)element).delete());
            }
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element.getNode().getElementType() != GroovyTokenTypes.mSEMI) {
                    return;
                }
                if (GrUnnecessarySemicolonInspection.isSemicolonNecessary(element)) {
                    return;
                }
                holder.registerProblem(element, "Semicolon is unnecessary", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{FIX});
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static boolean isSemicolonNecessary(@NotNull PsiElement semicolon) {
        if (semicolon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semicolon", "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection", "isSemicolonNecessary"));
        }
        if (semicolon.getParent() instanceof GrTraditionalForClause) {
            return true;
        }
        PsiElement prevSibling = PsiUtil.skipSet(semicolon, false, BACKWARD_SET);
        PsiElement nextSibling = PsiUtil.skipSet(semicolon, true, FORWARD_SET);
        return prevSibling instanceof GrStatement && (nextSibling instanceof GrStatement || nextSibling != null && nextSibling.getNextSibling() instanceof GrClosableBlock);
    }
}

