/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContextImpl;
import org.jetbrains.plugins.groovy.transformations.TransformationResult;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0010\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"ourTransformationContext", "Ljava/lang/ThreadLocal;", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "", "isUnderAnyTransformation", "isUnderTransformation", "clazz", "Lcom/intellij/psi/PsiClass;", "transformDefinition", "Lorg/jetbrains/plugins/groovy/transformations/TransformationResult;", "definition", "groovy-psi"})
public final class TransformationUtilKt {
    private static final ThreadLocal<Map<GrTypeDefinition, Boolean>> ourTransformationContext = new ThreadLocal<Map<GrTypeDefinition, Boolean>>(){

        @NotNull
        protected Map<GrTypeDefinition, Boolean> initialValue() {
            Map map = ContainerUtil.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"ContainerUtil.newHashMap()");
            return map;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final TransformationResult transformDefinition(@NotNull GrTypeDefinition definition) {
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        ourTransformationContext.get().put(definition, true);
        try {
            TransformationContextImpl transformationContext = new TransformationContextImpl(definition);
            AstTransformationSupport[] astTransformationSupportArray = (AstTransformationSupport[])AstTransformationSupport.EP_NAME.getExtensions();
            for (int i = 0; i < astTransformationSupportArray.length; ++i) {
                AstTransformationSupport transformation = astTransformationSupportArray[i];
                ProgressManager.checkCanceled();
                transformation.applyTransformation(transformationContext);
            }
            TransformationResult transformationResult = transformationContext.getTransformationResult();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformationResult, (String)"transformationContext.transformationResult");
            TransformationResult transformationResult2 = transformationResult;
            return transformationResult2;
        }
        finally {
            ourTransformationContext.get().remove(definition);
        }
    }

    public static final boolean isUnderTransformation(@Nullable PsiClass clazz) {
        Boolean result;
        return clazz instanceof GrTypeDefinition ? (result = ourTransformationContext.get().get(clazz)) != null && result.booleanValue() : false;
    }

    public static final boolean isUnderAnyTransformation() {
        Map<GrTypeDefinition, Boolean> map = ourTransformationContext.get();
        return !map.isEmpty();
    }
}

