/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkFactoryImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkEditorContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateRemoteSdkDialog<T extends RemoteSdkAdditionalData>
extends DialogWrapper
implements RemoteSdkEditorContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkDialog");
    @Nullable
    protected final Project myProject;
    private CreateRemoteSdkForm<T> myInterpreterForm;
    private Sdk mySdk;
    private final RemoteSdkFactoryImpl<T> mySdkFactory;
    private final Collection<Sdk> myExistingSdks;

    public CreateRemoteSdkDialog(@Nullable Project project, Collection<Sdk> existingSdks) {
        super(project, true);
        this.myProject = project == null || !project.isDefault() ? project : null;
        this.myExistingSdks = existingSdks;
        this.mySdkFactory = this.createRemoteSdkFactory();
    }

    public CreateRemoteSdkDialog(Component parentComponent, Collection<Sdk> existingSdks) {
        super(parentComponent, true);
        this.myProject = null;
        this.myExistingSdks = existingSdks;
        this.mySdkFactory = this.createRemoteSdkFactory();
    }

    @NotNull
    protected abstract RemoteSdkFactoryImpl<T> createRemoteSdkFactory();

    protected RemoteSdkFactoryImpl<T> getSdkFactory() {
        return this.mySdkFactory;
    }

    @NotNull
    private CreateRemoteSdkForm<T> getInterpreterForm() {
        if (this.myInterpreterForm == null) {
            this.myInterpreterForm = this.createRemoteSdkForm();
        }
        CreateRemoteSdkForm<T> createRemoteSdkForm = this.myInterpreterForm;
        if (createRemoteSdkForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog", "getInterpreterForm"));
        }
        return createRemoteSdkForm;
    }

    @NotNull
    protected abstract CreateRemoteSdkForm<T> createRemoteSdkForm();

    public final void onValidationPress() {
        this.initValidation();
    }

    @Override
    public void updateSize() {
        this.pack();
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add(this.getInterpreterForm(), "Center");
        return result;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getInterpreterForm().getPreferredFocusedComponent();
    }

    @NotNull
    public final Sdk getSdk() {
        assert (this.mySdk != null);
        assert (this.mySdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData);
        if (((RemoteSdkAdditionalData)this.mySdk.getSdkAdditionalData()).isValid()) {
            this.initSdk(this.mySdk);
        }
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog", "getSdk"));
        }
        return sdk;
    }

    protected abstract void initSdk(@NotNull Sdk var1);

    public Sdk getEditedSdk(T oldData) {
        assert (this.mySdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData);
        RemoteSdkAdditionalData newData = (RemoteSdkAdditionalData)this.mySdk.getSdkAdditionalData();
        if (this.isModified(oldData, newData) || !oldData.isValid()) {
            return this.getSdk();
        }
        return this.mySdk;
    }

    protected abstract boolean isModified(@NotNull T var1, @NotNull T var2);

    @NotNull
    private Sdk createSdk(T remoteSdkData) throws RemoteSdkException {
        Sdk sdk = this.createRemoteSdk(remoteSdkData);
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog", "createSdk"));
        }
        return sdk;
    }

    private Sdk createRemoteSdk(T data) throws RemoteSdkException {
        return this.mySdkFactory.createRemoteSdk(this.myProject, data, this.getInterpreterForm().getSdkName(), this.myExistingSdks);
    }

    @NotNull
    private Sdk saveUnfinished() {
        T data = this.getInterpreterForm().createSdkData();
        Sdk sdk = this.mySdkFactory.createUnfinished(data, this.myExistingSdks);
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog", "saveUnfinished"));
        }
        return sdk;
    }

    protected void doOKAction() {
        String validation = this.validateInterpreterForm();
        if (validation != null) {
            this.onCreateFail(validation);
            return;
        }
        T remoteSdkData = this.getInterpreterForm().createSdkData();
        if (!this.validateRemoteSdkData(remoteSdkData)) {
            return;
        }
        try {
            this.mySdk = this.createSdk(remoteSdkData);
        }
        catch (RemoteSdkException e) {
            this.mySdk = null;
            if (!ExceptionUtil.causedBy((Throwable)e, InterruptedException.class)) {
                LOG.debug("Failed to create remote Python SDK", (Throwable)e);
                this.onCreateFail(e.getMessage());
            }
            return;
        }
        super.doOKAction();
    }

    protected boolean validateRemoteSdkData(T data) {
        for (Sdk sdk : this.myExistingSdks) {
            if (!StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)this.mySdkFactory.generateSdkHomePath(data))) continue;
            this.validationFailed("There is already the same interpreter:\n" + sdk.getName(), false);
            return false;
        }
        return true;
    }

    private void onCreateFail(String validation) {
        boolean saveAnyway = this.validationFailed(validation, this.mySdkFactory.canSaveUnfinished());
        if (saveAnyway) {
            this.mySdk = this.saveUnfinished();
            super.doOKAction();
        }
    }

    public void setSdkName(String name) {
        if (name != null && !name.startsWith(this.mySdkFactory.getDefaultUnfinishedName())) {
            this.getInterpreterForm().setSdkName(name);
        }
    }

    private boolean validationFailed(String validation, boolean askSaveUnfinished) {
        if (StringUtil.isEmpty((String)validation)) {
            validation = "Communication error";
        }
        if (askSaveUnfinished) {
            if (Messages.showOkCancelDialog((String)validation, (String)("Can't create " + this.mySdkFactory.sdkName() + " SDK"), (String)"Save anyway", (String)"Continue editing", (Icon)Messages.getWarningIcon()) == 0) {
                return true;
            }
        } else {
            Messages.showErrorDialog((String)validation, (String)("Can't create " + this.mySdkFactory.sdkName() + " SDK"));
        }
        return false;
    }

    @Nullable
    private String validateInterpreterForm() {
        if (CaseCollector.useRemoteCredentials(this.getInterpreterForm().createSdkDataInner())) {
            return CreateRemoteSdkDialog.validateUsingRemoteSdkCredentials(this.myProject, this.getInterpreterForm());
        }
        this.updateHelpersPath();
        return null;
    }

    public static String validateUsingRemoteSdkCredentials(@Nullable Project project, final @NotNull CreateRemoteSdkForm interpreterForm) {
        if (interpreterForm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterForm", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog", "validateUsingRemoteSdkCredentials"));
        }
        try {
            RemoteSdkCredentials data = interpreterForm.computeSdkCredentials();
            if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, data, "Connecting to remote host", new RemoteSdkUtil.RemoteSdkUpdatedCallback(){

                @Override
                public void updated(RemoteSdkCredentials data) {
                    interpreterForm.updateModifiedValues(data);
                }
            })) {
                return "Can't connect to remote host";
            }
        }
        catch (FileSystemException e) {
            LOG.info((Throwable)e);
            return e.getMessage();
        }
        catch (RemoteCancelledException e) {
            return "Connection cancelled";
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    @Nullable
    private String updateHelpersPath() {
        this.getInterpreterForm().updateHelpersPath(this.getDefaultHelpersPath());
        return null;
    }

    @NotNull
    protected String getDefaultHelpersPath() {
        if ("/opt/.pycharm_helpers" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog", "getDefaultHelpersPath"));
        }
        return "/opt/.pycharm_helpers";
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getInterpreterForm().validateRemoteInterpreter();
    }

    public void init(@NotNull T data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog", "init"));
        }
        this.getInterpreterForm().init(data);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }
}

