/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jetbrains.plugins.remotesdk.RSyncUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkEditorContainer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.ErrorMessageAndField;
import com.jetbrains.plugins.webDeployment.ui.WebServerConfigForm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class RemoteCredentialsEditor
extends SettingsEditor<MutableRemoteCredentials> {
    private static final String AUTH_PASSWORD = WDBundle.message((String)"auth.password", (Object[])new Object[0]);
    private static final String AUTH_KEYPAIR = WDBundle.message((String)"auth.keypair", (Object[])new Object[0]);
    private JPanel myMainPanel;
    private JBLabel myPasswordLabel;
    private JBCheckBox mySavePasswordCheckBox;
    private JTextField myUsernameField;
    private TextFieldWithBrowseButton myPrivateKeyFileField;
    private JLabel myPassphraseLabel;
    private JPasswordField myPassphraseField;
    private JCheckBox mySavePassphraseCheckbox;
    private JPasswordField myPasswordField;
    private JLabel myPrivateKeyFileLabel;
    private JComboBox myAuthTypeCombo;
    private JTextField myHostField;
    private JTextField myPortField;
    private ActionLink myRSyncLink;
    private JLabel myExternalToolsSuggestionLabel;
    private boolean myPasswordIsSpecified;
    private boolean myPassphraseIsSpecified;
    private Map<String, JComponent> myField2Component;
    private RemoteSdkEditorContainer myContainer;
    private MessageBusConnection myMessageBusConnection;

    public RemoteCredentialsEditor() {
        this.$$$setupUI$$$();
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                RemoteCredentialsEditor.this.myPasswordIsSpecified = RemoteCredentialsEditor.this.myPasswordField.getPassword().length > 0;
                RemoteCredentialsEditor.this.checkExternalTools();
            }
        });
        this.myPrivateKeyFileLabel.setLabelFor(this.myPrivateKeyFileField.getTextField());
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                RemoteCredentialsEditor.this.updateNeedsPassphrase();
            }
        });
        this.myPrivateKeyFileField.addActionListener((ActionListener)WebServerConfigForm.createBrowseListenerForPrivateKey((TextFieldWithBrowseButton)this.myPrivateKeyFileField));
        this.myPassphraseField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (RemoteCredentialsEditor.this.myPassphraseField.getPassword().length == 0) {
                    RemoteCredentialsEditor.this.myPassphraseIsSpecified = false;
                }
            }
        });
        this.myAuthTypeCombo.setModel(new CollectionComboBoxModel(Arrays.asList(AUTH_PASSWORD, AUTH_KEYPAIR), (Object)AUTH_PASSWORD));
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteCredentialsEditor.this.updateOnAuthTypeChange();
                JTextField focus = RemoteCredentialsEditor.this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD ? RemoteCredentialsEditor.this.myPasswordField : RemoteCredentialsEditor.this.myPrivateKeyFileField.getTextField();
                IdeFocusManager.findInstanceByComponent((Component)focus).requestFocus((Component)focus, false);
            }
        });
        this.updateOnAuthTypeChange();
        this.myField2Component = new HashMap();
        this.myField2Component.put("HOST", this.myHostField);
        this.myField2Component.put("PORT", this.myPortField);
        this.myField2Component.put("USERNAME", this.myUsernameField);
        this.myField2Component.put("PRIVATE_KEY_FILE", (JComponent)this.myPrivateKeyFileField);
        this.myExternalToolsSuggestionLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.checkExternalTools();
        AppListener myAppListener = new AppListener();
        this.myMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        this.myMessageBusConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)myAppListener);
        Disposer.register((Disposable)this, (Disposable)this.myMessageBusConnection);
    }

    public void createUIComponents() {
        this.myRSyncLink = new ActionLink("RSync", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                BrowserUtil.open((String)"https://confluence.jetbrains.com/display/RUBYDEV/Faster+Remote+Gem+Downloading+with+Rsync");
            }
        });
    }

    public void setContainer(RemoteSdkEditorContainer container) {
        this.myContainer = container;
        Disposable disposable = container.getDisposable();
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    private void updateNeedsPassphrase() {
        if (StringUtil.isNotEmpty((String)this.myPrivateKeyFileField.getText())) {
            boolean needsPassphrase = true;
            File file = new File(this.myPrivateKeyFileField.getText());
            if (file.isFile() && file.canRead()) {
                try {
                    KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                    needsPassphrase = keyPair == null || keyPair.isEncrypted();
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
            if (needsPassphrase) {
                if (!this.myPassphraseField.isEnabled()) {
                    this.myPassphraseField.setText(null);
                    this.myPassphraseField.setEnabled(true);
                    this.mySavePassphraseCheckbox.setEnabled(true);
                }
            } else {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(false);
                this.mySavePassphraseCheckbox.setSelected(false);
                this.mySavePassphraseCheckbox.setEnabled(false);
            }
        } else {
            this.myPasswordField.setEnabled(true);
            this.mySavePasswordCheckBox.setEnabled(true);
        }
    }

    private void updateOnAuthTypeChange() {
        if (this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD) {
            this.myPasswordLabel.setVisible(true);
            this.myPasswordField.setVisible(true);
            this.mySavePasswordCheckBox.setVisible(true);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText("");
            int width = this.myPrivateKeyFileLabel.getPreferredSize().width;
            this.myPasswordLabel.setMinimumSize(new Dimension(width, this.myPasswordLabel.getMinimumSize().height));
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        } else {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(true);
            this.myPrivateKeyFileField.setVisible(true);
            this.myPassphraseLabel.setVisible(true);
            this.myPassphraseField.setVisible(true);
            this.mySavePassphraseCheckbox.setVisible(true);
            this.myPassphraseField.setEnabled(true);
            this.mySavePassphraseCheckbox.setEnabled(true);
        }
        if (this.myContainer != null) {
            this.myContainer.updateSize();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHostField;
    }

    private void setAuthTypeCombo(boolean useKeyPair) {
        if (useKeyPair) {
            this.myAuthTypeCombo.setSelectedItem(AUTH_KEYPAIR);
        } else {
            this.myAuthTypeCombo.setSelectedItem(AUTH_PASSWORD);
        }
        this.updateOnAuthTypeChange();
    }

    public boolean isPassphraseSpecified() {
        return this.myPassphraseIsSpecified;
    }

    public boolean isPasswordSpecified() {
        return this.myPasswordIsSpecified;
    }

    protected void resetEditorFrom(MutableRemoteCredentials credentials) {
        this.resetEditor((RemoteCredentials)credentials);
    }

    public void resetEditor(RemoteCredentials credentials) {
        this.myHostField.setText(credentials.getHost());
        this.myPortField.setText(credentials.getLiteralPort());
        if (!credentials.isAnonymous()) {
            this.myUsernameField.setText(credentials.getUserName());
        }
        this.setAuthTypeCombo(credentials.isUseKeyPair());
        if (credentials.isUseKeyPair()) {
            this.myPrivateKeyFileField.setText(credentials.getPrivateKeyFile());
            this.myPassphraseField.setText(credentials.getPassphrase());
            this.mySavePassphraseCheckbox.setSelected(credentials.isStorePassphrase());
        } else {
            this.myPasswordField.setText(credentials.getPassword());
            this.mySavePasswordCheckBox.setSelected(credentials.isStorePassword());
        }
    }

    protected void applyEditorTo(MutableRemoteCredentials credentials) throws ConfigurationException {
        credentials.setHost(this.myHostField.getText());
        credentials.setLiteralPort(this.myPortField.getText());
        String username = this.myUsernameField.getText();
        if (username != null) {
            username = username.trim();
        }
        credentials.setUserName(username);
        credentials.setUseKeyPair(this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR);
        if (credentials.isUseKeyPair()) {
            credentials.setPassword(null);
            credentials.setStorePassword(false);
            credentials.setPassphrase(new String(this.myPassphraseField.getPassword()));
            credentials.setStorePassphrase(this.mySavePassphraseCheckbox.isSelected());
            credentials.setPrivateKeyFile(this.myPrivateKeyFileField.getText());
        } else {
            credentials.setPassword(new String(this.myPasswordField.getPassword()));
            credentials.setStorePassword(this.mySavePasswordCheckBox.isSelected());
            credentials.setPassphrase(null);
            credentials.setStorePassphrase(false);
            credentials.setPrivateKeyFile(null);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteCredentialsEditor", "createEditor"));
        }
        return jPanel;
    }

    public ValidationInfo createValidationInfo(ErrorMessageAndField error) {
        String field = (String)error.getSecond();
        JComponent component = field == null ? null : this.myField2Component.get(field);
        return new ValidationInfo((String)error.getFirst(), component);
    }

    public void setEnabled(boolean enabled) {
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)enabled, (boolean)true);
    }

    private void checkExternalTools() {
        List<String> externalToolSuggestion = RSyncUtil.externalToolSuggestion();
        String utilityWord = StringUtil.pluralize((String)"utility", (int)externalToolSuggestion.size());
        this.myExternalToolsSuggestionLabel.setText(String.format("To reduce download time install %s:", utilityWord));
        this.myExternalToolsSuggestionLabel.setVisible(externalToolSuggestion.size() > 0);
        this.myRSyncLink.setVisible(externalToolSuggestion.contains("rsync"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JPasswordField jPasswordField2;
        JBLabel jBLabel;
        JComboBox jComboBox;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Host:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 3, 0, 3, 7, 3, null, null, null));
        this.myHostField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Port:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 2, 1, 1, 8, 0, 2, 0, null, new Dimension(50, 22), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("User name:");
        jLabel5.setDisplayedMnemonic('U');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Auth type:");
        jLabel6.setDisplayedMnemonic('Y');
        jLabel6.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAuthTypeCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myPasswordLabel = jBLabel = new JBLabel();
        jBLabel.setText("Password:");
        jBLabel.setDisplayedMnemonic('A');
        jBLabel.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPrivateKeyFileLabel = jLabel3 = new JLabel();
        jLabel3.setText("Private key file:");
        jLabel3.setDisplayedMnemonic('K');
        jLabel3.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myPassphraseLabel = jLabel2 = new JLabel();
        jLabel2.setText("Passphrase:");
        jLabel2.setDisplayedMnemonic('A');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassphraseField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(5, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myUsernameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        this.mySavePasswordCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Save password");
        jBCheckBox.setMnemonic('E');
        jBCheckBox.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySavePassphraseCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Save passphrase");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(6, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myExternalToolsSuggestionLabel = jLabel = new JLabel();
        jLabel.setText("To reduce download time install utilities:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.myRSyncLink;
        actionLink.setText("RSync");
        jPanel3.add((Component)actionLink, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel2.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
        jLabel6.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jPasswordField2);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class AppListener
    extends ApplicationActivationListener.Adapter {
        private AppListener() {
        }

        public void applicationActivated(IdeFrame ideFrame) {
            RemoteCredentialsEditor.this.checkExternalTools();
        }
    }
}

