/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.lobobrowser.gui.AbstractBrowserWindow;
import org.lobobrowser.gui.AddressBarPanel;
import org.lobobrowser.gui.FillerComponent;
import org.lobobrowser.gui.FramePanel;
import org.lobobrowser.gui.NavigatorWindowImpl;
import org.lobobrowser.gui.SharedToolBarPanel;
import org.lobobrowser.gui.StatusBarPanel;
import org.lobobrowser.gui.WindowCallback;
import org.lobobrowser.main.ExtensionManager;
import org.lobobrowser.ua.NavigatorFrame;

public class DefaultBrowserWindow
extends AbstractBrowserWindow {
    private static final long serialVersionUID = 1L;
    private final FramePanel framePanel;
    private final NavigatorWindowImpl windowContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultBrowserWindow(boolean hasMenuBar, boolean hasAddressBar, boolean hasToolBar, boolean hasStatusBar, NavigatorWindowImpl windowContext) throws HeadlessException {
        Object object;
        Object abp;
        this.windowContext = windowContext;
        this.framePanel = windowContext.getFramePanel();
        ExtensionManager.getInstance().initExtensionsWindow(windowContext);
        Object componentLock = windowContext.getComponentLock();
        if (hasMenuBar) {
            JMenuBar menuBar = new JMenuBar();
            this.setJMenuBar(menuBar);
            Object object2 = componentLock;
            synchronized (object2) {
                for (JMenu jMenu : windowContext.getMenus()) {
                    menuBar.add(jMenu);
                }
            }
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        if (hasAddressBar) {
            abp = new AddressBarPanel();
            contentPane.add((Component)abp);
            object = componentLock;
            synchronized (object) {
                for (Component c : windowContext.getAddressBarComponents()) {
                    ((Container)abp).add(c);
                }
            }
        }
        if (hasToolBar) {
            abp = componentLock;
            synchronized (abp) {
                for (Component component : windowContext.getToolBars()) {
                    contentPane.add(component);
                }
            }
            SharedToolBarPanel stbp = new SharedToolBarPanel();
            contentPane.add(stbp);
            object = componentLock;
            synchronized (object) {
                for (Component c : windowContext.getSharedToolbarComponents()) {
                    stbp.add(c);
                }
            }
        }
        contentPane.add(new FillerComponent(this.framePanel, false));
        if (hasStatusBar) {
            StatusBarPanel statusBar = new StatusBarPanel();
            contentPane.add(statusBar);
            object = componentLock;
            synchronized (object) {
                for (Component c : windowContext.getStatusBarComponents()) {
                    statusBar.add(c);
                }
            }
        }
    }

    public NavigatorFrame getTopFrame() {
        return this.framePanel;
    }

    @Override
    public FramePanel getTopFramePanel() {
        return this.framePanel;
    }

    @Override
    public WindowCallback getWindowCallback() {
        return this.windowContext;
    }

    @Override
    public void update(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.update(g);
    }
}

