/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.lobobrowser.gui.DefaultWindowFactory;
import org.lobobrowser.gui.OpenProgressBar;
import org.lobobrowser.request.ClientletRequestHandler;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.ua.NavigatorProgressEvent;

public class ProgressWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final OpenProgressBar statusProgressBar;
    private final JLabel statusLabel;

    public ProgressWindow() throws HeadlessException {
        super(UserAgentImpl.getInstance().getName());
        this.setDefaultCloseOperation(2);
        ImageIcon windowIcon = DefaultWindowFactory.getInstance().getDefaultImageIcon();
        if (windowIcon != null) {
            this.setIconImage(windowIcon.getImage());
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel topPanel = new JPanel();
        contentPane.add(topPanel);
        contentPane.add(Box.createRigidArea(new Dimension(1, 18)));
        BevelBorder bevelBorder = new BevelBorder(1);
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        CompoundBorder border = new CompoundBorder(bevelBorder, emptyBorder);
        topPanel.setBorder(border);
        topPanel.setLayout(new BorderLayout());
        this.statusProgressBar = new OpenProgressBar();
        this.statusProgressBar.setStringPainted(true);
        this.statusLabel = new JLabel();
        topPanel.add((Component)this.statusLabel, "North");
        topPanel.add((Component)this.statusProgressBar, "Center");
    }

    public void updateProgress(NavigatorProgressEvent event) {
        this.statusLabel.setText(ClientletRequestHandler.getProgressMessage(event.getProgressType(), event.getUrl()));
        int value = event.getCurrentValue();
        int max = event.getMaxValue();
        if (max == -1) {
            this.statusProgressBar.setIndeterminate(true);
            this.statusProgressBar.setValue(value);
            this.statusProgressBar.setString(ProgressWindow.getSizeText(value));
            this.statusProgressBar.repaint();
        } else {
            this.statusProgressBar.setIndeterminate(false);
            this.statusProgressBar.setValue(value);
            this.statusProgressBar.setMaximum(max);
            if (value == 0 || max == 0) {
                this.statusProgressBar.setString("");
            } else {
                int percent = value * 100 / max;
                this.statusProgressBar.setString(String.valueOf(percent) + "%");
            }
            this.statusProgressBar.repaint();
        }
    }

    private static double round1(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    private static String getSizeText(int numBytes) {
        if (numBytes < 1024) {
            return "";
        }
        double numK = (double)numBytes / 1024.0;
        if (numK < 1024.0) {
            return ProgressWindow.round1(numK) + " Kb";
        }
        double numM = numK / 1024.0;
        if (numM < 1024.0) {
            return ProgressWindow.round1(numM) + " Mb";
        }
        double numG = numM / 1024.0;
        return ProgressWindow.round1(numG) + " Gb";
    }
}

