/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.gui.WrapperLayout;

public class InputRadioControl
extends BaseInputControl {
    private static final long serialVersionUID = 1L;
    private final JRadioButton widget;
    private ButtonGroup buttonGroup;

    public InputRadioControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JRadioButton radio = new JRadioButton();
        radio.setOpaque(false);
        if (modelNode.getTitle() != null) {
            radio.setToolTipText(modelNode.getTitle());
        }
        radio.setVisible(modelNode.getHidden());
        radio.applyComponentOrientation(this.direction(modelNode.getDir()));
        radio.setEnabled(!modelNode.getDisabled());
        radio.setSelected(modelNode.getChecked());
        this.widget = radio;
        HTMLElementImpl controlElement = this.controlElement;
        String name = controlElement.getAttribute("name");
        ButtonGroup prevGroup = this.buttonGroup;
        if (prevGroup != null) {
            prevGroup.remove(radio);
        }
        if (name != null) {
            String key = "cobra.radio.group." + name;
            ButtonGroup group = (ButtonGroup)controlElement.getDocumentItem(key);
            if (group == null) {
                group = new ButtonGroup();
                controlElement.setDocumentItem(key, group);
            }
            group.add(radio);
            this.buttonGroup = group;
        } else {
            this.buttonGroup = null;
        }
        radio.setSelected(controlElement.getAttributeAsBoolean("checked"));
        this.add(radio);
        this.widget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HtmlController.getInstance().onPressed(InputRadioControl.this.controlElement, null, 0, 0);
            }
        });
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
    }

    @Override
    public void click() {
        this.widget.doClick();
    }

    @Override
    public boolean getChecked() {
        return this.widget.isSelected();
    }

    @Override
    public void setChecked(boolean checked) {
        this.widget.setSelected(checked);
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    @Override
    public void resetInput() {
        this.widget.setSelected(this.controlElement.getAttributeAsBoolean("checked"));
    }

    @Override
    public String getValue() {
        return this.controlElement.getAttribute("value");
    }

    private ComponentOrientation direction(String dir) {
        if ("ltr".equalsIgnoreCase(dir)) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        if ("rtl".equalsIgnoreCase(dir)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.UNKNOWN;
    }
}

