/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domfilter;

import org.lobobrowser.html.domimpl.DOMAttrImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.w3c.HTMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementAttributeFilter {
    private final String attribute;
    private final NodeList nodeList;

    public ElementAttributeFilter(NodeList nodeList, String attribute) {
        this.attribute = attribute;
        this.nodeList = nodeList;
    }

    public ElementAttributeFilter(String attribute) {
        this.attribute = attribute;
        this.nodeList = null;
    }

    public String getAttribute() {
        String result = "";
        Node node = this.nodeList.item(0);
        NamedNodeMap attribs = node.getAttributes();
        for (int s = 0; s < attribs.getLength(); ++s) {
            Attr attr = (Attr)attribs.item(s);
            if (!this.attribute.equalsIgnoreCase(attr.getNodeName())) continue;
            result = attr.getNodeValue();
        }
        return result;
    }

    public void setAttribute(HTMLDocumentImpl doc, String val) {
        boolean result = false;
        HTMLElement el = doc.getBody();
        if (el != null) {
            NamedNodeMap attributes = el.getAttributes();
            for (int s = 0; s < attributes.getLength(); ++s) {
                Attr attr = (Attr)attributes.item(s);
                if (!this.attribute.equals(attr.getNodeName())) continue;
                attr.setNodeValue(val);
                el.setAttributeNode(attr);
                result = true;
            }
            if (!result) {
                DOMAttrImpl attr = new DOMAttrImpl(this.attribute, val, true, el, true);
                el.setAttributeNode(attr);
            }
            doc.setBody(el);
        }
    }

    public void removeAttribute(HTMLDocumentImpl doc, String val) {
        HTMLElement el = doc.getBody();
        el.removeAttribute(this.attribute);
        doc.setBody(el);
    }
}

