/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.action;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import org.lobobrowser.primary.ext.ActionPool;
import org.lobobrowser.primary.ext.AddBookmarkDialog;
import org.lobobrowser.primary.ext.BookmarkInfo;
import org.lobobrowser.primary.ext.BookmarksHistory;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigatorWindow;

public class AddBookmarkAction
extends ActionPool {
    private static final long serialVersionUID = 1L;
    private NavigatorWindow window;

    public AddBookmarkAction(ComponentSource componentSource, NavigatorWindow window) {
        super(componentSource, window);
        this.window = window;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.addBookmark();
    }

    public void addBookmark() {
        NavigationEntry entry = this.window.getCurrentNavigationEntry();
        if (entry != null) {
            Window awtWindow;
            URL url = entry.getUrl();
            BookmarksHistory history = BookmarksHistory.getInstance();
            BookmarkInfo existingInfo = (BookmarkInfo)history.getExistingInfo(url.toExternalForm());
            if (existingInfo == null) {
                existingInfo = new BookmarkInfo();
                existingInfo.setUrl(url);
                existingInfo.setTitle(entry.getTitle());
                existingInfo.setDescription(entry.getDescription());
            }
            if (!((awtWindow = this.window.getAwtWindow()) instanceof Frame)) {
                throw new IllegalStateException("Bookmaks dialog only supported when an AWT Frame is available.");
            }
            AddBookmarkDialog dialog = new AddBookmarkDialog((Frame)awtWindow, true, existingInfo);
            dialog.setTitle("Add/Edit Bookmark");
            dialog.setLocationByPlatform(true);
            dialog.setResizable(false);
            dialog.pack();
            dialog.setVisible(true);
            BookmarkInfo info = dialog.getBookmarkInfo();
            if (info != null) {
                history.addAsRecent(info.getUrl(), info);
                history.save();
            }
        }
    }
}

