/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletAccess;
import org.lobobrowser.clientlet.ClientletContext;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ComponentContent;
import org.lobobrowser.context.ClientletContextImpl;
import org.lobobrowser.context.ClientletFactory;
import org.lobobrowser.gui.FramePanel;
import org.lobobrowser.gui.WindowCallback;
import org.lobobrowser.request.AbstractRequestHandler;
import org.lobobrowser.security.LocalSecurityManager;
import org.lobobrowser.ua.NavigatorProgressEvent;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.Urls;

public class ClientletRequestHandler
extends AbstractRequestHandler {
    private final WindowCallback windowCallback;
    private final FramePanel frame;
    public final EventDispatch evtProgress = new EventDispatch();
    private volatile Properties windowProperties = null;

    public ClientletRequestHandler(ClientletRequest request, WindowCallback clientletUI, FramePanel frame) {
        super(request, frame.getComponent());
        this.windowCallback = clientletUI;
        this.frame = frame;
    }

    @Override
    public boolean handleException(ClientletResponse response, Throwable exception) throws ClientletException {
        if (this.windowCallback != null) {
            this.windowCallback.handleError(this.frame, response, exception);
            return true;
        }
        return false;
    }

    public Properties getContextWindowProperties() {
        return this.windowProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(final ClientletResponse response) throws ClientletException, IOException {
        Clientlet clientlet;
        if (this.windowCallback != null) {
            this.windowCallback.handleDocumentAccess(this.frame, response);
        }
        if ((clientlet = ClientletFactory.getInstance().getClientlet(this.getRequest(), response)) == null) {
            throw new ClientletException("Unable to find clientlet for response: " + response + ".");
        }
        this.frame.setProgressEvent(null);
        ClientletContextImpl ctx = new ClientletContextImpl(this.frame, this.request, response){

            @Override
            public void setResultingContent(ComponentContent content) {
                super.setResultingContent(content);
                ClientletRequestHandler.this.windowProperties = this.getOverriddingWindowProperties();
                ClientletRequestHandler.this.frame.replaceContent(response, content);
                ClientletRequestHandler.this.evtProgress.fireEvent(null);
            }
        };
        ClientletContext prevCtx = ClientletAccess.getCurrentClientletContext();
        ClientletAccess.setCurrentClientletContext(ctx);
        ThreadGroup prevThreadGroup = LocalSecurityManager.getCurrentThreadGroup();
        ThreadGroup newThreadGroup = null;
        LocalSecurityManager.setCurrentThreadGroup(newThreadGroup);
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(clientlet.getClass().getClassLoader());
        try {
            clientlet.process(ctx);
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
            LocalSecurityManager.setCurrentThreadGroup(prevThreadGroup);
            ClientletAccess.setCurrentClientletContext(prevCtx);
        }
        this.frame.informResponseProcessed(response);
    }

    @Override
    public void handleProgress(ProgressType progressType, URL url, String method, int value, int max) {
        NavigatorProgressEvent event = new NavigatorProgressEvent(this, this.frame, progressType, url, method, value, max);
        this.evtProgress.fireEvent(event);
        this.frame.setProgressEvent(event);
    }

    public static String getProgressMessage(ProgressType progressType, URL url) {
        String urlText = url == null ? "[null]" : Urls.getNoRefForm(url);
        switch (progressType) {
            case CONNECTING: {
                String host = url.getHost();
                if (host == null || "".equals(host)) {
                    return "Opening " + urlText;
                }
                return "Contacting " + host;
            }
            case SENDING: {
                return "Sending data to " + urlText;
            }
            case WAITING_FOR_RESPONSE: {
                return "Waiting on " + urlText;
            }
            case CONTENT_LOADING: {
                return "Loading " + urlText;
            }
            case BUILDING: {
                return "Building " + urlText;
            }
            case DONE: {
                return "Processed " + urlText;
            }
        }
        return "[?]" + urlText;
    }
}

