/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.request.Cookie;
import org.lobobrowser.request.CookieStore;

public class CookieHandlerImpl
extends CookieHandler {
    private static final Logger logger = Logger.getLogger(CookieHandlerImpl.class.getName());
    private final CookieStore cookieStore = CookieStore.getInstance();

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        HashMap<String, List<String>> resultHeaders = new HashMap<String, List<String>>(2);
        Collection<Cookie> cookies = this.cookieStore.getCookies(uri.getHost(), uri.getPath());
        if (cookies != null) {
            StringBuffer cookieHeaderValue = null;
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                String cookieValue = cookie.getValue();
                String assignment = cookieName + "=" + cookieValue;
                if (cookieHeaderValue == null) {
                    cookieHeaderValue = new StringBuffer();
                } else {
                    cookieHeaderValue.append("; ");
                }
                cookieHeaderValue.append(assignment);
            }
            if (cookieHeaderValue != null) {
                resultHeaders.put("Cookie", Collections.singletonList(cookieHeaderValue.toString()));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.info("get(): ---- Cookie headers for uri=[" + uri + "].");
            this.printHeaders(resultHeaders);
        }
        return resultHeaders;
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.info("put(): ---- Response headers for uri=[" + uri + "].");
            this.printHeaders(responseHeaders);
        }
        CookieStore store = this.cookieStore;
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                if (key == null || value == null) continue;
                if ("Set-Cookie".equalsIgnoreCase(key)) {
                    store.saveCookie(uri.getHost(), value);
                    continue;
                }
                if (!"Set-Cookie2".equalsIgnoreCase(key)) continue;
                store.saveCookie(uri.getHost(), value);
            }
        }
    }

    private void printHeaders(Map<String, List<String>> headers) {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                writer.println("Header: " + entry.getKey() + "=" + value);
            }
        }
        writer.println();
        writer.flush();
        logger.info(swriter.toString());
    }
}

