/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.security;

import java.net.URL;
import java.security.BasicPermission;
import org.lobobrowser.security.LocalSecurityPolicy;

public class StoreHostPermission
extends BasicPermission {
    private static final long serialVersionUID = 1L;

    public StoreHostPermission(String name) {
        super(name);
    }

    public static StoreHostPermission forURL(URL url) {
        if (LocalSecurityPolicy.isLocal(url)) {
            return new StoreHostPermission("*");
        }
        String hostName = url.getHost();
        if (hostName != null && hostName.indexOf(42) != -1) {
            throw new SecurityException("Invalid host: " + hostName);
        }
        return StoreHostPermission.forHost(hostName);
    }

    public static StoreHostPermission forHost(String hostName) {
        String h = hostName == null || "".equals(hostName) ? "<<local>>" : hostName;
        return new StoreHostPermission(h);
    }
}

