/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.edges;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.diagram.edges.CdiDependencyType;
import com.intellij.cdi.diagram.edges.CdiDiagramEdge;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;

public class CdiInjectionPointEdge
extends CdiDiagramEdge {
    private InjectionPointDescriptor myInjectionPointDescriptor;

    public CdiInjectionPointEdge(DiagramNode<CdiBeanDescriptor> source, DiagramNode<CdiBeanDescriptor> target, InjectionPointDescriptor injectionPointDescriptor, boolean problemInjection) {
        super(source, target, CdiDependencyType.INJECTED, (DiagramRelationshipInfo)CdiInjectionPointEdge.getInfo(injectionPointDescriptor, problemInjection));
        this.myInjectionPointDescriptor = injectionPointDescriptor;
    }

    @NotNull
    private static DiagramRelationshipInfoAdapter getInfo(@NotNull InjectionPointDescriptor ip, boolean problemInjection) {
        if (ip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ip", "com/intellij/cdi/diagram/edges/CdiInjectionPointEdge", "getInfo"));
        }
        PsiAnnotation[] annotations = CdiCommonUtils.getQualifierAnnotations(ip.getOwner());
        String name = CdiInjectionPointEdge.getQualifierAnnotationsAsHtml(annotations);
        MyDiagramRelationshipInfoAdapter myDiagramRelationshipInfoAdapter = new MyDiagramRelationshipInfoAdapter(name, ip, problemInjection);
        if (myDiagramRelationshipInfoAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/diagram/edges/CdiInjectionPointEdge", "getInfo"));
        }
        return myDiagramRelationshipInfoAdapter;
    }

    private static DiagramLineType getDiagramLineType(InjectionPointDescriptor ip, boolean problemInjection) {
        if (problemInjection) {
            return DiagramLineType.DASHED;
        }
        return CdiInjectionPointEdge.isDelegate(ip) ? DiagramLineType.DOTTED : DiagramLineType.SOLID;
    }

    private static boolean isDelegate(InjectionPointDescriptor ip) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)ip.getOwner(), (String)"javax.decorator.Delegate", (boolean)false);
    }

    public Object getSourceAnchor() {
        return this.myInjectionPointDescriptor;
    }

    public Object getTargetAnchor() {
        return this.myInjectionPointDescriptor;
    }

    public InjectionPointDescriptor getInjectionPointDescriptor() {
        return this.myInjectionPointDescriptor;
    }

    private static class MyDiagramRelationshipInfoAdapter
    extends DiagramRelationshipInfoAdapter {
        private final InjectionPointDescriptor myInjectionPointDescriptor;

        public MyDiagramRelationshipInfoAdapter(String name, InjectionPointDescriptor ip, boolean problemInjection) {
            super(name, CdiInjectionPointEdge.getDiagramLineType(ip, problemInjection), name);
            this.myInjectionPointDescriptor = ip;
        }

        public Shape getStartArrow() {
            return STANDARD;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyDiagramRelationshipInfoAdapter adapter = (MyDiagramRelationshipInfoAdapter)((Object)o);
            return this.myInjectionPointDescriptor.equals(adapter.myInjectionPointDescriptor);
        }

        public int hashCode() {
            return this.myInjectionPointDescriptor != null ? this.myInjectionPointDescriptor.hashCode() : 0;
        }
    }
}

