/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.model.xml.AlternativeClass;
import com.intellij.cdi.model.xml.Alternatives;
import com.intellij.cdi.model.xml.Beans;
import com.intellij.cdi.model.xml.DecoratorClass;
import com.intellij.cdi.model.xml.Decorators;
import com.intellij.cdi.model.xml.InterceptorClass;
import com.intellij.cdi.model.xml.Interceptors;
import com.intellij.cdi.model.xml.StereotypeClass;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDomBeansInspection
extends BasicDomElementsInspection<Beans> {
    public CdiDomBeansInspection() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> element, DomElementAnnotationHolder holder) {
        Beans beans = (Beans)element.getRootElement();
        CdiDomBeansInspection.checkAlternatives(element, holder, beans);
        for (Decorators decorators : beans.getDecoratorses()) {
            for (DecoratorClass decoratorClass : decorators.getClasses()) {
                CdiDomBeansInspection.checkAnnotatedClass(decoratorClass, holder, "javax.decorator.Decorator");
            }
        }
        for (Interceptors interceptors : beans.getInterceptorses()) {
            for (InterceptorClass interceptorClass : interceptors.getClasses()) {
                CdiDomBeansInspection.checkAnnotatedClass(interceptorClass, holder, "javax.interceptor.Interceptor");
            }
        }
        super.checkFileElement(element, holder);
    }

    private static void checkAlternatives(DomFileElement<Beans> element, DomElementAnnotationHolder holder, Beans beans) {
        Module module = element.getModule();
        for (Alternatives alternatives : beans.getAlternativeses()) {
            CdiDomBeansInspection.checkAlternativeClasses(holder, module, alternatives);
            CdiDomBeansInspection.checkStereotypes(holder, module, alternatives);
        }
    }

    private static void checkAlternativeClasses(DomElementAnnotationHolder holder, Module module, Alternatives alternatives) {
        MultiMap duplicatedMap = new MultiMap();
        for (AlternativeClass alternativeClass : alternatives.getClasses()) {
            PsiClass aClass = (PsiClass)alternativeClass.getValue();
            if (aClass != null) {
                duplicatedMap.putValue((Object)aClass, (Object)alternativeClass);
                if (module != null && CdiInjectionUtils.isVetoedClass(module, aClass)) {
                    holder.createProblem((DomElement)alternativeClass, CdiInspectionBundle.message("alternative.bean.should.not.be.vetoed", new Object[0]), new LocalQuickFix[0]);
                }
            }
            CdiDomBeansInspection.checkAnnotatedClass(alternativeClass, holder, (Condition<PsiClass>)((Condition)aClass1 -> CdiCommonUtils.isAlternative((PsiMember)aClass1)), "javax.enterprise.inject.Alternative");
        }
        for (Map.Entry entry : duplicatedMap.entrySet()) {
            Collection duplicated = (Collection)entry.getValue();
            if (duplicated.size() <= 1) continue;
            for (AlternativeClass alternative : duplicated) {
                holder.createProblem((DomElement)alternative, CdiInspectionBundle.message("CdiDomBeansInspection.duplicated.alternative.classes", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkStereotypes(@NotNull DomElementAnnotationHolder holder, @Nullable Module module, @NotNull Alternatives alternatives) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkStereotypes"));
        }
        if (alternatives == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alternatives", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkStereotypes"));
        }
        if (module == null) {
            return;
        }
        Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module);
        MultiMap duplicatedStereotypeMap = new MultiMap();
        for (StereotypeClass stereotypeClass : alternatives.getStereotypes()) {
            PsiClass psiClass = (PsiClass)stereotypeClass.getValue();
            if (psiClass != null) {
                duplicatedStereotypeMap.putValue((Object)psiClass, (Object)stereotypeClass);
            }
            if (stereotypeAnnotationClasses.contains(psiClass)) continue;
            holder.createProblem((DomElement)stereotypeClass, CdiInspectionBundle.message("CdiDomBeansInspection.class.must.be", "@Alternative stereotype annotation"), new LocalQuickFix[0]);
        }
        for (Map.Entry entry : duplicatedStereotypeMap.entrySet()) {
            Collection duplicated = (Collection)entry.getValue();
            if (duplicated.size() <= 1) continue;
            for (StereotypeClass stereotypeClass : duplicated) {
                holder.createProblem((DomElement)stereotypeClass, CdiInspectionBundle.message("CdiDomBeansInspection.duplicated.stereotype.classes", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkAnnotatedClass(@NotNull GenericDomValue<PsiClass> aClass, @NotNull DomElementAnnotationHolder holder, @NotNull String annotation) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkAnnotatedClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkAnnotatedClass"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkAnnotatedClass"));
        }
        CdiDomBeansInspection.checkAnnotatedClass(aClass, holder, (Condition<PsiClass>)((Condition)aClass1 -> {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "lambda$checkAnnotatedClass$1"));
            }
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass1, (String)annotation, (boolean)true);
        }), annotation);
    }

    private static void checkAnnotatedClass(@NotNull GenericDomValue<PsiClass> aClass, @NotNull DomElementAnnotationHolder holder, @NotNull Condition<PsiClass> annoCondition, final @NotNull String annotation) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkAnnotatedClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkAnnotatedClass"));
        }
        if (annoCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoCondition", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkAnnotatedClass"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/cdi/highlighting/CdiDomBeansInspection", "checkAnnotatedClass"));
        }
        final PsiClass psiClass = (PsiClass)aClass.getValue();
        if (psiClass != null && !annoCondition.value((Object)psiClass)) {
            holder.createProblem(aClass, CdiInspectionBundle.message("CdiDomBeansInspection.class.must.be", StringUtil.getShortName((String)annotation)), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getName() {
                    String string = CdiInspectionBundle.message("CdiDomBeansInspection.add.annotation", StringUtil.getShortName((String)annotation));
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDomBeansInspection$1", "getName"));
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    if ("CDI Quick Fixes" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDomBeansInspection$1", "getFamilyName"));
                    }
                    return "CDI Quick Fixes";
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/highlighting/CdiDomBeansInspection$1", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cdi/highlighting/CdiDomBeansInspection$1", "applyFix"));
                    }
                    PsiModifierList list = psiClass.getModifierList();
                    if (list != null) {
                        list.addAnnotation(annotation);
                    }
                }
            }});
        }
    }
}

