/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.midp.uei;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.j2meplugin.emulator.midp.MIDPEmulatorType;
import com.intellij.j2meplugin.emulator.ui.MobileApiSettingsEditor;
import com.intellij.j2meplugin.emulator.ui.MobileDefaultApiEditor;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.j2meplugin.run.states.midp.uei.UEIRunnableState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.filters.StringInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedEmulatorType
extends MIDPEmulatorType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    private String myProfile;
    private String myConfiguration;
    private String mySuggestedName;
    @NonNls
    public static final String INSTALL = "install";
    @NonNls
    public static final String FORCE = "force";
    @NonNls
    public static final String RUN = "run";
    @NonNls
    public static final String REMOVE = "remove";
    @NonNls
    public static final String TRANSIENT = "transient";
    @NonNls
    public static final String STORAGE_NAMES = "storageNames";

    @Override
    @NonNls
    public String getName() {
        return "Unified Emulator Type";
    }

    @Override
    public boolean isValidHomeDirectory(String homePath) {
        return this.fillEmulatorConfigurations(homePath);
    }

    @Override
    public J2MERunnableState getJ2MERunnableState(Executor executor, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSetting, J2MERunConfiguration configuration, Project project, Sdk projectJdk) {
        return new UEIRunnableState(runnerSettings, configurationSetting, configuration, project, projectJdk);
    }

    @Override
    public String getDefaultProfile(@NotNull String home) {
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "com/intellij/j2meplugin/emulator/midp/uei/UnifiedEmulatorType", "getDefaultProfile"));
        }
        if (this.myProfile == null || this.myProfile.length() == 0) {
            this.fillEmulatorConfigurations(home);
        }
        return this.myProfile;
    }

    @Override
    public String getDefaultConfiguration(@NotNull String home) {
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "com/intellij/j2meplugin/emulator/midp/uei/UnifiedEmulatorType", "getDefaultConfiguration"));
        }
        if (this.myConfiguration == null || this.myConfiguration.length() == 0) {
            this.fillEmulatorConfigurations(home);
        }
        return this.myConfiguration;
    }

    @Override
    public MobileApiSettingsEditor getApiEditor(String homePath, Sdk sdk, SdkModificator sdkModificator) {
        return new MobileDefaultApiEditor();
    }

    @Override
    public String[] getAvailableSkins(String homePath) {
        String exe = this.getPathToEmulator(homePath);
        return exe != null ? UnifiedEmulatorType.fillEmulatorDevices(exe) : null;
    }

    private boolean fillEmulatorConfigurations(String home) {
        Properties versionProps = this.getVersionProperties(home);
        if (versionProps == null) {
            return false;
        }
        this.myProfile = versionProps.getProperty("Profile");
        this.myConfiguration = versionProps.getProperty("Configuration");
        this.mySuggestedName = versionProps.getProperty("_SDK_NAME");
        return this.myProfile != null && this.myConfiguration != null && this.mySuggestedName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String[] fillEmulatorDevices(String exe) {
        final StringBuffer help = new StringBuffer();
        if (exe == null) return null;
        if (exe.length() <= 0) return null;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exe);
        String query = "-Xquery";
        generalCommandLine.addParameter("-Xquery");
        try {
            OSProcessHandler osProcessHandler = new OSProcessHandler(generalCommandLine);
            osProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    help.append(event.getText());
                }
            });
            osProcessHandler.startNotify();
            osProcessHandler.waitFor();
            osProcessHandler.destroyProcess();
        }
        catch (ExecutionException e) {
            LOG.debug((Throwable)e);
            return null;
        }
        StringInputStream in = null;
        Properties properties = new Properties();
        try {
            try {
                in = new StringInputStream(help.toString());
                properties.load((InputStream)in);
                String key = "device.list";
                String devices = properties.getProperty("device.list");
                if (devices != null) {
                    String[] skins = devices.split(",");
                    int i = 0;
                    while (true) {
                        if (i >= skins.length) {
                            String[] stringArray2 = skins;
                            return stringArray2;
                        }
                        skins[i] = skins[i].trim();
                        ++i;
                    }
                }
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    @Nullable
    public String[] getOTACommands(String homeDir) {
        String exe = this.getPathToEmulator(homeDir);
        if (exe != null && exe.length() != 0) {
            GeneralCommandLine generalCommandLine = new GeneralCommandLine();
            generalCommandLine.setExePath(exe);
            generalCommandLine.addParameter("-help");
            try {
                OSProcessHandler osProcessHandler = new OSProcessHandler(generalCommandLine);
                final StringBuffer buffer = new StringBuffer();
                osProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        buffer.append(event.getText());
                    }
                });
                osProcessHandler.startNotify();
                osProcessHandler.waitFor();
                osProcessHandler.destroyProcess();
                if (buffer.length() != 0 && buffer.indexOf("-Xjam") != -1) {
                    String otaCommands = buffer.substring(buffer.indexOf("-Xjam") + "-Xjam".length());
                    int endIndex = otaCommands.indexOf("-X");
                    if (endIndex > -1) {
                        otaCommands = otaCommands.substring(0, endIndex);
                    }
                    ArrayList<String> result = new ArrayList<String>();
                    if (otaCommands.indexOf(INSTALL) > -1) {
                        result.add(INSTALL);
                    }
                    if (otaCommands.indexOf(FORCE) > -1) {
                        result.add(FORCE);
                    }
                    if (otaCommands.indexOf(RUN) > -1) {
                        result.add(RUN);
                    }
                    if (otaCommands.indexOf(REMOVE) > -1) {
                        result.add(REMOVE);
                    }
                    if (otaCommands.indexOf(TRANSIENT) > -1) {
                        result.add(TRANSIENT);
                    }
                    if (otaCommands.indexOf(STORAGE_NAMES) > -1) {
                        result.add(STORAGE_NAMES);
                    }
                    return ArrayUtil.toStringArray(result);
                }
            }
            catch (ExecutionException e) {
                return null;
            }
        }
        return null;
    }
}

