/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.subset;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.subset.ModulesToImportDialog;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectSubset {
    @NonNls
    private static final String PROJECT_SUBSET_PROPERTY_NAME = "com.android.studio.selected.modules.on.import";
    private static final String MODULE_LOOKUP_MESSAGE_TITLE = "Module Lookup";
    @NotNull
    private Project myProject;

    @NotNull
    public static ProjectSubset getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "getInstance"));
        }
        ProjectSubset projectSubset = (ProjectSubset)ServiceManager.getService((Project)project, ProjectSubset.class);
        if (projectSubset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "getInstance"));
        }
        return projectSubset;
    }

    public ProjectSubset(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "<init>"));
        }
        this.myProject = project;
    }

    public static boolean isSettingEnabled() {
        return GradleExperimentalSettings.getInstance().SELECT_MODULES_ON_PROJECT_IMPORT;
    }

    public boolean hasCachedModules() {
        Collection<DataNode<ModuleData>> modules = this.getCachedModuleData();
        return modules != null && !modules.isEmpty();
    }

    public void addOrRemoveModules() {
        Collection<DataNode<ModuleData>> modules = this.getCachedModuleData();
        if (modules != null) {
            Collection<DataNode<ModuleData>> selectedModules;
            HashSet selectedModuleNames = Collections.emptySet();
            Object[] selection = this.getSelection();
            if (selection != null) {
                selectedModuleNames = Sets.newHashSet((Object[])selection);
            }
            if ((selectedModules = this.showModuleSelectionDialog(modules, selectedModuleNames)) != null) {
                this.setSelection(selectedModules);
                if (!Arrays.equals(this.getSelection(), selection)) {
                    Projects.populate(this.myProject, selectedModules);
                }
            }
        }
    }

    public void findAndIncludeModuleContainingSourceFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "findAndIncludeModuleContainingSourceFile"));
        }
        final Collection<DataNode<ModuleData>> modules = this.getCachedModuleData();
        if (modules != null && !modules.isEmpty()) {
            final Project project = this.myProject;
            final File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            new Task.Modal(project, "Looking up Module", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/subset/ProjectSubset$1", "run"));
                    }
                    ArrayList results = Lists.newArrayList();
                    Object[] storedSelection = ProjectSubset.this.getSelection();
                    HashSet selection = storedSelection != null ? Sets.newHashSet((Object[])storedSelection) : Sets.newHashSet();
                    ArrayList selectedModules = Lists.newArrayList();
                    int doneCount = 0;
                    for (DataNode moduleNode : modules) {
                        ModuleSearchResult result;
                        indicator.setFraction((double)(++doneCount / modules.size()));
                        ModuleData module = (ModuleData)moduleNode.getData();
                        String name = module.getExternalName();
                        boolean selected = selection.contains(name);
                        if (selected) {
                            selectedModules.add(moduleNode);
                        }
                        if ((result = ProjectSubset.containsSourceFile((DataNode<ModuleData>)moduleNode, file, selected)) == null) continue;
                        results.add(result);
                    }
                    int resultCount = results.size();
                    if (resultCount == 0) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                String text = String.format("Unable to find a module containing the file '%1$s' in a source directory.", file.getName());
                                AndroidGradleNotification notification = AndroidGradleNotification.getInstance(project);
                                notification.showBalloon(ProjectSubset.MODULE_LOOKUP_MESSAGE_TITLE, text, NotificationType.ERROR);
                            }
                        });
                    } else if (resultCount == 1) {
                        ProjectSubset.this.addResultAndPopulateProject((ModuleSearchResult)results.get(0), selectedModules, file);
                    } else {
                        ProjectSubset.this.showModuleSelectionDialog(results, selectedModules, file);
                    }
                }
            }.queue();
        }
    }

    @Nullable
    private static ModuleSearchResult containsSourceFile(@NotNull DataNode<ModuleData> moduleNode, @NotNull File file, boolean selected) {
        JavaProject javaProject;
        AndroidGradleModel androidModel;
        AndroidGradleModel.SourceFileContainerInfo result;
        if (moduleNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "containsSourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "containsSourceFile"));
        }
        DataNode androidProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.ANDROID_MODEL);
        if (androidProjectNode != null && (result = (androidModel = (AndroidGradleModel)androidProjectNode.getData()).containsSourceFile(file)) != null) {
            return new ModuleSearchResult(moduleNode, result, selected);
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.JAVA_PROJECT);
        if (javaProjectNode != null && (javaProject = (JavaProject)javaProjectNode.getData()).containsSourceFile(file)) {
            return new ModuleSearchResult(moduleNode, null, selected);
        }
        return null;
    }

    private void addResultAndPopulateProject(@NotNull ModuleSearchResult result, @NotNull List<DataNode<ModuleData>> selectedModules, @NotNull File file) {
        String text;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "addResultAndPopulateProject"));
        }
        if (selectedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModules", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "addResultAndPopulateProject"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "addResultAndPopulateProject"));
        }
        DataNode<ModuleData> moduleNode = result.moduleNode;
        String moduleName = ProjectSubset.getNameOf(moduleNode);
        if (result.selected) {
            String tmp = String.format("File '%1$s' is already in module '%2$s'", file.getName(), moduleName);
            AndroidGradleModel.SourceFileContainerInfo containerInfo = result.containerInfo;
            if (containerInfo != null) {
                containerInfo.updateSelectedVariantIn(moduleNode);
                Variant variant = containerInfo.variant;
                if (variant != null) {
                    tmp = tmp + String.format(", variant '%1$s'", variant.getName());
                }
            }
            text = tmp;
        } else {
            text = String.format("Module '%1$s' was added to the project.", moduleName);
            AndroidGradleModel.SourceFileContainerInfo containerInfo = result.containerInfo;
            if (containerInfo != null) {
                containerInfo.updateSelectedVariantIn(moduleNode);
            }
            selectedModules.add(moduleNode);
            this.setSelection(selectedModules);
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidGradleNotification notification = AndroidGradleNotification.getInstance(ProjectSubset.this.myProject);
                notification.showBalloon(ProjectSubset.MODULE_LOOKUP_MESSAGE_TITLE, text, NotificationType.INFORMATION);
            }
        });
        Projects.populate(this.myProject, selectedModules);
    }

    private void showModuleSelectionDialog(@NotNull List<ModuleSearchResult> searchResults, @NotNull List<DataNode<ModuleData>> selection, final @NotNull File file) {
        if (searchResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchResults", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "showModuleSelectionDialog"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "showModuleSelectionDialog"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "showModuleSelectionDialog"));
        }
        final ArrayList finalSelection = Lists.newArrayList(selection);
        final ArrayList modulesToDisplayInDialog = Lists.newArrayList();
        final HashMap resultsByModuleName = Maps.newHashMap();
        for (ModuleSearchResult result : searchResults) {
            DataNode<ModuleData> module = result.moduleNode;
            modulesToDisplayInDialog.add(module);
            if (result.selected) {
                finalSelection.remove(module);
            }
            String moduleName = ProjectSubset.getNameOf(module);
            resultsByModuleName.put(moduleName, result);
        }
        GuiUtils.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Collection<DataNode<ModuleData>> selectedModules;
                ModulesToImportDialog dialog = new ModulesToImportDialog(modulesToDisplayInDialog, ProjectSubset.this.myProject);
                String description = String.format("The file '%1$s' may be include in one of the following modules.", file.getName());
                dialog.setDescription(description);
                dialog.clearSelection();
                if (dialog.showAndGet() && !(selectedModules = dialog.getSelectedModules()).isEmpty()) {
                    for (DataNode<ModuleData> selectedModule : selectedModules) {
                        AndroidGradleModel.SourceFileContainerInfo containerInfo;
                        String name = ProjectSubset.getNameOf((DataNode<ModuleData>)selectedModule);
                        ModuleSearchResult result = (ModuleSearchResult)resultsByModuleName.get(name);
                        if (result == null || (containerInfo = result.containerInfo) == null) continue;
                        containerInfo.updateSelectedVariantIn(selectedModule);
                    }
                    finalSelection.addAll(selectedModules);
                    ProjectSubset.this.setSelection(finalSelection);
                    Projects.populate(ProjectSubset.this.myProject, finalSelection);
                }
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    public void findAndIncludeModules(final @NotNull Collection<String> moduleGradlePaths) {
        if (moduleGradlePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleGradlePaths", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "findAndIncludeModules"));
        }
        final Collection<DataNode<ModuleData>> modules = this.getCachedModuleData();
        if (modules != null && !modules.isEmpty()) {
            final Project project = this.myProject;
            new Task.Modal(project, "Finding Missing Modules", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/subset/ProjectSubset$4", "run"));
                    }
                    Object[] originalSelection = ProjectSubset.this.getSelection();
                    HashSet selection = originalSelection != null ? Sets.newHashSet((Object[])originalSelection) : Sets.newHashSet();
                    ArrayList selectedModules = Lists.newArrayList();
                    boolean found = false;
                    int doneCount = 0;
                    for (DataNode module : modules) {
                        GradleModel gradleModel;
                        indicator.setFraction((double)(++doneCount / modules.size()));
                        String name = ProjectSubset.getNameOf((DataNode<ModuleData>)module);
                        if (selection.contains(name)) {
                            selectedModules.add(module);
                            continue;
                        }
                        DataNode gradleProjectNode = ExternalSystemApiUtil.find((DataNode)module, AndroidProjectKeys.GRADLE_MODEL);
                        if (gradleProjectNode == null || !moduleGradlePaths.contains((gradleModel = (GradleModel)gradleProjectNode.getData()).getGradlePath())) continue;
                        selection.add(name);
                        selectedModules.add(module);
                        found = true;
                    }
                    if (!selectedModules.isEmpty() && found) {
                        ProjectSubset.this.setSelection(selectedModules);
                        Projects.populate(project, selectedModules);
                    }
                }
            }.queue();
        }
    }

    @Nullable
    public Collection<DataNode<ModuleData>> getCachedModuleData() {
        DataNode<ProjectData> projectData = GradleUtil.getCachedProjectData(this.myProject);
        if (projectData != null) {
            return ExternalSystemApiUtil.findAll(projectData, (Key)ProjectKeys.MODULE);
        }
        return null;
    }

    @Nullable
    public Collection<DataNode<ModuleData>> showModuleSelectionDialog(@NotNull Collection<DataNode<ModuleData>> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "showModuleSelectionDialog"));
        }
        Set<String> noSelection = Collections.emptySet();
        return this.showModuleSelectionDialog(modules, noSelection);
    }

    @Nullable
    private Collection<DataNode<ModuleData>> showModuleSelectionDialog(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull Collection<String> selectedModuleNames) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "showModuleSelectionDialog"));
        }
        if (selectedModuleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModuleNames", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "showModuleSelectionDialog"));
        }
        ModulesToImportDialog dialog = new ModulesToImportDialog(modules, this.myProject);
        if (!selectedModuleNames.isEmpty()) {
            dialog.updateSelection(selectedModuleNames);
        }
        if (dialog.showAndGet()) {
            Collection<DataNode<ModuleData>> selectedModules = dialog.getSelectedModules();
            this.setSelection(selectedModules);
            return selectedModules;
        }
        return null;
    }

    private void setSelection(@NotNull Collection<DataNode<ModuleData>> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "setSelection"));
        }
        ArrayList moduleNames = Lists.newArrayListWithExpectedSize((int)modules.size());
        for (DataNode<ModuleData> module : modules) {
            moduleNames.add(ProjectSubset.getNameOf(module));
        }
        this.updateSelection(moduleNames);
    }

    @NotNull
    private static String getNameOf(@NotNull DataNode<ModuleData> module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "getNameOf"));
        }
        String string = ((ModuleData)module.getData()).getExternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/subset/ProjectSubset", "getNameOf"));
        }
        return string;
    }

    public void clearSelection() {
        this.updateSelection(null);
    }

    private void updateSelection(@Nullable List<String> moduleNames) {
        String[] values = moduleNames != null ? ArrayUtil.toStringArray(moduleNames) : null;
        PropertiesComponent.getInstance((Project)this.myProject).setValues(PROJECT_SUBSET_PROPERTY_NAME, values);
    }

    @Nullable
    public String[] getSelection() {
        return PropertiesComponent.getInstance((Project)this.myProject).getValues(PROJECT_SUBSET_PROPERTY_NAME);
    }

    private static class ModuleSearchResult {
        @NotNull
        public final DataNode<ModuleData> moduleNode;
        @Nullable
        public final AndroidGradleModel.SourceFileContainerInfo containerInfo;
        public final boolean selected;

        ModuleSearchResult(@NotNull DataNode<ModuleData> moduleNode, @Nullable AndroidGradleModel.SourceFileContainerInfo containerInfo, boolean selected) {
            if (moduleNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "com/android/tools/idea/gradle/project/subset/ProjectSubset$ModuleSearchResult", "<init>"));
            }
            this.moduleNode = moduleNode;
            this.containerInfo = containerInfo;
            this.selected = selected;
        }
    }
}

