/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.structure.configurables.model.ArtifactDependencyMergedModel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class ArtifactDependencyEditor {
    private JPanel myPanel;
    private JTextField myGroupIdTextField;
    private JTextField myArtifactNameTextField;
    private JBLabel myScopeLabel;
    private TextFieldWithBrowseButton myScopeField;
    private JTextField myVersionTextField;
    private JButton myCheckForUpdatesButton;

    ArtifactDependencyEditor() {
        this.$$$setupUI$$$();
        this.myScopeLabel.setLabelFor((Component)this.myScopeField.getTextField());
        Color background = UIUtil.getLabelBackground();
        this.myGroupIdTextField.setBackground(background);
        this.myArtifactNameTextField.setBackground(background);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/ArtifactDependencyEditor", "getPanel"));
        }
        return jPanel;
    }

    void update(@NotNull ArtifactDependencyMergedModel dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/ArtifactDependencyEditor", "update"));
        }
        GradleCoordinate coordinate = dependency.getCoordinate();
        this.myGroupIdTextField.setText(coordinate.getGroupId());
        this.myArtifactNameTextField.setText(coordinate.getArtifactId());
        this.myVersionTextField.setText(coordinate.getRevision());
        this.myScopeField.setText(dependency.getConfigurationName());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setText("Group ID:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setText("Artifact Name:");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myScopeLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("Scope:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jBLabel.setRequestFocusEnabled(false);
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myScopeField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCheckForUpdatesButton = jButton = new JButton();
        jButton.setActionCommand("");
        jButton.setText("Check for Updates");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(4, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel4.setText("Version:");
        jBLabel4.setDisplayedMnemonic('V');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myVersionTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myGroupIdTextField = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myArtifactNameTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel4.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

