/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.treeview;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.structure.configurables.editor.treeview.GradleNode;
import com.android.tools.idea.gradle.structure.configurables.editor.treeview.VariantNode;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerNode
extends GradleNode {
    public ContainerNode(@NotNull String name, @Nullable GradleNode parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/configurables/editor/treeview/ContainerNode", "<init>"));
        }
        super(parent);
        this.myName = name;
        this.myClosedIcon = AllIcons.Nodes.Folder;
    }

    public static class Variants
    extends ContainerNode {
        public Variants(@NotNull AndroidProject androidProject, boolean autoExpandVariants) {
            if (androidProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/structure/configurables/editor/treeview/ContainerNode$Variants", "<init>"));
            }
            this(androidProject, null, autoExpandVariants);
        }

        public Variants(@NotNull AndroidProject androidProject, @Nullable GradleNode parent, boolean autoExpandVariants) {
            if (androidProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/structure/configurables/editor/treeview/ContainerNode$Variants", "<init>"));
            }
            super("Variants", parent);
            Collection variants = androidProject.getVariants();
            int variantCount = variants.size();
            ArrayList children = Lists.newArrayListWithExpectedSize((int)variantCount);
            for (Variant variant : variants) {
                VariantNode child = new VariantNode(variant, this);
                child.setAutoExpand(autoExpandVariants);
                children.add(child);
            }
            this.setChildren(children);
        }
    }
}

