/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.npw.TemplateWizardModuleBuilder;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.BuilderBasedTemplate;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateWizardProjectTemplateFactory
extends ProjectTemplatesFactory {
    public static final ProjectTemplate[] EMPTY_PROJECT_TEMPLATES = ProjectTemplate.EMPTY_ARRAY;
    private static final String IMPORT_EXISTING_PROJECT_TEMPLATE_NAME = "ImportExistingProject";

    @NotNull
    public String[] getGroups() {
        String[] stringArray = new String[]{"Android"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateWizardProjectTemplateFactory", "getGroups"));
        }
        return stringArray;
    }

    public Icon getGroupIcon(String group) {
        return AndroidIcons.Android;
    }

    public String getParentGroup(String group) {
        return "Java";
    }

    public int getGroupWeight(String group) {
        return 60;
    }

    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        Project project = context.getProject();
        if (project != null && !Projects.requiresAndroidModel(project)) {
            if (EMPTY_PROJECT_TEMPLATES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateWizardProjectTemplateFactory", "createTemplates"));
            }
            return EMPTY_PROJECT_TEMPLATES;
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates("gradle-projects");
        ArrayList<AndroidProjectTemplate> tt = new ArrayList<AndroidProjectTemplate>();
        for (File template : templates) {
            TemplateMetadata metadata;
            String templateName = template.getName();
            if ("NewAndroidProject".equals(templateName) || IMPORT_EXISTING_PROJECT_TEMPLATE_NAME.equals(templateName) || project == null && !"NewAndroidModule".equals(templateName) || (metadata = manager.getTemplateMetadata(template)) == null || !metadata.isSupported()) continue;
            tt.add(new AndroidProjectTemplate(template, metadata, project, context.getDisposable()));
        }
        ProjectTemplate[] projectTemplateArray = tt.toArray(new ProjectTemplate[tt.size()]);
        if (projectTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateWizardProjectTemplateFactory", "createTemplates"));
        }
        return projectTemplateArray;
    }

    private static class AndroidProjectTemplate
    extends BuilderBasedTemplate {
        private final TemplateMetadata myTemplateMetadata;

        private AndroidProjectTemplate(File templateFile, TemplateMetadata metadata, Project project, Disposable parentDisposable) {
            super((ModuleBuilder)new TemplateWizardModuleBuilder(templateFile, metadata, project, null, new ArrayList<ModuleWizardStep>(), parentDisposable, true));
            this.myTemplateMetadata = metadata;
        }

        @NotNull
        public String getName() {
            String title = this.myTemplateMetadata.getTitle();
            assert (title != null);
            String string = "Gradle: " + title;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateWizardProjectTemplateFactory$AndroidProjectTemplate", "getName"));
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return this.myTemplateMetadata.getDescription();
        }
    }
}

