/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.GradleApkProvider;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.NonGradleApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeepLinkLaunch;
import com.android.tools.idea.run.editor.DefaultActivityLaunch;
import com.android.tools.idea.run.editor.LaunchOption;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.android.tools.idea.run.editor.NoLaunch;
import com.android.tools.idea.run.editor.SpecificActivityLaunch;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    @NonNls
    public static final String LAUNCH_DEFAULT_ACTIVITY = "default_activity";
    @NonNls
    public static final String LAUNCH_SPECIFIC_ACTIVITY = "specific_activity";
    @NonNls
    public static final String DO_NOTHING = "do_nothing";
    @NonNls
    public static final String LAUNCH_DEEP_LINK = "launch_deep_link";
    public static final List<? extends LaunchOption> LAUNCH_OPTIONS = Arrays.asList(NoLaunch.INSTANCE, DefaultActivityLaunch.INSTANCE, SpecificActivityLaunch.INSTANCE, DeepLinkLaunch.INSTANCE);
    public boolean DEPLOY = true;
    public String ARTIFACT_NAME = "";
    public String PM_INSTALL_OPTIONS = "";
    public String ACTIVITY_EXTRA_FLAGS = "";
    public String MODE = "default_activity";
    private final Map<String, LaunchOptionState> myLaunchOptionStates = Maps.newHashMap();

    public AndroidRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory, false);
        for (LaunchOption launchOption : LAUNCH_OPTIONS) {
            this.myLaunchOptionStates.put(launchOption.getId(), (LaunchOptionState)launchOption.createState());
        }
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfiguration", "supportsRunningLibraryProjects"));
        }
        return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
    }

    @Override
    @NotNull
    protected List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfiguration", "checkConfiguration"));
        }
        LaunchOptionState launchOptionState = this.getLaunchOptionState(this.MODE);
        if (launchOptionState == null) {
            List<ValidationError> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration", "checkConfiguration"));
            }
            return list;
        }
        List<ValidationError> list = launchOptionState.checkConfiguration(facet);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration", "checkConfiguration"));
        }
        return list;
    }

    @Override
    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        LaunchOptions.Builder builder = super.getLaunchOptions().setDeploy(this.DEPLOY).setPmInstallOptions(this.PM_INSTALL_OPTIONS).setOpenLogcatAutomatically(this.SHOW_LOGCAT_AUTOMATICALLY);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration", "getLaunchOptions"));
        }
        return builder;
    }

    @Override
    @NotNull
    protected ApkProvider getApkProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfiguration", "getApkProvider"));
        }
        if (facet.getAndroidModel() != null && facet.getAndroidModel() instanceof AndroidGradleModel) {
            GradleApkProvider gradleApkProvider = new GradleApkProvider(facet, false);
            if (gradleApkProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration", "getApkProvider"));
            }
            return gradleApkProvider;
        }
        NonGradleApkProvider nonGradleApkProvider = new NonGradleApkProvider(facet, this.ARTIFACT_NAME);
        if (nonGradleApkProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration", "getApkProvider"));
        }
        return nonGradleApkProvider;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor<AndroidRunConfiguration> editor = new AndroidRunConfigurationEditor<AndroidRunConfiguration>(project, (Predicate<AndroidFacet>)Predicates.alwaysFalse(), this);
        editor.setConfigurationSpecificEditor(new ApplicationRunParameters(project, editor.getModuleSelector()));
        AndroidRunConfigurationEditor<AndroidRunConfiguration> androidRunConfigurationEditor = editor;
        if (androidRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration", "getConfigurationEditor"));
        }
        return androidRunConfigurationEditor;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        final SpecificActivityLaunch.State state = (SpecificActivityLaunch.State)this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state != null);
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(String qualifiedName) {
                state.ACTIVITY_CLASS = qualifiedName;
            }

            @Nullable
            public PsiClass getPsiElement() {
                return ((JavaRunConfigurationModule)AndroidRunConfiguration.this.getConfigurationModule()).findClass(state.ACTIVITY_CLASS);
            }

            public void setPsiElement(PsiClass psiClass) {
                state.ACTIVITY_CLASS = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass);
            }
        });
    }

    @Override
    @NotNull
    protected ConsoleProvider getConsoleProvider() {
        ConsoleProvider consoleProvider = new ConsoleProvider(){

            @Override
            @NotNull
            public ConsoleView createAndAttach(@NotNull Disposable parent, @NotNull ProcessHandler handler, @NotNull Executor executor) throws ExecutionException {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/run/AndroidRunConfiguration$2", "createAndAttach"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/run/AndroidRunConfiguration$2", "createAndAttach"));
                }
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunConfiguration$2", "createAndAttach"));
                }
                Project project = ((JavaRunConfigurationModule)AndroidRunConfiguration.this.getConfigurationModule()).getProject();
                TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
                ConsoleView console = builder.getConsole();
                console.attachToProcess(handler);
                ConsoleView consoleView = console;
                if (consoleView == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration$2", "createAndAttach"));
                }
                return consoleView;
            }
        };
        if (consoleProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfiguration", "getConsoleProvider"));
        }
        return consoleProvider;
    }

    @Override
    public boolean supportsInstantRun() {
        return true;
    }

    @Override
    protected boolean supportMultipleDevices() {
        return true;
    }

    @Override
    @Nullable
    protected LaunchTask getApplicationLaunchTask(@NotNull ApkProvider apkProvider, @NotNull AndroidFacet facet, boolean waitForDebugger, @NotNull LaunchStatus launchStatus) {
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/AndroidRunConfiguration", "getApplicationLaunchTask"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunConfiguration", "getApplicationLaunchTask"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/AndroidRunConfiguration", "getApplicationLaunchTask"));
        }
        LaunchOptionState state = this.getLaunchOptionState(this.MODE);
        assert (state != null);
        try {
            String applicationId = apkProvider.getPackageName();
            return state.getLaunchTask(applicationId, facet, waitForDebugger, this.ACTIVITY_EXTRA_FLAGS);
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidRunConfiguration.class).error((Throwable)e);
            launchStatus.terminateLaunch("Unable to identify application id");
            return null;
        }
    }

    public void setLaunchActivity(@NotNull String activityName) {
        if (activityName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/android/tools/idea/run/AndroidRunConfiguration", "setLaunchActivity"));
        }
        this.MODE = LAUNCH_SPECIFIC_ACTIVITY;
        LaunchOptionState state = this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state instanceof SpecificActivityLaunch.State);
        ((SpecificActivityLaunch.State)state).ACTIVITY_CLASS = activityName;
    }

    public boolean isLaunchingActivity(@Nullable String activityName) {
        if (!StringUtil.equals((CharSequence)this.MODE, (CharSequence)LAUNCH_SPECIFIC_ACTIVITY)) {
            return false;
        }
        LaunchOptionState state = this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state instanceof SpecificActivityLaunch.State);
        return StringUtil.equals((CharSequence)((SpecificActivityLaunch.State)state).ACTIVITY_CLASS, (CharSequence)activityName);
    }

    @Nullable
    public LaunchOptionState getLaunchOptionState(@NotNull String launchOptionId) {
        if (launchOptionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptionId", "com/android/tools/idea/run/AndroidRunConfiguration", "getLaunchOptionState"));
        }
        return this.myLaunchOptionStates.get(launchOptionId);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        for (LaunchOptionState state : this.myLaunchOptionStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        for (LaunchOptionState state : this.myLaunchOptionStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }
}

