/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.dcx;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.sanselan.formats.pcx.PcxImageParser;

public class DcxImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".dcx";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".dcx"};

    public DcxImageParser() {
        super.setByteOrder(73);
    }

    @Override
    public String getName() {
        return "Dcx-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_DCX};
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DcxHeader readDcxHeader(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            int pageOffset;
            is = byteSource.getInputStream();
            int id = this.read4Bytes("Id", is, "Not a Valid DCX File");
            ArrayList<Integer> pageTable = new ArrayList<Integer>(1024);
            for (int i = 0; i < 1024 && (pageOffset = this.read4Bytes("PageTable", is, "Not a Valid DCX File")) != 0; ++i) {
                pageTable.add(new Integer(pageOffset));
            }
            if (id != 987654321) {
                throw new ImageReadException("Not a Valid DCX File: file id incorrect");
            }
            if (pageTable.size() == 1024) {
                throw new ImageReadException("DCX page table not terminated by zero entry");
            }
            Object[] objects = pageTable.toArray();
            int[] pages = new int[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                pages[i] = (Integer)objects[i];
            }
            DcxHeader dcxHeader = new DcxHeader(id, pages);
            return dcxHeader;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        this.readDcxHeader(byteSource).dump(pw);
        return true;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ArrayList list = this.getAllBufferedImages(byteSource);
        if (list.isEmpty()) {
            return null;
        }
        return (BufferedImage)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getAllBufferedImages(ByteSource byteSource) throws ImageReadException, IOException {
        DcxHeader dcxHeader = this.readDcxHeader(byteSource);
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        PcxImageParser pcxImageParser = new PcxImageParser();
        for (int i = 0; i < dcxHeader.pageTable.length; ++i) {
            InputStream stream = null;
            try {
                stream = byteSource.getInputStream(dcxHeader.pageTable[i]);
                ByteSourceInputStream pcxSource = new ByteSourceInputStream(stream, null);
                BufferedImage image = pcxImageParser.getBufferedImage(pcxSource, new HashMap());
                images.add(image);
                continue;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException ignored) {}
            }
        }
        return images;
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        params = params == null ? new HashMap() : new HashMap(params);
        HashMap pcxParams = new HashMap();
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.containsKey("PCX_COMPRESSION")) {
            Object value = params.remove("PCX_COMPRESSION");
            pcxParams.put("PCX_COMPRESSION", value);
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        int headerSize = 4100;
        BinaryOutputStream bos = new BinaryOutputStream(os, 73);
        bos.write4Bytes(987654321);
        bos.write4Bytes(4100);
        for (int i = 0; i < 1023; ++i) {
            bos.write4Bytes(0);
        }
        PcxImageParser pcxImageParser = new PcxImageParser();
        pcxImageParser.writeImage(src, bos, pcxParams);
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private static class DcxHeader {
        public static final int DCX_ID = 987654321;
        public final int id;
        public final int[] pageTable;

        public DcxHeader(int id, int[] pageTable) {
            this.id = id;
            this.pageTable = pageTable;
        }

        public void dump(PrintWriter pw) {
            pw.println("DcxHeader");
            pw.println("Id: 0x" + Integer.toHexString(this.id));
            pw.println("Pages: " + this.pageTable.length);
            pw.println();
        }
    }
}

