/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ultimate.UltimateVerifier;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExtendedNotificationBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.NameScope;

public class CreateSubfolderAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        boolean b = CreateSubfolderAction.isEnabled(e.getDataContext());
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(b);
        } else {
            e.getPresentation().setEnabled(b);
        }
    }

    static boolean isEnabled(DataContext dataContext) {
        if (PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext) == null) {
            return false;
        }
        if (WebDeploymentDataKeys.SERVER_CONFIG.getData(dataContext) == null) {
            return false;
        }
        if (WebDeploymentDataKeys.REMOTE_CONNECTION.getData(dataContext) == null) {
            return false;
        }
        ServerTreeNode[] nodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
        if (nodes == null || nodes.length != 1 || !nodes[0].isDirectory()) {
            return false;
        }
        FileObject[] files = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(dataContext);
        return files != null && files.length != 0;
    }

    public void actionPerformed(AnActionEvent event) {
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(event.getDataContext());
        final WebServerConfig server = (WebServerConfig)WebDeploymentDataKeys.SERVER_CONFIG.getData(event.getDataContext());
        final RemoteConnection connection = (RemoteConnection)WebDeploymentDataKeys.REMOTE_CONNECTION.getData(event.getDataContext());
        final FileObject[] files = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(event.getDataContext());
        if (files == null || files.length != 1 || connection == null) {
            return;
        }
        Project project = event.getProject();
        final ServerTree tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(event.getDataContext()));
        boolean isModalContext = (Boolean)PlatformDataKeys.IS_MODAL_CONTEXT.getData(event.getDataContext());
        String title = WDBundle.message("create.folder.action.title", server.getName());
        final String childName = Messages.showInputDialog((Component)component, (String)WDBundle.message("prompt.enter.new.folder.name", new Object[0]), (String)title, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return this.canClose(inputString);
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString);
            }
        });
        if (childName == null) {
            return;
        }
        PublishConfig publishConfig = project != null && !project.isDefault() ? PublishConfig.getInstance(project).clone() : new PublishConfig(null, UltimateVerifier.getInstance());
        final Ref childPath = new Ref();
        new ExtendedNotificationBrowserTask(project, ConnectionOwnerFactory.createConnectionOwner(project, component), publishConfig, server, WDBundle.message("create.folder.action.title", childName), isModalContext, component, WDBundle.message("create.folder.action.title", new Object[0]), DeploymentRevisionTracker.DEAF, true, true){

            @Override
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                childPath.set((Object)server.getRemotePath(files[0].resolveFile(childName, NameScope.CHILD)));
                ArrayList<1> result = new ArrayList<1>();
                result.add(new TransferOperation.CreateFolder((WebServerConfig.RemotePath)childPath.get()){

                    @Override
                    public void execute(ExecutionContext context) throws FileSystemException {
                        super.execute(context);
                        context.scheduleForSelection((WebServerConfig.RemotePath)childPath.get(), (Object)tree);
                    }
                });
                return new TransferTask.ListBased.ResultWithErrors(result, new DeploymentPathUtils.ErrorsAndExclusions());
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        }.queue();
    }
}

