/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadCheckinHandlerFactory;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadFilesAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)UploadFilesAction.class.getName());

    public void update(AnActionEvent e) {
        boolean invokedAtRemoteBrowser = WebDeploymentDataKeys.SERVER_TREE.getData(e.getDataContext()) != null;
        Collection<WebServerConfig> servers = UploadFilesAction.getExtraServers(e, invokedAtRemoteBrowser, this.isChooseServer());
        if (!this.isChooseServer()) {
            if (invokedAtRemoteBrowser) {
                e.getPresentation().setText(WDBundle.message("action.title.upload.here", new Object[0]));
            } else if (!servers.isEmpty()) {
                e.getPresentation().setText(WDBundle.message("action.title.upload.to", servers.iterator().next().getName()));
            }
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(!servers.isEmpty());
        } else {
            e.getPresentation().setEnabled(!servers.isEmpty());
        }
    }

    @NotNull
    static Collection<WebServerConfig> getExtraServers(AnActionEvent e, boolean invokedAtRemoteBrowser, boolean chooseServer) {
        Collection<Object> servers;
        if (chooseServer && invokedAtRemoteBrowser) {
            servers = Collections.emptyList();
        } else {
            Project project;
            servers = UploadFilesAction.isEnabled(e, chooseServer);
            if (chooseServer && servers.size() == 1 && ActionPlaces.isPopupPlace((String)e.getPlace()) && ((project = e.getProject()) == null || ((WebServerConfig)servers.iterator().next()).getId().equals(PublishConfig.getInstance((Project)project).getDefaultServerIdAndName().first))) {
                servers = Collections.emptyList();
            }
        }
        Collection<Object> collection = servers;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "getExtraServers"));
        }
        return collection;
    }

    protected boolean isChooseServer() {
        return false;
    }

    @NotNull
    static Collection<WebServerConfig> isEnabled(AnActionEvent e, boolean chooseServer) {
        if ("RemoteHostDialogPopup".equals(e.getPlace())) {
            List<WebServerConfig> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "isEnabled"));
            }
            return list;
        }
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault()) {
            List<WebServerConfig> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "isEnabled"));
            }
            return list;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        Change[] changes = (Change[])VcsDataKeys.CHANGES.getData(e.getDataContext());
        if (changes != null) {
            Collection<WebServerConfig> collection = UploadFilesAction.findSuitableServers(project, publishConfig, changes, chooseServer);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "isEnabled"));
            }
            return collection;
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files != null) {
            VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(files);
            Collection<WebServerConfig> collection = UploadFilesAction.findSuitableServers(project, publishConfig, (Collection<VirtualFile>)roots, chooseServer);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "isEnabled"));
            }
            return collection;
        }
        FileObject[] nodes = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(e.getDataContext());
        if (nodes != null) {
            WebServerConfig server = (WebServerConfig)WebDeploymentDataKeys.SERVER_CONFIG.getData(e.getDataContext());
            LOG.assertTrue(server != null);
            if (server.getFileTransferConfig().validateFast() != null) {
                List<WebServerConfig> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "isEnabled"));
                }
                return list;
            }
            for (FileObject node : nodes) {
                if (publishConfig.getNearestMappingDeploy2Local(node, false, server).getFirst() == null && ((List)publishConfig.getChildMappingsDeploy2Local(node, server).getFirst()).isEmpty()) continue;
                List<WebServerConfig> list = Collections.singletonList(server);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "isEnabled"));
                }
                return list;
            }
        }
        List<WebServerConfig> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "isEnabled"));
        }
        return list;
    }

    @NotNull
    private static Collection<WebServerConfig> findServers(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Condition<WebServerConfig> include, boolean chooseServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findServers"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findServers"));
        }
        if (include == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "include", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findServers"));
        }
        List<WebServerConfig> servers = chooseServer ? WebServersConfigManager.getInstance(project).getServers(true) : Collections.singletonList(publishConfig.findDefaultServer());
        ArrayList<WebServerConfig> result = new ArrayList<WebServerConfig>();
        for (WebServerConfig server : servers) {
            if (server == null || server.getFileTransferConfig().validateFast() != null || !include.value((Object)server)) continue;
            result.add(server);
        }
        ArrayList<WebServerConfig> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findServers"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<WebServerConfig> findSuitableServers(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Collection<VirtualFile> roots, boolean chooseServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        Collection<WebServerConfig> collection = UploadFilesAction.findServers(project, publishConfig, (Condition<WebServerConfig>)((Condition)server -> {
            if (publishConfig == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "lambda$findSuitableServers$0"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "lambda$findSuitableServers$0"));
            }
            return UploadFilesAction.checkServer(publishConfig, server, roots);
        }), chooseServer);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        return collection;
    }

    @NotNull
    private static Collection<WebServerConfig> findSuitableServers(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Change[] changes, boolean chooseServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        Collection<WebServerConfig> collection = UploadFilesAction.findServers(project, publishConfig, (Condition<WebServerConfig>)((Condition)server -> {
            if (publishConfig == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "lambda$findSuitableServers$1"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "lambda$findSuitableServers$1"));
            }
            return UploadFilesAction.checkServer(publishConfig, server, changes);
        }), chooseServer);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "findSuitableServers"));
        }
        return collection;
    }

    private static boolean checkServer(PublishConfig publishConfig, WebServerConfig server, Change[] changes) {
        if (!server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
            return false;
        }
        for (Change change : changes) {
            FilePath file;
            if (!(change.getBeforeRevision() != null ? publishConfig.getNearestMappingForLocal((file = change.getBeforeRevision().getFile()).getPath(), false, true, false, server).getFirst() != null : publishConfig.getNearestMappingForLocal((file = change.getAfterRevision().getFile()).getPath(), false, true, false, server).getFirst() != null)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkServer(PublishConfig publishConfig, WebServerConfig server, Collection<VirtualFile> roots) {
        for (VirtualFile root : roots) {
            if (!PublishActionUtil.checkMapping(publishConfig, server, root.getPath(), true)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        LOG.assertTrue(project != null);
        final PublishConfig publishConfig = PublishConfig.getInstance(project);
        final Change[] changes = (Change[])VcsDataKeys.CHANGES.getData(e.getDataContext());
        final ChangeList[] changeLists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(e.getDataContext());
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        final FileObject[] remoteFiles = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(e.getDataContext());
        VfsUtilCore.DistinctVFilesRootsCollection roots = files != null ? new VfsUtilCore.DistinctVFilesRootsCollection(files) : null;
        final RemoteConnection connection = (RemoteConnection)WebDeploymentDataKeys.REMOTE_CONNECTION.getData(e.getDataContext());
        Collection<Object> servers = changes != null ? UploadFilesAction.findSuitableServers(project, publishConfig, changes, this.isChooseServer()) : (files != null ? UploadFilesAction.findSuitableServers(project, publishConfig, Arrays.asList(files), this.isChooseServer()) : Collections.singletonList(WebDeploymentDataKeys.SERVER_CONFIG.getData(e.getDataContext())));
        LOG.assertTrue(!servers.isEmpty());
        if (servers.size() == 1 && !this.isChooseServer()) {
            UploadFilesAction.execute(project, publishConfig, servers.iterator().next(), changes, changeLists, remoteFiles, connection, (Collection<VirtualFile>)roots);
        } else {
            PublishActionUtil.chooseServer(publishConfig, servers, e, WDBundle.message("choose.server.to.upload.to", new Object[0])).doWhenDone((Consumer)new Consumer<WebServerConfig>((Collection)roots){
                final /* synthetic */ Collection val$roots;
                {
                    this.val$roots = collection;
                }

                public void consume(WebServerConfig server) {
                    UploadFilesAction.execute(project, publishConfig, server, changes, changeLists, remoteFiles, connection, this.val$roots);
                }
            });
        }
    }

    private static void execute(@NotNull Project project, PublishConfig publishConfig, @NotNull WebServerConfig server, final Change[] changes, ChangeList[] changeLists, final FileObject[] remoteFiles, final @Nullable RemoteConnection connection, final Collection<VirtualFile> roots) {
        String title;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "execute"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction", "execute"));
        }
        if (changes != null) {
            title = changeLists != null && changeLists.length == 1 && changeLists[0].getChanges().size() == changes.length ? WDBundle.message("upload.changelist.to", changeLists[0].getName(), StringUtil.notNullize((String)server.getName())) : WDBundle.message("upload.changes.to", changes.length, changes.length == 1 ? 1 : 2, StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, changes);
        } else if (roots != null) {
            title = WDBundle.message("upload.to", StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, roots);
        } else {
            title = WDBundle.message("upload.to", StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, UploadFilesAction.getLocalRoots(publishConfig, remoteFiles, server));
        }
        TransferTask.ListBased transferTask = new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

            @Override
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                if (changes != null) {
                    return UploadCheckinHandlerFactory.doScanFiles(context, Arrays.asList(changes));
                }
                if (roots != null) {
                    return PublishActionUtil.scanFiles(context, roots);
                }
                LOG.assertTrue(remoteFiles != null);
                DistinctRootsCollections.FileObjects uploadRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
                ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
                DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
                Iterator iterator = uploadRoots.iterator();
                while (iterator.hasNext()) {
                    FileObject uploadRoot = (FileObject)iterator.next();
                    DeploymentPathUtils.refreshRemoteFile(uploadRoot, context);
                    DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processIncoming(uploadRoot, context, result);
                    errors.addAll(e);
                }
                return new TransferTask.ListBased.ResultWithErrors(result, errors);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        };
        FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
        ProgressManager.getInstance().run((Task)transferTask);
    }

    public static Collection<VirtualFile> getLocalRoots(PublishConfig publishConfig, FileObject[] remoteFiles, WebServerConfig server) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        DistinctRootsCollections.FileObjects remoteRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
        Iterator iterator = remoteRoots.iterator();
        while (iterator.hasNext()) {
            FileObject remoteRoot = (FileObject)iterator.next();
            DeploymentPathMapping parentMapping = (DeploymentPathMapping)publishConfig.getNearestMappingDeploy2Local(remoteRoot.getName(), false, server).getFirst();
            if (parentMapping != null) {
                UploadFilesAction.processMapping(result, parentMapping);
                continue;
            }
            Collection childMappings = (Collection)publishConfig.getChildMappingsDeploy2Local(remoteRoot.getName(), server).getFirst();
            for (DeploymentPathMapping childMapping : childMappings) {
                UploadFilesAction.processMapping(result, childMapping);
            }
        }
        return result;
    }

    private static void processMapping(Collection<VirtualFile> result, DeploymentPathMapping parentMapping) {
        VirtualFile localRoot = LocalFileSystem.getInstance().findFileByPath(parentMapping.getLocalPath());
        if (localRoot != null && localRoot.isValid()) {
            result.add(localRoot);
        }
    }
}

