/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.ErrorMessageAndField;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@Tag(value="fileTransfer")
public class FileTransferConfig
implements Cloneable {
    @NonNls
    public static final String FILE_TRANSFER_TAG = "fileTransfer";
    @NonNls
    public static final String ROOT_FOLDER_ATTRIBUTE = "rootFolder";
    @NonNls
    public static final String ANONYMOUS = "anonymous";
    @NonNls
    public static final String ANONYMOUS_EMAIL = "user@example.com";
    public static final int FTPS_EXPLICIT_PORT = 21;
    public static final int FTPS_IMPLICIT_PORT = 990;
    private static final Logger LOG = Logger.getInstance((String)FileTransferConfig.class.getName());
    private RemoteCredentialsVerifiableHolder myCredentials = new RemoteCredentialsVerifiableHolder();
    private AccessType myAccessType = AccessType.FTP;
    private PasswordState myPasswordState = PasswordState.Unspecified;
    private PasswordState myPassphraseState = PasswordState.Unspecified;
    private AdvancedOptionsConfig myAdvancedOptions = new AdvancedOptionsConfig();
    private String myRootFolder = this.myAccessType.getDefaultRootFolder();
    private String myMountedFolder = null;
    private boolean myFtpsExplicit = true;

    @Attribute(value="protocol")
    public String getSerializedProtocol() {
        return null;
    }

    public void setSerializedProtocol(String protocol) {
        this.setSerializedAccessType(protocol);
    }

    @Attribute(value="accessType")
    public String getSerializedAccessType() {
        return this.myAccessType.name();
    }

    public void setSerializedAccessType(String accessType) {
        try {
            this.myAccessType = AccessType.valueOf(accessType);
        }
        catch (IllegalArgumentException e) {
            this.myAccessType = AccessType.FTP;
        }
    }

    @Transient
    public AccessType getAccessType() {
        return this.myAccessType;
    }

    public void setAccessType(AccessType accessType) {
        this.myAccessType = accessType;
    }

    @Transient
    public RemoteCredentialsVerifiableHolder getCredentials() {
        return this.myCredentials;
    }

    @Attribute(value="host")
    public String getHost() {
        return this.myCredentials.getHost();
    }

    public void setHost(String host) {
        this.myCredentials.setHost(host);
    }

    public int getPort() {
        return this.myCredentials.getPort();
    }

    public void setPort(int port) {
        this.myCredentials.setPort(port);
    }

    @Attribute(value="port")
    public String getLiteralPort() {
        return this.myCredentials.getLiteralPort();
    }

    public void setLiteralPort(String port) {
        this.myCredentials.setLiteralPort(port);
    }

    @Transient
    public String getUserName() {
        return this.myCredentials.getUserName();
    }

    public void setUserName(String userName) {
        this.myCredentials.setUserName(userName);
    }

    @Attribute(value="username")
    @Deprecated
    @Nullable
    public String getSerializedUserName() {
        return null;
    }

    @Deprecated
    public void setSerializedUserName(String userName) {
        this.setUserName(userName);
    }

    @Transient
    public String getPassword() {
        return this.myCredentials.getPassword();
    }

    public void setPassword(String password, boolean force) {
        this.myCredentials.setPassword(password);
        if (force || StringUtil.isNotEmpty((String)password)) {
            LOG.assertTrue(password != null);
            this.myPasswordState = PasswordState.Specified;
        } else {
            this.myPasswordState = PasswordState.Unspecified;
        }
    }

    @Attribute(value="password")
    @Deprecated
    @Nullable
    public String getSerializedPassword() {
        return null;
    }

    @Deprecated
    public void setSerializedPassword(String serializedPassword) {
        String password;
        if (serializedPassword != null) {
            password = PasswordUtil.decodePassword((String)serializedPassword);
            this.myPasswordState = PasswordState.Store;
        } else {
            password = null;
            this.myPasswordState = PasswordState.Unspecified;
        }
        this.myCredentials.setPassword(password);
    }

    public void setStorePassword(boolean storePassword) {
        if (storePassword) {
            this.myPasswordState = PasswordState.Store;
        }
    }

    public void setStorePassphrase(boolean storePassphrase) {
        if (storePassphrase) {
            this.myPassphraseState = PasswordState.Store;
        }
    }

    @Attribute(value="anonymous")
    public boolean isAnonymous() {
        return this.myCredentials.isAnonymous();
    }

    public void setAnonymous(boolean anonymous) {
        this.myCredentials.setAnonymous(anonymous);
    }

    @Attribute(value="privateKey")
    public String getPrivateKeyFile() {
        return this.myCredentials.getPrivateKeyFile();
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.myCredentials.setPrivateKeyFile(privateKeyFile);
    }

    @Attribute(value="knownHosts")
    public String getKnownHostsFile() {
        return this.myCredentials.getKnownHostsFile();
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.myCredentials.setKnownHostsFile(knownHostsFile);
    }

    @Transient
    public String getPassphrase() {
        return this.myCredentials.getPassphrase();
    }

    public void setPassphrase(String passphrase, boolean force) {
        this.myCredentials.setPassphrase(passphrase);
        if (force || StringUtil.isNotEmpty((String)passphrase)) {
            LOG.assertTrue(passphrase != null);
            this.myPassphraseState = PasswordState.Specified;
        } else {
            this.myPassphraseState = PasswordState.Unspecified;
        }
    }

    @Attribute(value="passphrase")
    @Deprecated
    @Nullable
    public String getSerializedPassphrase() {
        return null;
    }

    @Deprecated
    public void setSerializedPassphrase(String serializedPassphrase) {
        String passphrase;
        if (serializedPassphrase != null) {
            passphrase = PasswordUtil.decodePassword((String)serializedPassphrase);
            this.myPassphraseState = PasswordState.Store;
        } else {
            passphrase = null;
            this.myPassphraseState = PasswordState.Unspecified;
        }
        this.myCredentials.setPassphrase(passphrase);
    }

    @Attribute(value="keyPair")
    public boolean isUseKeyPair() {
        return this.myCredentials.isUseKeyPair();
    }

    public void setUseKeyPair(boolean useKeyPair) {
        this.myCredentials.setUseKeyPair(useKeyPair);
    }

    @Tag(value="advancedOptions")
    public AdvancedOptionsConfig getAdvancedOptions() {
        return this.myAdvancedOptions;
    }

    public void setAdvancedOptions(AdvancedOptionsConfig advancedOptions) {
        this.myAdvancedOptions = advancedOptions;
    }

    @Attribute(value="rootFolder")
    public String getRootFolder() {
        return this.myRootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.myRootFolder = rootFolder;
    }

    @Attribute(value="mountedRoot")
    public String getMountedFolder() {
        return this.myMountedFolder;
    }

    public void setMountedFolder(String mountedFolder) {
        this.myMountedFolder = mountedFolder;
    }

    @Attribute(value="explicitFtps")
    public boolean isFtpsExplicit() {
        return this.myFtpsExplicit;
    }

    public void setFtpsExplicit(boolean value) {
        this.myFtpsExplicit = value;
    }

    protected FileTransferConfig clone() {
        try {
            FileTransferConfig clone = (FileTransferConfig)super.clone();
            clone.setAdvancedOptions(this.myAdvancedOptions.clone());
            clone.myCredentials = this.myCredentials.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean canConnect() {
        return this.validateFast(false) == null;
    }

    @Nullable
    public String validateSlow(long timeout) throws TimeoutException {
        return this.validateSlow(true, timeout);
    }

    @Nullable
    public String validateSlow(long timeout, boolean checkRootFolder) throws TimeoutException {
        return this.validateSlow(checkRootFolder, timeout);
    }

    @Nullable
    public String validateFast() {
        return this.validateFast(true);
    }

    @Nullable
    public ErrorMessageAndField validateUiFast() {
        return this.validateUiFast(true);
    }

    @Nullable
    public String validateFast(boolean checkRootFolder) {
        ErrorMessageAndField error = this.validateUiFast(checkRootFolder);
        return error == null ? null : (String)error.getFirst();
    }

    @Nullable
    private ErrorMessageAndField validateUiFast(boolean checkRootFolder) {
        try {
            return this.validateUi(checkRootFolder, -1L, true);
        }
        catch (TimeoutException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private String validateSlow(boolean checkRootFolder, long timeout) throws TimeoutException {
        ErrorMessageAndField error = this.validateUi(checkRootFolder, timeout, false);
        return error == null ? null : (String)error.getFirst();
    }

    @Nullable
    private ErrorMessageAndField validateUi(boolean checkRootFolder, long timeout, boolean fast) throws TimeoutException {
        if (this.myAccessType == AccessType.LOCAL) {
            return null;
        }
        if (this.myAccessType == AccessType.MOUNT) {
            String message = this.validateMountFolder(timeout, fast);
            return message == null ? null : new ErrorMessageAndField(message, null);
        }
        ErrorMessageAndField credentialsResult = this.myCredentials.verify(this.myAccessType == AccessType.SFTP, this.myAccessType.getTitle(), fast, timeout);
        if (credentialsResult != null) {
            return credentialsResult;
        }
        if (checkRootFolder) {
            if (StringUtil.isEmptyOrSpaces((String)this.myRootFolder)) {
                return new ErrorMessageAndField(WDBundle.message("root.path.empty", new Object[0]), null);
            }
            if (!this.myRootFolder.startsWith("/")) {
                return new ErrorMessageAndField(WDBundle.message("root.path.invalid", new Object[0]), null);
            }
        }
        return null;
    }

    @Nullable
    private String validateMountFolder(long timeout, boolean fast) throws TimeoutException {
        String path = this.myMountedFolder;
        if (StringUtil.isEmpty((String)path)) {
            return WDBundle.message("mounted.folder.is.empty", new Object[0]);
        }
        if (SystemInfo.isWindows && path.length() == 2 && Character.isLetter(path.charAt(0)) && ':' == path.charAt(1)) {
            path = path + "\\";
        }
        if (SystemInfo.isWindows && path.startsWith("\\\\")) {
            return WDBundle.message("unc.path.not.supported", path);
        }
        if (path.equals("\\")) {
            return WDBundle.message("mounted.folder.not.found", FileUtil.toSystemDependentName((String)path));
        }
        if (!fast) {
            String finalPath = path;
            return (String)Util.runWithTimeout(timeout, () -> {
                File file = new File(finalPath);
                if (!file.isAbsolute()) {
                    return WDBundle.message("mounted.folder.is.not.absolute", new Object[0]);
                }
                try {
                    if (!file.getCanonicalFile().isDirectory()) {
                        return WDBundle.message("mounted.folder.not.found", FileUtil.toSystemDependentName((String)finalPath));
                    }
                }
                catch (IOException e) {
                    return WDBundle.message("mounted.folder.invalid", FileUtil.toSystemDependentName((String)finalPath), e.getMessage());
                }
                return null;
            });
        }
        return null;
    }

    @Nullable
    public String getNonBlockingWarnings() {
        if (this.myAccessType == AccessType.FTPS && this.getPort() == (this.myFtpsExplicit ? 990 : 21)) {
            return WDBundle.message("ftps.wrong.port.warning.message", new Object[0]);
        }
        return null;
    }

    public PasswordState getPasswordState() {
        return this.myPasswordState;
    }

    public PasswordState getPassphraseState() {
        return this.myPassphraseState;
    }

    public boolean updateOnPasswordStoreImpossible() {
        if (this.myPasswordState == PasswordState.Store) {
            this.myPasswordState = PasswordState.Specified;
            this.myCredentials.setStorePassword(false);
            return true;
        }
        return false;
    }

    public boolean updateOnPassphraseStoreImpossible() {
        if (this.myPassphraseState == PasswordState.Store) {
            this.myPassphraseState = PasswordState.Specified;
            this.myCredentials.setStorePassphrase(false);
            return true;
        }
        return false;
    }

    public void passwordStoreCleared() {
        this.myCredentials.setUserName(null);
        this.myCredentials.setPassword(null);
        this.myCredentials.setStorePassword(false);
        this.myPasswordState = PasswordState.Unspecified;
        this.myCredentials.setPassphrase(null);
        this.myCredentials.setStorePassphrase(false);
        this.myPassphraseState = PasswordState.Unspecified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTransferConfig that = (FileTransferConfig)o;
        return this.equalsNonAuthData(that) && this.equalsAuthData(that);
    }

    public boolean equalsNonAuthData(FileTransferConfig that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (this.isAnonymous() != that.isAnonymous()) {
            return false;
        }
        if (this.getLiteralPort() != null ? !this.getLiteralPort().equals(that.getLiteralPort()) : that.getLiteralPort() != null) {
            return false;
        }
        if (this.isUseKeyPair() != that.isUseKeyPair()) {
            return false;
        }
        if (this.myAdvancedOptions != null ? !this.myAdvancedOptions.equals(that.myAdvancedOptions) : that.myAdvancedOptions != null) {
            return false;
        }
        if (this.getHost() != null ? !this.getHost().equals(that.getHost()) : that.getHost() != null) {
            return false;
        }
        if (this.getKnownHostsFile() != null ? !this.getKnownHostsFile().equals(that.getKnownHostsFile()) : that.getKnownHostsFile() != null) {
            return false;
        }
        if (this.getPrivateKeyFile() != null ? !this.getPrivateKeyFile().equals(that.getPrivateKeyFile()) : that.getPrivateKeyFile() != null) {
            return false;
        }
        if (this.myAccessType != that.myAccessType) {
            return false;
        }
        if (this.myRootFolder != null ? !this.myRootFolder.equals(that.myRootFolder) : that.myRootFolder != null) {
            return false;
        }
        return !(this.myMountedFolder != null ? !this.myMountedFolder.equals(that.myMountedFolder) : that.myMountedFolder != null);
    }

    private boolean equalsAuthData(FileTransferConfig that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (this.getPassphrase() != null ? !this.getPassphrase().equals(that.getPassphrase()) : that.getPassphrase() != null) {
            return false;
        }
        if (this.myPassphraseState != that.myPassphraseState) {
            return false;
        }
        if (this.getPassword() != null ? !this.getPassword().equals(that.getPassword()) : that.getPassword() != null) {
            return false;
        }
        if (this.myPasswordState != that.myPasswordState) {
            return false;
        }
        return !(this.getUserName() != null ? !this.getUserName().equals(that.getUserName()) : that.getUserName() != null);
    }

    public int hashCode() {
        int result = this.myAccessType != null ? this.myAccessType.hashCode() : 0;
        result = 31 * result + (this.getHost() != null ? this.getHost().hashCode() : 0);
        result = 31 * result + (this.getLiteralPort() != null ? this.getLiteralPort().hashCode() : 0);
        result = 31 * result + (this.getUserName() != null ? this.getUserName().hashCode() : 0);
        result = 31 * result + (this.getPassword() != null ? this.getPassword().hashCode() : 0);
        result = 31 * result + (this.isAnonymous() ? 1 : 0);
        result = 31 * result + (this.getPrivateKeyFile() != null ? this.getPrivateKeyFile().hashCode() : 0);
        result = 31 * result + (this.getKnownHostsFile() != null ? this.getKnownHostsFile().hashCode() : 0);
        result = 31 * result + (this.getPassphrase() != null ? this.getPassphrase().hashCode() : 0);
        result = 31 * result + (this.myPassphraseState != null ? this.myPassphraseState.hashCode() : 0);
        result = 31 * result + (this.isUseKeyPair() ? 1 : 0);
        result = 31 * result + (this.myAdvancedOptions != null ? this.myAdvancedOptions.hashCode() : 0);
        result = 31 * result + (this.myRootFolder != null ? this.myRootFolder.hashCode() : 0);
        result = 31 * result + (this.myMountedFolder != null ? this.myMountedFolder.hashCode() : 0);
        return result;
    }

    public String getDisplayName() {
        if (this.myAccessType.isProtocolBased()) {
            if (StringUtil.isEmpty((String)this.getHost())) {
                return WDBundle.message("host.undefined", new Object[0]);
            }
            return MessageFormat.format("{0}://{1}:{2}", this.myAccessType.getScheme(), this.getHost(), this.getLiteralPort());
        }
        return WDBundle.message("accessType.mount.title", new Object[0]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public Icon getIcon() {
        return this.myAccessType.getIcon();
    }

    public String getRootUri() {
        if (this.getAccessType().isProtocolBased()) {
            return this.getAccessType().getScheme() + "://" + this.getHost() + ":" + this.getLiteralPort() + "/";
        }
        String scheme = "file://";
        String localPath = FileUtil.toSystemIndependentName((String)this.getMountedFolder());
        if (SystemInfo.isWindows && localPath.length() >= 2 && Character.isLetter(localPath.charAt(0)) && ':' == localPath.charAt(1)) {
            scheme = scheme + "/" + localPath.substring(0, 2) + "/";
            localPath = localPath.substring(2);
        }
        return scheme + localPath;
    }

    public static enum Origin {
        Unchanged,
        ForceRoot,
        Default;

    }

    public static enum PasswordState {
        Unspecified,
        Specified,
        Store;

    }
}

