/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.openshift.restclient.OpenShiftException;

public abstract class ApiTask<T> {
    private final CloudAgentErrorHandler myErrorHandler;

    public ApiTask(CloudAgentErrorHandler errorHandler) {
        this.myErrorHandler = errorHandler;
    }

    public T perform() {
        try {
            return this.doPerform();
        }
        catch (OpenShiftException ex) {
            this.onError(ex.toString());
            return null;
        }
        catch (RuntimeException ex) {
            this.onError(ex.toString());
            return null;
        }
    }

    protected void onError(String error) {
        this.myErrorHandler.onError(error);
    }

    protected abstract T doPerform() throws OpenShiftException;
}

