/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.os3.OS3Annotation;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Pod;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Port;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class OS3PodImpl
implements OS3Pod {
    private final IPod myPod;

    public OS3PodImpl(IPod pod) {
        this.myPod = pod;
    }

    public String getName() {
        return this.myPod.getName();
    }

    public String getHost() {
        return this.myPod.getHost();
    }

    public String getIp() {
        return this.myPod.getIP();
    }

    public String getStatus() {
        return this.myPod.getStatus();
    }

    public String[] getImages() {
        Collection images = this.myPod.getImages();
        return images.toArray(new String[images.size()]);
    }

    public OS3Port[] getContainerPorts() {
        ArrayList<1> result = new ArrayList<1>();
        Set ports = this.myPod.getContainerPorts();
        for (final IPort port : ports) {
            result.add(new OS3Port(){

                public String getName() {
                    return port.getName();
                }

                public int getContainerPort() {
                    return port.getContainerPort();
                }

                public String getProtocol() {
                    return port.getProtocol();
                }
            });
        }
        return result.toArray(new OS3Port[result.size()]);
    }

    public OS3Annotation[] getAnnotations() {
        ArrayList<OS3Annotation> result = new ArrayList<OS3Annotation>();
        for (Map.Entry annotation : this.myPod.getAnnotations().entrySet()) {
            result.add(new OS3Annotation((String)annotation.getKey(), (String)annotation.getValue()));
        }
        return result.toArray(new OS3Annotation[this.myPod.getAnnotations().size()]);
    }
}

