/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.flows;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiDirectory;
import icons.JsfIcons;
import org.jetbrains.annotations.NotNull;

public class FlowsPresentationUtils {
    public static LookupElementBuilder createExplicitFlowLookupElement(@NotNull String flowId) {
        if (flowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowId", "com/intellij/jsf/flows/FlowsPresentationUtils", "createExplicitFlowLookupElement"));
        }
        return LookupElementBuilder.create((String)flowId).withIcon(JsfIcons.Flow).withTypeText("Explicit Flow", true);
    }

    public static LookupElementBuilder createImplicitFlowLookupElement(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/jsf/flows/FlowsPresentationUtils", "createImplicitFlowLookupElement"));
        }
        return LookupElementBuilder.create((String)directory.getName()).withIcon(JsfIcons.Flow).withTypeText("Implicit Flow", true);
    }

    public static LookupElementBuilder createAnnotatedFlowLookupElement(@NotNull String flowId) {
        if (flowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowId", "com/intellij/jsf/flows/FlowsPresentationUtils", "createAnnotatedFlowLookupElement"));
        }
        return LookupElementBuilder.create((String)flowId).withIcon(JsfIcons.Flow).withTypeText("Annotated Flow", true);
    }

    public static LookupElementBuilder createAnnotatedViewLookupElement(@NotNull String flowName, @NotNull String viewId) {
        if (flowName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowName", "com/intellij/jsf/flows/FlowsPresentationUtils", "createAnnotatedViewLookupElement"));
        }
        if (viewId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewId", "com/intellij/jsf/flows/FlowsPresentationUtils", "createAnnotatedViewLookupElement"));
        }
        return LookupElementBuilder.create((String)viewId).withIcon(JsfIcons.NavigationRule).withTypeText("Annotated Flow: " + flowName);
    }
}

