/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsfJamManagedProperty
implements JamElement {
    public static final JamStringAttributeMeta.Single<String> NAME_META = JamAttributeMeta.singleString((String)"name");
    public static final JamStringAttributeMeta.Single<String> VALUE_META = JamAttributeMeta.singleString((String)"value");
    public static JamAnnotationMeta META = new JamAnnotationMeta("javax.faces.bean.ManagedProperty");

    @JamPsiConnector
    @NotNull
    public abstract PsiField getPsiElement();

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @Nullable
    public PsiAnnotation getAnnotation() {
        return META.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    @NotNull
    public String getName() {
        String nameValue = this.getNamedStringAttributeElement().getStringValue();
        String string = StringUtil.isEmptyOrSpaces((String)nameValue) ? this.getDefaultName() : nameValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/jam/JsfJamManagedProperty", "getName"));
        }
        return string;
    }

    @Nullable
    public String getValue() {
        return this.getValueStringAttributeElement().getStringValue();
    }

    private String getDefaultName() {
        return this.getPsiElement().getName();
    }

    @NotNull
    private JamStringAttributeElement<String> getNamedStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)META.getAttribute((PsiModifierListOwner)this.getPsiElement(), NAME_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/jam/JsfJamManagedProperty", "getNamedStringAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    @NotNull
    private JamStringAttributeElement<String> getValueStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)META.getAttribute((PsiModifierListOwner)this.getPsiElement(), VALUE_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/jam/JsfJamManagedProperty", "getValueStringAttributeElement"));
        }
        return jamStringAttributeElement;
    }
}

