/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.xml;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.impl.model.xml.FacesDomModelImpl;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.utils.FacesConfigUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.model.impl.BaseDomModelFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacesDomModelFactory
extends BaseDomModelFactory<WebFacet, FacesConfig, FacesDomModel, PsiElement> {
    public FacesDomModelFactory(Project project) {
        super(FacesConfig.class, project, "JsfModel");
    }

    @NotNull
    public Object[] computeDependencies(@Nullable FacesDomModel model, @Nullable WebFacet facet) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        if (facet != null) {
            dependencies.add(ProjectRootManager.getInstance((Project)facet.getModule().getProject()));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/FacesDomModelFactory", "computeDependencies"));
        }
        return objectArray;
    }

    protected List<FacesDomModel> computeAllModels(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/model/xml/FacesDomModelFactory", "computeAllModels"));
        }
        ArrayList<FacesDomModel> models = new ArrayList<FacesDomModel>();
        for (XmlFile xmlFile : FacesConfigUtils.getConfigurationFiles(webFacet)) {
            FacesDomModel seamModel = this.createSingleModel(xmlFile, webFacet);
            if (seamModel == null) continue;
            models.add(seamModel);
        }
        return models;
    }

    protected FacesDomModel computeModel(@NotNull XmlFile psiFile, @Nullable WebFacet webFacet) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/jsf/model/xml/FacesDomModelFactory", "computeModel"));
        }
        if (webFacet == null) {
            return null;
        }
        FacesDomModel model = (FacesDomModel)super.computeModel(psiFile, (UserDataHolder)webFacet);
        return model != null ? model : this.createSingleModel(psiFile, webFacet);
    }

    @Nullable
    private FacesDomModel createSingleModel(XmlFile psiFile, WebFacet webFacet) {
        DomFileElement componentsDomFileElement = this.getDomRoot(psiFile);
        if (componentsDomFileElement != null) {
            HashSet<XmlFile> files = new HashSet<XmlFile>();
            files.add(psiFile);
            DomFileElement fileElement = files.size() > 1 ? this.createMergedModelRoot(files) : componentsDomFileElement;
            return fileElement == null ? null : new FacesDomModelImpl(webFacet, (DomFileElement<FacesConfig>)fileElement, files);
        }
        return null;
    }

    protected FacesDomModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<FacesConfig> mergedModel, FacesDomModel firstModel, WebFacet webFacet) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/jsf/model/xml/FacesDomModelFactory", "createCombinedModel"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/jsf/model/xml/FacesDomModelFactory", "createCombinedModel"));
        }
        return new FacesDomModelImpl(webFacet, mergedModel, configFiles);
    }
}

